/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.TypeParameterRequirement;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.TypeSignatureParameter;
import com.facebook.presto.type.TypeRegistry;
import com.facebook.presto.util.ImmutableCollectors;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;

public final class Signature {
    private final String name;
    private final FunctionKind kind;
    private final List<TypeParameterRequirement> typeParameterRequirements;
    private final TypeSignature returnType;
    private final List<TypeSignature> argumentTypes;
    private final boolean variableArity;

    @JsonCreator
    public Signature(@JsonProperty(value="name") String name, @JsonProperty(value="kind") FunctionKind kind, @JsonProperty(value="typeParameterRequirements") List<TypeParameterRequirement> typeParameterRequirements, @JsonProperty(value="returnType") TypeSignature returnType, @JsonProperty(value="argumentTypes") List<TypeSignature> argumentTypes, @JsonProperty(value="variableArity") boolean variableArity) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(typeParameterRequirements, "typeParameters is null");
        this.name = name;
        this.kind = Objects.requireNonNull(kind, "type is null");
        this.typeParameterRequirements = ImmutableList.copyOf(typeParameterRequirements);
        this.returnType = Objects.requireNonNull(returnType, "returnType is null");
        this.argumentTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentTypes, "argumentTypes is null"));
        this.variableArity = variableArity;
    }

    public Signature(String name, FunctionKind kind, List<TypeParameterRequirement> typeParameterRequirements, String returnType, List<String> argumentTypes, boolean variableArity) {
        this(name, kind, typeParameterRequirements, TypeSignature.parseTypeSignature((String)returnType), Lists.transform(argumentTypes, TypeSignature::parseTypeSignature), variableArity);
    }

    public Signature(String name, FunctionKind kind, String returnType, List<String> argumentTypes) {
        this(name, kind, (List<TypeParameterRequirement>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)returnType), Lists.transform(argumentTypes, TypeSignature::parseTypeSignature), false);
    }

    public Signature(String name, FunctionKind kind, String returnType, String ... argumentTypes) {
        this(name, kind, returnType, (List<String>)ImmutableList.copyOf((Object[])argumentTypes));
    }

    public Signature(String name, FunctionKind kind, TypeSignature returnType, List<TypeSignature> argumentTypes) {
        this(name, kind, (List<TypeParameterRequirement>)ImmutableList.of(), returnType, argumentTypes, false);
    }

    public Signature(String name, FunctionKind kind, TypeSignature returnType, TypeSignature ... argumentTypes) {
        this(name, kind, returnType, (List<TypeSignature>)ImmutableList.copyOf((Object[])argumentTypes));
    }

    public static Signature internalOperator(OperatorType operator, Type returnType, List<? extends Type> argumentTypes) {
        return Signature.internalScalarFunction(FunctionRegistry.mangleOperatorName(operator.name()), returnType.getTypeSignature(), (List)argumentTypes.stream().map(Type::getTypeSignature).collect(ImmutableCollectors.toImmutableList()));
    }

    public static Signature internalOperator(String name, TypeSignature returnType, List<TypeSignature> argumentTypes) {
        return Signature.internalScalarFunction(FunctionRegistry.mangleOperatorName(name), returnType, argumentTypes);
    }

    public static Signature internalOperator(String name, TypeSignature returnType, TypeSignature ... argumentTypes) {
        return Signature.internalScalarFunction(FunctionRegistry.mangleOperatorName(name), returnType, (List<TypeSignature>)ImmutableList.copyOf((Object[])argumentTypes));
    }

    public static Signature internalScalarFunction(String name, String returnType, String ... argumentTypes) {
        return Signature.internalScalarFunction(name, returnType, (List<String>)ImmutableList.copyOf((Object[])argumentTypes));
    }

    public static Signature internalScalarFunction(String name, String returnType, List<String> argumentTypes) {
        return new Signature(name, FunctionKind.SCALAR, (List<TypeParameterRequirement>)ImmutableList.of(), returnType, argumentTypes, false);
    }

    public static Signature internalScalarFunction(String name, TypeSignature returnType, TypeSignature ... argumentTypes) {
        return Signature.internalScalarFunction(name, returnType, (List<TypeSignature>)ImmutableList.copyOf((Object[])argumentTypes));
    }

    public static Signature internalScalarFunction(String name, TypeSignature returnType, List<TypeSignature> argumentTypes) {
        return new Signature(name, FunctionKind.SCALAR, (List<TypeParameterRequirement>)ImmutableList.of(), returnType, argumentTypes, false);
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public FunctionKind getKind() {
        return this.kind;
    }

    @JsonProperty
    public TypeSignature getReturnType() {
        return this.returnType;
    }

    @JsonProperty
    public List<TypeSignature> getArgumentTypes() {
        return this.argumentTypes;
    }

    @JsonProperty
    public boolean isVariableArity() {
        return this.variableArity;
    }

    @JsonProperty
    public List<TypeParameterRequirement> getTypeParameterRequirements() {
        return this.typeParameterRequirements;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.kind, this.typeParameterRequirements, this.returnType, this.argumentTypes, this.variableArity});
    }

    Signature withAlias(String name) {
        return new Signature(name, this.kind, this.typeParameterRequirements, this.getReturnType(), this.getArgumentTypes(), this.variableArity);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Signature other = (Signature)obj;
        return Objects.equals(this.name, other.name) && Objects.equals((Object)this.kind, (Object)other.kind) && Objects.equals(this.typeParameterRequirements, other.typeParameterRequirements) && Objects.equals(this.returnType, other.returnType) && Objects.equals(this.argumentTypes, other.argumentTypes) && Objects.equals(this.variableArity, other.variableArity);
    }

    public String toString() {
        return this.name + (this.typeParameterRequirements.isEmpty() ? "" : "<" + Joiner.on((String)",").join(this.typeParameterRequirements) + ">") + "(" + Joiner.on((String)",").join(this.argumentTypes) + "):" + this.returnType;
    }

    @Nullable
    public Map<String, Type> bindTypeParameters(Type returnType, List<? extends Type> types, boolean allowCoercion, TypeManager typeManager) {
        HashMap<String, Type> boundParameters = new HashMap<String, Type>();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (TypeParameterRequirement parameter : this.typeParameterRequirements) {
            builder.put((Object)parameter.getName(), (Object)parameter);
        }
        ImmutableMap parameters = builder.build();
        if (!Signature.matchAndBind(boundParameters, (Map<String, TypeParameterRequirement>)parameters, this.returnType, returnType, allowCoercion, typeManager)) {
            return null;
        }
        if (!Signature.matchArguments(boundParameters, (Map<String, TypeParameterRequirement>)parameters, this.argumentTypes, types, allowCoercion, this.variableArity, typeManager)) {
            return null;
        }
        Preconditions.checkState((boolean)boundParameters.keySet().equals(parameters.keySet()), (String)"%s matched arguments %s, but type parameters %s are still unbound", (Object[])new Object[]{this, types, Sets.difference((Set)parameters.keySet(), boundParameters.keySet())});
        return boundParameters;
    }

    @Nullable
    public Map<String, Type> bindTypeParameters(List<? extends Type> types, boolean allowCoercion, TypeManager typeManager) {
        HashMap<String, Type> boundParameters = new HashMap<String, Type>();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (TypeParameterRequirement parameter : this.typeParameterRequirements) {
            builder.put((Object)parameter.getName(), (Object)parameter);
        }
        ImmutableMap parameters = builder.build();
        if (!Signature.matchArguments(boundParameters, (Map<String, TypeParameterRequirement>)parameters, this.argumentTypes, types, allowCoercion, this.variableArity, typeManager)) {
            return null;
        }
        Preconditions.checkState((boolean)boundParameters.keySet().equals(parameters.keySet()), (String)"%s matched arguments %s, but type parameters %s are still unbound", (Object[])new Object[]{this, types, Sets.difference((Set)parameters.keySet(), boundParameters.keySet())});
        return boundParameters;
    }

    private static boolean matchArguments(Map<String, Type> boundParameters, Map<String, TypeParameterRequirement> parameters, List<TypeSignature> argumentTypes, List<? extends Type> types, boolean allowCoercion, boolean varArgs, TypeManager typeManager) {
        if (varArgs ? types.size() < argumentTypes.size() - 1 : argumentTypes.size() != types.size()) {
            return false;
        }
        if (varArgs && types.size() >= argumentTypes.size()) {
            Optional superType = typeManager.getCommonSuperType(types.subList(argumentTypes.size() - 1, types.size()));
            if (!superType.isPresent()) {
                return false;
            }
            if (!Signature.matchAndBind(boundParameters, parameters, argumentTypes.get(argumentTypes.size() - 1), (Type)superType.get(), allowCoercion, typeManager)) {
                return false;
            }
        }
        for (int i = 0; i < types.size(); ++i) {
            Type type;
            TypeSignature typeSignature = argumentTypes.get(Math.min(i, argumentTypes.size() - 1));
            if (Signature.matchAndBind(boundParameters, parameters, typeSignature, type = types.get(i), allowCoercion, typeManager)) continue;
            return false;
        }
        return true;
    }

    private static boolean matchAndBind(Map<String, Type> boundParameters, Map<String, TypeParameterRequirement> typeParameters, TypeSignature parameter, Type type, boolean allowCoercion, TypeManager typeManager) {
        List parameters = parameter.getParameters();
        if (boundParameters.containsKey(parameter.getBase())) {
            Preconditions.checkArgument((boolean)parameters.isEmpty(), (Object)"Unexpected parameteric type");
            if (allowCoercion) {
                if (TypeRegistry.canCoerce(type, boundParameters.get(parameter.getBase()))) {
                    return true;
                }
                if (TypeRegistry.canCoerce(boundParameters.get(parameter.getBase()), type) && typeParameters.get(parameter.getBase()).canBind(type)) {
                    boundParameters.put(parameter.getBase(), type);
                    return true;
                }
                return false;
            }
            return type.equals(boundParameters.get(parameter.getBase()));
        }
        if (!parameters.isEmpty()) {
            if (type.getTypeParameters().size() != parameters.size()) {
                return false;
            }
            for (int i = 0; i < parameters.size(); ++i) {
                TypeSignature componentSignature;
                Type componentType = (Type)type.getTypeParameters().get(i);
                TypeSignatureParameter componentParameter = (TypeSignatureParameter)parameters.get(i);
                switch (componentParameter.getKind()) {
                    case TYPE_SIGNATURE: {
                        componentSignature = componentParameter.getTypeSignature();
                        break;
                    }
                    case NAMED_TYPE_SIGNATURE: {
                        componentSignature = componentParameter.getNamedTypeSignature().getTypeSignature();
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                if (Signature.matchAndBind(boundParameters, typeParameters, componentSignature, componentType, allowCoercion, typeManager)) continue;
                return false;
            }
        }
        if (typeParameters.containsKey(parameter.getBase())) {
            TypeParameterRequirement typeParameterRequirement = typeParameters.get(parameter.getBase());
            if (!typeParameterRequirement.canBind(type)) {
                return false;
            }
            boundParameters.put(parameter.getBase(), type);
            return true;
        }
        if (!parameters.isEmpty()) {
            return type.getTypeSignature().getBase().equals(parameter.getBase());
        }
        if (allowCoercion) {
            return TypeRegistry.canCoerce(type, typeManager.getType(TypeSignature.parseTypeSignature((String)parameter.getBase())));
        }
        return type.equals(typeManager.getType(TypeSignature.parseTypeSignature((String)parameter.getBase())));
    }

    public static TypeParameterRequirement withVariadicBound(String name, String variadicBound) {
        return new TypeParameterRequirement(name, false, false, variadicBound);
    }

    public static TypeParameterRequirement comparableWithVariadicBound(String name, String variadicBound) {
        return new TypeParameterRequirement(name, true, false, variadicBound);
    }

    public static TypeParameterRequirement typeParameter(String name) {
        return new TypeParameterRequirement(name, false, false, null);
    }

    public static TypeParameterRequirement comparableTypeParameter(String name) {
        return new TypeParameterRequirement(name, true, false, null);
    }

    public static TypeParameterRequirement orderableTypeParameter(String name) {
        return new TypeParameterRequirement(name, false, true, null);
    }
}

