/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.presto.OutputBuffers;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.scheduler.OutputBufferManager;
import com.google.common.base.Preconditions;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class PartitionedOutputBufferManager
implements OutputBufferManager {
    private final Consumer<OutputBuffers> outputBufferTarget;
    @GuardedBy(value="this")
    private final Map<TaskId, Integer> partitions = new LinkedHashMap<TaskId, Integer>();
    @GuardedBy(value="this")
    private boolean noMoreBufferIds;

    public PartitionedOutputBufferManager(Consumer<OutputBuffers> outputBufferTarget) {
        this.outputBufferTarget = Objects.requireNonNull(outputBufferTarget, "outputBufferTarget is null");
    }

    @Override
    public synchronized void addOutputBuffer(TaskId bufferId, int partition) {
        if (this.noMoreBufferIds) {
            return;
        }
        Preconditions.checkArgument((partition >= 0 ? 1 : 0) != 0, (Object)"partition is negative");
        this.partitions.put(bufferId, partition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noMoreOutputBuffers() {
        PartitionedOutputBufferManager partitionedOutputBufferManager = this;
        synchronized (partitionedOutputBufferManager) {
            if (this.noMoreBufferIds) {
                return;
            }
            this.noMoreBufferIds = true;
        }
        OutputBuffers outputBuffers = OutputBuffers.INITIAL_EMPTY_OUTPUT_BUFFERS.withBuffers(this.partitions).withNoMoreBufferIds();
        this.outputBufferTarget.accept(outputBuffers);
    }
}

