/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.execution.DataDefinitionTask;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.AddColumn;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.TableElement;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.type.UnknownType;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class AddColumnTask
implements DataDefinitionTask<AddColumn> {
    @Override
    public String getName() {
        return "ADD COLUMN";
    }

    @Override
    public CompletableFuture<?> execute(AddColumn statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine) {
        QualifiedObjectName tableName;
        Session session = stateMachine.getSession();
        Optional<TableHandle> tableHandle = metadata.getTableHandle(session, tableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getName()));
        if (!tableHandle.isPresent()) {
            throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)statement, "Table '%s' does not exist", tableName);
        }
        accessControl.checkCanAddColumns(session.getRequiredTransactionId(), session.getIdentity(), tableName);
        Map<String, ColumnHandle> columnHandles = metadata.getColumnHandles(session, tableHandle.get());
        TableElement element = statement.getColumn();
        Type type = metadata.getType(TypeSignature.parseTypeSignature((String)element.getType()));
        if (type == null || type.equals((Object)UnknownType.UNKNOWN)) {
            throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)element, "Unknown type for column '%s' ", element.getName());
        }
        if (columnHandles.containsKey(element.getName())) {
            throw new SemanticException(SemanticErrorCode.COLUMN_ALREADY_EXISTS, (Node)statement, "Column '%s' already exists", element.getName());
        }
        metadata.addColumn(session, tableHandle.get(), new ColumnMetadata(element.getName(), type, false));
        return CompletableFuture.completedFuture(null);
    }
}

