/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system;

import com.facebook.presto.connector.system.SystemColumnHandle;
import com.facebook.presto.connector.system.SystemTableHandle;
import com.facebook.presto.connector.system.SystemTableLayoutHandle;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.util.ImmutableCollectors;
import com.facebook.presto.util.Types;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SystemTablesMetadata
implements ConnectorMetadata {
    private final String connectorId;
    private final Map<SchemaTableName, ConnectorTableMetadata> tables;

    public SystemTablesMetadata(String connectorId, Set<SystemTable> tables) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId");
        this.tables = tables.stream().map(SystemTable::getTableMetadata).collect(Collectors.toMap(ConnectorTableMetadata::getTable, Function.identity()));
    }

    private SystemTableHandle checkTableHandle(ConnectorTableHandle tableHandle) {
        SystemTableHandle systemTableHandle = Types.checkType(tableHandle, SystemTableHandle.class, "tableHandle");
        Preconditions.checkArgument((boolean)this.tables.containsKey(systemTableHandle.getSchemaTableName()));
        return systemTableHandle;
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return (List)this.tables.keySet().stream().map(SchemaTableName::getSchemaName).distinct().collect(ImmutableCollectors.toImmutableList());
    }

    public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        if (!this.tables.containsKey(tableName)) {
            return null;
        }
        return SystemTableHandle.fromSchemaTableName(this.connectorId, tableName);
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle table, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        SystemTableHandle tableHandle = Types.checkType(table, SystemTableHandle.class, "table");
        ConnectorTableLayout layout = new ConnectorTableLayout((ConnectorTableLayoutHandle)new SystemTableLayoutHandle(tableHandle.getConnectorId(), tableHandle, (TupleDomain<ColumnHandle>)constraint.getSummary()));
        return ImmutableList.of((Object)new ConnectorTableLayoutResult(layout, constraint.getSummary()));
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        return new ConnectorTableLayout(handle);
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        SystemTableHandle systemTableHandle = this.checkTableHandle(tableHandle);
        return this.tables.get(systemTableHandle.getSchemaTableName());
    }

    public List<SchemaTableName> listTables(ConnectorSession session, String schemaNameOrNull) {
        if (schemaNameOrNull == null) {
            return ImmutableList.copyOf(this.tables.keySet());
        }
        return (List)this.tables.keySet().stream().filter(table -> table.getSchemaName().equals(schemaNameOrNull)).collect(ImmutableCollectors.toImmutableList());
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        String columnName;
        SystemTableHandle systemTableHandle = this.checkTableHandle(tableHandle);
        ConnectorTableMetadata tableMetadata = this.tables.get(systemTableHandle.getSchemaTableName());
        ColumnMetadata columnMetadata = MetadataUtil.findColumnMetadata(tableMetadata, columnName = Types.checkType(columnHandle, SystemColumnHandle.class, "columnHandle").getColumnName());
        Preconditions.checkArgument((columnMetadata != null ? 1 : 0) != 0, (String)"Column %s on table %s does not exist", (Object[])new Object[]{columnName, tableMetadata.getTable()});
        return columnMetadata;
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        SystemTableHandle systemTableHandle = this.checkTableHandle(tableHandle);
        return SystemColumnHandle.toSystemColumnHandles(systemTableHandle.getConnectorId(), this.tables.get(systemTableHandle.getSchemaTableName()));
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<SchemaTableName, ConnectorTableMetadata> entry : this.tables.entrySet()) {
            if (!prefix.matches(entry.getKey())) continue;
            builder.put((Object)entry.getKey(), (Object)entry.getValue().getColumns());
        }
        return builder.build();
    }
}

