/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.operator.InterpretedHashGenerator;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.FixedWidthType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class TypeUtils {
    public static final int EXPECTED_ARRAY_SIZE = 1024;
    public static final int NULL_HASH_CODE = 0;

    private TypeUtils() {
    }

    public static int expectedValueSize(Type type, int defaultSize) {
        if (type instanceof FixedWidthType) {
            return ((FixedWidthType)type).getFixedSize();
        }
        return defaultSize;
    }

    public static int hashPosition(Type type, Block block, int position) {
        if (block.isNull(position)) {
            return 0;
        }
        return type.hash(block, position);
    }

    public static long hashPosition(MethodHandle methodHandle, Type type, Block block, int position) {
        if (block.isNull(position)) {
            return 0L;
        }
        try {
            if (type.getJavaType() == Boolean.TYPE) {
                return methodHandle.invoke(type.getBoolean(block, position));
            }
            if (type.getJavaType() == Long.TYPE) {
                return methodHandle.invoke(type.getLong(block, position));
            }
            if (type.getJavaType() == Double.TYPE) {
                return methodHandle.invoke(type.getDouble(block, position));
            }
            if (type.getJavaType() == Slice.class) {
                return methodHandle.invoke(type.getSlice(block, position));
            }
            if (!type.getJavaType().isPrimitive()) {
                return methodHandle.invoke(type.getObject(block, position));
            }
            throw new UnsupportedOperationException("Unsupported native container type: " + type.getJavaType() + " with type " + type.getTypeSignature());
        }
        catch (Throwable throwable) {
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static boolean positionEqualsPosition(Type type, Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        boolean leftIsNull = leftBlock.isNull(leftPosition);
        boolean rightIsNull = rightBlock.isNull(rightPosition);
        if (leftIsNull || rightIsNull) {
            return leftIsNull && rightIsNull;
        }
        return type.equalTo(leftBlock, leftPosition, rightBlock, rightPosition);
    }

    public static List<Type> resolveTypes(List<TypeSignature> typeNames, TypeManager typeManager) {
        return (List)typeNames.stream().map(type -> Objects.requireNonNull(typeManager.getType(type), String.format("Type '%s' not found", type))).collect(ImmutableCollectors.toImmutableList());
    }

    public static TypeSignature parameterizedTypeName(String base, TypeSignature ... argumentNames) {
        return new TypeSignature(base, (List)ImmutableList.copyOf((Object[])argumentNames), (List)ImmutableList.of());
    }

    public static int getHashPosition(List<? extends Type> hashTypes, Block[] hashBlocks, int position) {
        int[] hashChannels = new int[hashBlocks.length];
        for (int i = 0; i < hashBlocks.length; ++i) {
            hashChannels[i] = i;
        }
        InterpretedHashGenerator hashGenerator = new InterpretedHashGenerator((List<Type>)ImmutableList.copyOf(hashTypes), hashChannels);
        Page page = new Page(hashBlocks);
        return hashGenerator.hashPosition(position, page);
    }

    public static Block getHashBlock(List<? extends Type> hashTypes, Block ... hashBlocks) {
        Preconditions.checkArgument((hashTypes.size() == hashBlocks.length ? 1 : 0) != 0);
        int[] hashChannels = new int[hashBlocks.length];
        for (int i = 0; i < hashBlocks.length; ++i) {
            hashChannels[i] = i;
        }
        InterpretedHashGenerator hashGenerator = new InterpretedHashGenerator((List<Type>)ImmutableList.copyOf(hashTypes), hashChannels);
        int positionCount = hashBlocks[0].getPositionCount();
        BlockBuilder builder = BigintType.BIGINT.createFixedSizeBlockBuilder(positionCount);
        Page page = new Page(hashBlocks);
        for (int i = 0; i < positionCount; ++i) {
            BigintType.BIGINT.writeLong(builder, (long)hashGenerator.hashPosition(i, page));
        }
        return builder.build();
    }

    public static Page getHashPage(Page page, List<? extends Type> types, List<Integer> hashChannels) {
        Block[] blocks = Arrays.copyOf(page.getBlocks(), page.getChannelCount() + 1);
        ImmutableList.Builder hashTypes = ImmutableList.builder();
        Block[] hashBlocks = new Block[hashChannels.size()];
        int hashBlockIndex = 0;
        for (int channel : hashChannels) {
            hashTypes.add((Object)types.get(channel));
            hashBlocks[hashBlockIndex++] = blocks[channel];
        }
        blocks[page.getChannelCount()] = TypeUtils.getHashBlock((List<? extends Type>)hashTypes.build(), hashBlocks);
        return new Page(blocks);
    }

    public static void checkElementNotNull(boolean isNull, String errorMsg) {
        if (isNull) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, errorMsg);
        }
    }
}

