/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.ArrayBlockBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.InterleavedBlockBuilder;
import com.facebook.presto.spi.type.AbstractType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.TypeUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class MapType
extends AbstractType {
    private final Type keyType;
    private final Type valueType;
    private static final String MAP_NULL_ELEMENT_MSG = "MAP comparison not supported for null value elements";
    private static final int EXPECTED_BYTES_PER_ENTRY = 32;

    public MapType(Type keyType, Type valueType) {
        super(TypeUtils.parameterizedTypeName("map", keyType.getTypeSignature(), valueType.getTypeSignature()), Block.class);
        Preconditions.checkArgument((boolean)keyType.isComparable(), (Object)"key type must be comparable");
        this.keyType = keyType;
        this.valueType = valueType;
    }

    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        return new ArrayBlockBuilder((BlockBuilder)new InterleavedBlockBuilder(this.getTypeParameters(), blockBuilderStatus, expectedEntries * 2, expectedBytesPerEntry), blockBuilderStatus, expectedEntries);
    }

    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, 32);
    }

    public Type getKeyType() {
        return this.keyType;
    }

    public Type getValueType() {
        return this.valueType;
    }

    public boolean isComparable() {
        return this.valueType.isComparable();
    }

    public int hash(Block block, int position) {
        Block mapBlock = this.getObject(block, position);
        int result = 0;
        for (int i = 0; i < mapBlock.getPositionCount(); i += 2) {
            result += TypeUtils.hashPosition(this.keyType, mapBlock, i);
            result += TypeUtils.hashPosition(this.valueType, mapBlock, i + 1);
        }
        return result;
    }

    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        int position;
        Block leftMapBlock = (Block)leftBlock.getObject(leftPosition, Block.class);
        Block rightMapBlock = (Block)rightBlock.getObject(rightPosition, Block.class);
        if (leftMapBlock.getPositionCount() != rightMapBlock.getPositionCount()) {
            return false;
        }
        HashMap<KeyWrapper, Integer> wrappedLeftMap = new HashMap<KeyWrapper, Integer>();
        for (position = 0; position < leftMapBlock.getPositionCount(); position += 2) {
            wrappedLeftMap.put(new KeyWrapper(this.keyType, leftMapBlock, position), position + 1);
        }
        for (position = 0; position < rightMapBlock.getPositionCount(); position += 2) {
            KeyWrapper key = new KeyWrapper(this.keyType, rightMapBlock, position);
            Integer leftValuePosition = (Integer)wrappedLeftMap.get(key);
            if (leftValuePosition == null) {
                return false;
            }
            int rightValuePosition = position + 1;
            TypeUtils.checkElementNotNull(leftMapBlock.isNull(leftValuePosition.intValue()), MAP_NULL_ELEMENT_MSG);
            TypeUtils.checkElementNotNull(rightMapBlock.isNull(rightValuePosition), MAP_NULL_ELEMENT_MSG);
            if (this.valueType.equalTo(leftMapBlock, leftValuePosition.intValue(), rightMapBlock, rightValuePosition)) continue;
            return false;
        }
        return true;
    }

    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        Block mapBlock = (Block)block.getObject(position, Block.class);
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; i < mapBlock.getPositionCount(); i += 2) {
            map.put(this.keyType.getObjectValue(session, mapBlock, i), this.valueType.getObjectValue(session, mapBlock, i + 1));
        }
        return Collections.unmodifiableMap(map);
    }

    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            block.writePositionTo(position, blockBuilder);
            blockBuilder.closeEntry();
        }
    }

    public Block getObject(Block block, int position) {
        return (Block)block.getObject(position, Block.class);
    }

    public void writeObject(BlockBuilder blockBuilder, Object value) {
        blockBuilder.writeObject(value).closeEntry();
    }

    public List<Type> getTypeParameters() {
        return ImmutableList.of((Object)this.getKeyType(), (Object)this.getValueType());
    }

    public String getDisplayName() {
        return "map<" + this.keyType.getDisplayName() + ", " + this.valueType.getDisplayName() + ">";
    }

    private static final class KeyWrapper {
        private final Type type;
        private final Block block;
        private final int position;

        public KeyWrapper(Type type, Block block, int position) {
            this.type = type;
            this.block = block;
            this.position = position;
        }

        public Block getBlock() {
            return this.block;
        }

        public int getPosition() {
            return this.position;
        }

        public int hashCode() {
            return this.type.hash(this.block, this.position);
        }

        public boolean equals(Object obj) {
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            KeyWrapper other = (KeyWrapper)obj;
            return this.type.equalTo(this.block, this.position, other.getBlock(), other.getPosition());
        }
    }
}

