/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.operator.scalar.CombineHashFunction;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.ArrayBlockBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.AbstractType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.TypeUtils;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ArrayType
extends AbstractType {
    private final Type elementType;
    public static final String ARRAY_NULL_ELEMENT_MSG = "ARRAY comparison not supported for arrays with null elements";

    public ArrayType(Type elementType) {
        super(TypeUtils.parameterizedTypeName("array", elementType.getTypeSignature()), Block.class);
        this.elementType = Objects.requireNonNull(elementType, "elementType is null");
    }

    public Type getElementType() {
        return this.elementType;
    }

    public boolean isComparable() {
        return this.elementType.isComparable();
    }

    public boolean isOrderable() {
        return this.elementType.isOrderable();
    }

    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        Block leftArray = (Block)leftBlock.getObject(leftPosition, Block.class);
        Block rightArray = (Block)rightBlock.getObject(rightPosition, Block.class);
        if (leftArray.getPositionCount() != rightArray.getPositionCount()) {
            return false;
        }
        for (int i = 0; i < leftArray.getPositionCount(); ++i) {
            TypeUtils.checkElementNotNull(leftArray.isNull(i), ARRAY_NULL_ELEMENT_MSG);
            TypeUtils.checkElementNotNull(rightArray.isNull(i), ARRAY_NULL_ELEMENT_MSG);
            if (this.elementType.equalTo(leftArray, i, rightArray, i)) continue;
            return false;
        }
        return true;
    }

    public int hash(Block block, int position) {
        Block array = this.getObject(block, position);
        int hash = 0;
        for (int i = 0; i < array.getPositionCount(); ++i) {
            TypeUtils.checkElementNotNull(array.isNull(i), ARRAY_NULL_ELEMENT_MSG);
            hash = (int)CombineHashFunction.getHash(hash, this.elementType.hash(array, i));
        }
        return hash;
    }

    public int compareTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        int index;
        if (!this.elementType.isOrderable()) {
            throw new UnsupportedOperationException(this.getTypeSignature() + " type is not orderable");
        }
        Block leftArray = (Block)leftBlock.getObject(leftPosition, Block.class);
        Block rightArray = (Block)rightBlock.getObject(rightPosition, Block.class);
        int len = Math.min(leftArray.getPositionCount(), rightArray.getPositionCount());
        for (index = 0; index < len; ++index) {
            TypeUtils.checkElementNotNull(leftArray.isNull(index), ARRAY_NULL_ELEMENT_MSG);
            TypeUtils.checkElementNotNull(rightArray.isNull(index), ARRAY_NULL_ELEMENT_MSG);
            int comparison = this.elementType.compareTo(leftArray, index, rightArray, index);
            if (comparison == 0) continue;
            return comparison;
        }
        if (index == len) {
            return leftArray.getPositionCount() - rightArray.getPositionCount();
        }
        return 0;
    }

    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        Block arrayBlock = (Block)block.getObject(position, Block.class);
        ArrayList<Object> values = new ArrayList<Object>(arrayBlock.getPositionCount());
        for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
            values.add(this.elementType.getObjectValue(session, arrayBlock, i));
        }
        return Collections.unmodifiableList(values);
    }

    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            block.writePositionTo(position, blockBuilder);
            blockBuilder.closeEntry();
        }
    }

    public Slice getSlice(Block block, int position) {
        return block.getSlice(position, 0, block.getLength(position));
    }

    public void writeSlice(BlockBuilder blockBuilder, Slice value) {
        this.writeSlice(blockBuilder, value, 0, value.length());
    }

    public void writeSlice(BlockBuilder blockBuilder, Slice value, int offset, int length) {
        blockBuilder.writeBytes(value, offset, length).closeEntry();
    }

    public Block getObject(Block block, int position) {
        return (Block)block.getObject(position, Block.class);
    }

    public void writeObject(BlockBuilder blockBuilder, Object value) {
        blockBuilder.writeObject(value).closeEntry();
    }

    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        return new ArrayBlockBuilder(this.elementType, blockBuilderStatus, expectedEntries, expectedBytesPerEntry);
    }

    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, 100);
    }

    public List<Type> getTypeParameters() {
        return ImmutableList.of((Object)this.getElementType());
    }

    public String getDisplayName() {
        return "array<" + this.elementType.getDisplayName() + ">";
    }
}

