/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.testing;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.testing.MaterializedResult;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public class MaterializingOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final MaterializedResult.Builder resultBuilder;
    private boolean finished;
    private boolean closed;

    public MaterializingOperator(OperatorContext operatorContext, List<Type> sourceTypes) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.resultBuilder = MaterializedResult.resultBuilder(operatorContext.getSession(), sourceTypes);
    }

    public MaterializingOperator(OperatorContext operatorContext, MaterializedResult.Builder resultBuilder) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.resultBuilder = Objects.requireNonNull(resultBuilder, "resultBuilder is null");
    }

    public boolean isClosed() {
        return this.closed;
    }

    public MaterializedResult getMaterializedResult() {
        return this.resultBuilder.build();
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return ImmutableList.of();
    }

    @Override
    public void finish() {
        this.finished = true;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public boolean needsInput() {
        return !this.finished;
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"operator finished");
        this.resultBuilder.page(page);
        this.operatorContext.recordGeneratedOutput(page.getSizeInBytes(), page.getPositionCount());
    }

    @Override
    public Page getOutput() {
        return null;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    public static class MaterializingOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final List<Type> sourceTypes;
        private boolean closed;

        public MaterializingOperatorFactory(int operatorId, List<Type> sourceTypes) {
            this.operatorId = operatorId;
            this.sourceTypes = sourceTypes;
        }

        @Override
        public List<Type> getTypes() {
            return ImmutableList.of();
        }

        @Override
        public MaterializingOperator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, MaterializingOperator.class.getSimpleName());
            return new MaterializingOperator(operatorContext, this.sourceTypes);
        }

        @Override
        public void close() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new MaterializingOperatorFactory(this.operatorId, this.sourceTypes);
        }
    }
}

