/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.sql.planner.PartitionFunctionBinding;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ExchangeNode
extends PlanNode {
    private final Type type;
    private final List<Symbol> outputs;
    private final List<PlanNode> sources;
    private final Optional<PartitionFunctionBinding> partitionFunction;
    private final List<List<Symbol>> inputs;

    @JsonCreator
    public ExchangeNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="type") Type type, @JsonProperty(value="partitionFunction") Optional<PartitionFunctionBinding> partitionFunction, @JsonProperty(value="sources") List<PlanNode> sources, @JsonProperty(value="outputs") List<Symbol> outputs, @JsonProperty(value="inputs") List<List<Symbol>> inputs) {
        super(id);
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(sources, "sources is null");
        Objects.requireNonNull(partitionFunction, "partitionFunction is null");
        Objects.requireNonNull(outputs, "outputs is null");
        Objects.requireNonNull(inputs, "inputs is null");
        if (type == Type.REPARTITION) {
            Preconditions.checkArgument((boolean)partitionFunction.isPresent(), (Object)"Repartitioning exchange must contain a partition function");
        }
        partitionFunction.map(PartitionFunctionBinding::getPartitioningColumns).ifPresent(list -> Preconditions.checkArgument((boolean)outputs.containsAll((Collection<?>)list), (Object)"outputs must contain all partitionKeys"));
        partitionFunction.map(PartitionFunctionBinding::getHashColumn).ifPresent(hashSymbol -> Preconditions.checkArgument((!hashSymbol.isPresent() || outputs.contains(hashSymbol.get()) ? 1 : 0) != 0, (Object)"outputs must contain hashSymbol"));
        Preconditions.checkArgument((boolean)inputs.stream().allMatch(inputSymbols -> inputSymbols.size() == outputs.size()), (Object)"Input symbols do not match output symbols");
        Preconditions.checkArgument((inputs.size() == sources.size() ? 1 : 0) != 0, (Object)"Must have same number of input lists as sources");
        for (int i = 0; i < inputs.size(); ++i) {
            Preconditions.checkArgument((boolean)sources.get(i).getOutputSymbols().containsAll((Collection)inputs.get(i)), (Object)"Source does not supply all required input symbols");
        }
        this.type = type;
        this.sources = sources;
        this.partitionFunction = partitionFunction;
        this.outputs = ImmutableList.copyOf(outputs);
        this.inputs = ImmutableList.copyOf(inputs);
    }

    public static ExchangeNode partitionedExchange(PlanNodeId id, PlanNode child, PartitionFunctionBinding partitionFunction) {
        return new ExchangeNode(id, Type.REPARTITION, Optional.of(partitionFunction), (List<PlanNode>)ImmutableList.of((Object)child), child.getOutputSymbols(), (List<List<Symbol>>)ImmutableList.of(child.getOutputSymbols()));
    }

    public static ExchangeNode replicatedExchange(PlanNodeId id, PlanNode child) {
        return new ExchangeNode(id, Type.REPLICATE, Optional.empty(), (List<PlanNode>)ImmutableList.of((Object)child), child.getOutputSymbols(), (List<List<Symbol>>)ImmutableList.of(child.getOutputSymbols()));
    }

    public static ExchangeNode gatheringExchange(PlanNodeId id, PlanNode child) {
        return new ExchangeNode(id, Type.GATHER, Optional.empty(), (List<PlanNode>)ImmutableList.of((Object)child), child.getOutputSymbols(), (List<List<Symbol>>)ImmutableList.of(child.getOutputSymbols()));
    }

    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @Override
    public List<PlanNode> getSources() {
        return this.sources;
    }

    @Override
    @JsonProperty(value="outputs")
    public List<Symbol> getOutputSymbols() {
        return this.outputs;
    }

    @JsonProperty
    public Optional<PartitionFunctionBinding> getPartitionFunction() {
        return this.partitionFunction;
    }

    public Optional<List<Symbol>> getPartitionKeys() {
        return this.partitionFunction.map(PartitionFunctionBinding::getPartitioningColumns);
    }

    public Optional<Symbol> getHashSymbol() {
        return this.partitionFunction.flatMap(PartitionFunctionBinding::getHashColumn);
    }

    @JsonProperty
    public List<List<Symbol>> getInputs() {
        return this.inputs;
    }

    @Override
    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitExchange(this, context);
    }

    public static enum Type {
        GATHER,
        REPARTITION,
        REPLICATE;

    }
}

