/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.DistinctLimitNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class HashGenerationOptimizer
extends PlanOptimizer {
    public static final int INITIAL_HASH_VALUE = 0;
    private static final String HASH_CODE = FunctionRegistry.mangleOperatorName("HASH_CODE");

    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        if (SystemSessionProperties.isOptimizeHashGenerationEnabled(session)) {
            return SimplePlanRewriter.rewriteWith(new Rewriter(idAllocator, symbolAllocator, types), plan, null);
        }
        return plan;
    }

    private static ProjectNode getHashProjectNode(PlanNodeIdAllocator idAllocator, PlanNode source, Symbol hashSymbol, List<Symbol> partitioningSymbols) {
        Preconditions.checkArgument((!partitioningSymbols.isEmpty() ? 1 : 0) != 0, (Object)"partitioningSymbols is empty");
        ImmutableMap.Builder outputSymbols = ImmutableMap.builder();
        for (Symbol symbol : source.getOutputSymbols()) {
            QualifiedNameReference expression = new QualifiedNameReference(symbol.toQualifiedName());
            outputSymbols.put((Object)symbol, (Object)expression);
        }
        Expression hashExpression = HashGenerationOptimizer.getHashExpression(partitioningSymbols);
        outputSymbols.put((Object)hashSymbol, (Object)hashExpression);
        return new ProjectNode(idAllocator.getNextId(), source, (Map<Symbol, Expression>)outputSymbols.build());
    }

    private static Expression getHashExpression(List<Symbol> partitioningSymbols) {
        LongLiteral hashExpression = new LongLiteral(String.valueOf(0));
        for (Symbol symbol : partitioningSymbols) {
            hashExpression = HashGenerationOptimizer.getHashFunctionCall((Expression)hashExpression, symbol);
        }
        return hashExpression;
    }

    private static Expression getHashFunctionCall(Expression previousHashValue, Symbol symbol) {
        FunctionCall functionCall = new FunctionCall(QualifiedName.of((String)HASH_CODE, (String[])new String[0]), Optional.empty(), false, (List)ImmutableList.of((Object)new QualifiedNameReference(symbol.toQualifiedName())));
        ImmutableList arguments = ImmutableList.of((Object)previousHashValue, (Object)HashGenerationOptimizer.orNullHashCode((Expression)functionCall));
        return new FunctionCall(QualifiedName.of((String)"combine_hash", (String[])new String[0]), (List)arguments);
    }

    private static Expression orNullHashCode(Expression expression) {
        return new CoalesceExpression(new Expression[]{expression, new LongLiteral(String.valueOf(0))});
    }

    private static class Rewriter
    extends SimplePlanRewriter<Void> {
        private final PlanNodeIdAllocator idAllocator;
        private final SymbolAllocator symbolAllocator;
        private final Map<Symbol, Type> types;

        private Rewriter(PlanNodeIdAllocator idAllocator, SymbolAllocator symbolAllocator, Map<Symbol, Type> types) {
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
            this.symbolAllocator = Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
            this.types = Objects.requireNonNull(types, "types is null");
        }

        @Override
        public PlanNode visitAggregation(AggregationNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode rewrittenSource = context.rewrite(node.getSource(), null);
            if (rewrittenSource == node.getSource() && node.getGroupBy().isEmpty()) {
                return node;
            }
            if (node.getGroupBy().isEmpty() || this.canSkipHashGeneration(node)) {
                return new AggregationNode(this.idAllocator.getNextId(), rewrittenSource, node.getGroupBy(), node.getAggregations(), node.getFunctions(), node.getMasks(), node.getStep(), node.getSampleWeight(), node.getConfidence(), Optional.empty());
            }
            Symbol hashSymbol = this.symbolAllocator.newHashSymbol();
            ProjectNode hashProjectNode = HashGenerationOptimizer.getHashProjectNode(this.idAllocator, rewrittenSource, hashSymbol, node.getGroupBy());
            return new AggregationNode(this.idAllocator.getNextId(), hashProjectNode, node.getGroupBy(), node.getAggregations(), node.getFunctions(), node.getMasks(), node.getStep(), node.getSampleWeight(), node.getConfidence(), Optional.of(hashSymbol));
        }

        private boolean canSkipHashGeneration(AggregationNode node) {
            return node.getGroupBy().size() == 1 && this.types.get(Iterables.getOnlyElement(node.getGroupBy())).equals(BigintType.BIGINT);
        }

        @Override
        public PlanNode visitDistinctLimit(DistinctLimitNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode rewrittenSource = context.rewrite(node.getSource(), null);
            Symbol hashSymbol = this.symbolAllocator.newHashSymbol();
            ProjectNode hashProjectNode = HashGenerationOptimizer.getHashProjectNode(this.idAllocator, rewrittenSource, hashSymbol, node.getOutputSymbols());
            return new DistinctLimitNode(this.idAllocator.getNextId(), hashProjectNode, node.getLimit(), Optional.of(hashSymbol));
        }

        @Override
        public PlanNode visitMarkDistinct(MarkDistinctNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode rewrittenSource = context.rewrite(node.getSource(), null);
            Symbol hashSymbol = this.symbolAllocator.newHashSymbol();
            ProjectNode hashProjectNode = HashGenerationOptimizer.getHashProjectNode(this.idAllocator, rewrittenSource, hashSymbol, node.getDistinctSymbols());
            return new MarkDistinctNode(this.idAllocator.getNextId(), hashProjectNode, node.getMarkerSymbol(), node.getDistinctSymbols(), Optional.of(hashSymbol));
        }

        @Override
        public PlanNode visitRowNumber(RowNumberNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode rewrittenSource = context.rewrite(node.getSource(), null);
            if (rewrittenSource == node.getSource() && node.getPartitionBy().isEmpty()) {
                return node;
            }
            if (!node.getPartitionBy().isEmpty()) {
                Symbol hashSymbol = this.symbolAllocator.newHashSymbol();
                ProjectNode hashProjectNode = HashGenerationOptimizer.getHashProjectNode(this.idAllocator, rewrittenSource, hashSymbol, node.getPartitionBy());
                return new RowNumberNode(this.idAllocator.getNextId(), hashProjectNode, node.getPartitionBy(), node.getRowNumberSymbol(), node.getMaxRowCountPerPartition(), Optional.of(hashSymbol));
            }
            return new RowNumberNode(this.idAllocator.getNextId(), rewrittenSource, node.getPartitionBy(), node.getRowNumberSymbol(), node.getMaxRowCountPerPartition(), node.getHashSymbol());
        }

        @Override
        public PlanNode visitTopNRowNumber(TopNRowNumberNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode rewrittenSource = context.rewrite(node.getSource(), null);
            if (rewrittenSource == node.getSource() && node.getPartitionBy().isEmpty()) {
                return node;
            }
            if (node.getPartitionBy().isEmpty()) {
                return new TopNRowNumberNode(this.idAllocator.getNextId(), rewrittenSource, node.getPartitionBy(), node.getOrderBy(), node.getOrderings(), node.getRowNumberSymbol(), node.getMaxRowCountPerPartition(), node.isPartial(), node.getHashSymbol());
            }
            Symbol hashSymbol = this.symbolAllocator.newHashSymbol();
            ProjectNode hashProjectNode = HashGenerationOptimizer.getHashProjectNode(this.idAllocator, rewrittenSource, hashSymbol, node.getPartitionBy());
            return new TopNRowNumberNode(this.idAllocator.getNextId(), hashProjectNode, node.getPartitionBy(), node.getOrderBy(), node.getOrderings(), node.getRowNumberSymbol(), node.getMaxRowCountPerPartition(), node.isPartial(), Optional.of(hashSymbol));
        }

        @Override
        public PlanNode visitJoin(JoinNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            List<JoinNode.EquiJoinClause> clauses = node.getCriteria();
            List leftSymbols = Lists.transform(clauses, JoinNode.EquiJoinClause::getLeft);
            List rightSymbols = Lists.transform(clauses, JoinNode.EquiJoinClause::getRight);
            PlanNode rewrittenLeft = context.rewrite(node.getLeft(), null);
            PlanNode rewrittenRight = context.rewrite(node.getRight(), null);
            if (clauses.isEmpty()) {
                return new JoinNode(this.idAllocator.getNextId(), JoinNode.Type.INNER, rewrittenLeft, rewrittenRight, node.getCriteria(), Optional.empty(), Optional.empty());
            }
            Symbol leftHashSymbol = this.symbolAllocator.newHashSymbol();
            Symbol rightHashSymbol = this.symbolAllocator.newHashSymbol();
            ProjectNode leftHashProjectNode = HashGenerationOptimizer.getHashProjectNode(this.idAllocator, rewrittenLeft, leftHashSymbol, leftSymbols);
            ProjectNode rightHashProjectNode = HashGenerationOptimizer.getHashProjectNode(this.idAllocator, rewrittenRight, rightHashSymbol, rightSymbols);
            return new JoinNode(this.idAllocator.getNextId(), node.getType(), leftHashProjectNode, rightHashProjectNode, node.getCriteria(), Optional.of(leftHashSymbol), Optional.of(rightHashSymbol));
        }

        @Override
        public PlanNode visitSemiJoin(SemiJoinNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode rewrittenSource = context.rewrite(node.getSource(), null);
            PlanNode rewrittenFilteringSource = context.rewrite(node.getFilteringSource(), null);
            Symbol sourceHashSymbol = this.symbolAllocator.newHashSymbol();
            Symbol filteringSourceHashSymbol = this.symbolAllocator.newHashSymbol();
            ProjectNode sourceHashProjectNode = HashGenerationOptimizer.getHashProjectNode(this.idAllocator, rewrittenSource, sourceHashSymbol, (List)ImmutableList.of((Object)node.getSourceJoinSymbol()));
            ProjectNode filteringSourceHashProjectNode = HashGenerationOptimizer.getHashProjectNode(this.idAllocator, rewrittenFilteringSource, filteringSourceHashSymbol, (List)ImmutableList.of((Object)node.getFilteringSourceJoinSymbol()));
            return new SemiJoinNode(this.idAllocator.getNextId(), sourceHashProjectNode, filteringSourceHashProjectNode, node.getSourceJoinSymbol(), node.getFilteringSourceJoinSymbol(), node.getSemiJoinOutput(), Optional.of(sourceHashSymbol), Optional.of(filteringSourceHashSymbol));
        }

        @Override
        public PlanNode visitIndexJoin(IndexJoinNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode rewrittenIndex = context.rewrite(node.getIndexSource(), null);
            PlanNode rewrittenProbe = context.rewrite(node.getProbeSource(), null);
            Symbol indexHashSymbol = this.symbolAllocator.newHashSymbol();
            Symbol probeHashSymbol = this.symbolAllocator.newHashSymbol();
            List<IndexJoinNode.EquiJoinClause> clauses = node.getCriteria();
            List indexSymbols = Lists.transform(clauses, IndexJoinNode.EquiJoinClause::getIndex);
            List probeSymbols = Lists.transform(clauses, IndexJoinNode.EquiJoinClause::getProbe);
            ProjectNode indexHashProjectNode = HashGenerationOptimizer.getHashProjectNode(this.idAllocator, rewrittenIndex, indexHashSymbol, indexSymbols);
            ProjectNode probeHashProjectNode = HashGenerationOptimizer.getHashProjectNode(this.idAllocator, rewrittenProbe, probeHashSymbol, probeSymbols);
            return new IndexJoinNode(this.idAllocator.getNextId(), node.getType(), probeHashProjectNode, indexHashProjectNode, node.getCriteria(), Optional.of(probeHashSymbol), Optional.of(indexHashSymbol));
        }

        @Override
        public PlanNode visitWindow(WindowNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode rewrittenSource = context.rewrite(node.getSource(), null);
            if (rewrittenSource == node.getSource() && node.getPartitionBy().isEmpty()) {
                return node;
            }
            if (node.getPartitionBy().isEmpty()) {
                return new WindowNode(this.idAllocator.getNextId(), rewrittenSource, node.getPartitionBy(), node.getOrderBy(), node.getOrderings(), node.getFrame(), node.getWindowFunctions(), node.getSignatures(), Optional.empty(), node.getPrePartitionedInputs(), node.getPreSortedOrderPrefix());
            }
            Symbol hashSymbol = this.symbolAllocator.newHashSymbol();
            ProjectNode hashProjectNode = HashGenerationOptimizer.getHashProjectNode(this.idAllocator, rewrittenSource, hashSymbol, node.getPartitionBy());
            return new WindowNode(this.idAllocator.getNextId(), hashProjectNode, node.getPartitionBy(), node.getOrderBy(), node.getOrderings(), node.getFrame(), node.getWindowFunctions(), node.getSignatures(), Optional.of(hashSymbol), node.getPrePartitionedInputs(), node.getPreSortedOrderPrefix());
        }
    }
}

