/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class AddIntermediateAggregation
extends PlanOptimizer {
    private final Metadata metadata;

    public AddIntermediateAggregation(Metadata metadata) {
        Objects.requireNonNull(metadata, "metadata is null");
        this.metadata = metadata;
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        if (SystemSessionProperties.isIntermediateAggregation(session)) {
            return SimplePlanRewriter.rewriteWith(new Rewriter(idAllocator, this.metadata, symbolAllocator), plan);
        }
        return plan;
    }

    private static class Rewriter
    extends SimplePlanRewriter<Void> {
        private final PlanNodeIdAllocator idAllocator;
        private final Metadata metadata;
        private final SymbolAllocator symbolAllocator;

        private Rewriter(PlanNodeIdAllocator idAllocator, Metadata metadata, SymbolAllocator symbolAllocator) {
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
            this.symbolAllocator = Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        }

        @Override
        public PlanNode visitAggregation(AggregationNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            if (node.getStep() != AggregationNode.Step.PARTIAL || node.getGroupBy().isEmpty()) {
                return context.defaultRewrite(node);
            }
            PlanNode rewrittenSource = context.defaultRewrite(node.getSource());
            Map<Symbol, Symbol> masks = node.getMasks();
            HashMap<Symbol, FunctionCall> finalCalls = new HashMap<Symbol, FunctionCall>();
            HashMap<Symbol, FunctionCall> initialCalls = new HashMap<Symbol, FunctionCall>();
            HashMap<Symbol, Signature> initialFunctions = new HashMap<Symbol, Signature>();
            HashMap<Symbol, Symbol> initialMask = new HashMap<Symbol, Symbol>();
            for (Map.Entry<Symbol, FunctionCall> entry : node.getAggregations().entrySet()) {
                Signature signature = node.getFunctions().get(entry.getKey());
                InternalAggregationFunction function = this.metadata.getFunctionRegistry().getAggregateFunctionImplementation(signature);
                Symbol initialSymbol = this.symbolAllocator.newSymbol(signature.getName(), function.getIntermediateType());
                initialCalls.put(initialSymbol, entry.getValue());
                initialFunctions.put(initialSymbol, signature);
                if (masks.containsKey(entry.getKey())) {
                    initialMask.put(initialSymbol, masks.get(entry.getKey()));
                }
                finalCalls.put(entry.getKey(), new FunctionCall(QualifiedName.of((String)signature.getName(), (String[])new String[0]), (List)ImmutableList.of((Object)new QualifiedNameReference(initialSymbol.toQualifiedName()))));
            }
            AggregationNode partialAggregation = new AggregationNode(this.idAllocator.getNextId(), rewrittenSource, node.getGroupBy(), initialCalls, initialFunctions, initialMask, AggregationNode.Step.PARTIAL, node.getSampleWeight(), node.getConfidence(), node.getHashSymbol());
            return new AggregationNode(this.idAllocator.getNextId(), partialAggregation, node.getGroupBy(), finalCalls, node.getFunctions(), (Map<Symbol, Symbol>)ImmutableMap.of(), AggregationNode.Step.INTERMEDIATE, Optional.empty(), node.getConfidence(), node.getHashSymbol());
        }
    }
}

