/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.spi.ConstantProperty;
import com.facebook.presto.spi.LocalProperty;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.optimizations.LocalProperties;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.concurrent.Immutable;

class ActualProperties {
    private final Global global;
    private final List<LocalProperty<Symbol>> localProperties;
    private final Map<Symbol, Object> constants;

    private ActualProperties(Global global, List<? extends LocalProperty<Symbol>> localProperties, Map<Symbol, Object> constants) {
        Objects.requireNonNull(global, "globalProperties is null");
        Objects.requireNonNull(localProperties, "localProperties is null");
        Objects.requireNonNull(constants, "constants is null");
        this.global = global;
        Set localConstants = LocalProperties.extractLeadingConstants(localProperties);
        localProperties = LocalProperties.stripLeadingConstants(localProperties);
        ImmutableSet updatedLocalConstants = ImmutableSet.builder().addAll(localConstants).addAll(constants.keySet()).build();
        List updatedLocalProperties = LocalProperties.normalizeAndPrune(ImmutableList.builder().addAll(Iterables.transform((Iterable)updatedLocalConstants, ConstantProperty::new)).addAll(localProperties).build());
        this.localProperties = ImmutableList.copyOf(updatedLocalProperties);
        this.constants = ImmutableMap.copyOf(constants);
    }

    public static ActualProperties distributed() {
        return ActualProperties.builder().global(Global.distributed()).build();
    }

    public static ActualProperties undistributed() {
        return ActualProperties.builder().global(Global.undistributed()).build();
    }

    public static ActualProperties partitioned(Set<Symbol> columns) {
        return ActualProperties.builder().global(Global.distributed(Partitioning.partitioned(columns))).build();
    }

    public static ActualProperties hashPartitioned(List<Symbol> columns) {
        return ActualProperties.builder().global(Global.distributed(Partitioning.hashPartitioned(columns))).build();
    }

    public boolean isCoordinatorOnly() {
        return this.global.isCoordinatorOnly();
    }

    public boolean isDistributed() {
        return this.global.isDistributed();
    }

    public boolean isNullReplication() {
        Preconditions.checkState((boolean)this.global.getPartitioningProperties().isPresent());
        return this.global.getPartitioningProperties().get().isReplicateNulls();
    }

    public boolean isPartitionedOn(Collection<Symbol> columns) {
        return this.global.getPartitioningProperties().isPresent() && this.global.getPartitioningProperties().get().isPartitionedOn(columns, this.constants.keySet());
    }

    public boolean isEffectivelySinglePartition() {
        return this.global.getPartitioningProperties().isPresent() && this.global.getPartitioningProperties().get().isEffectivelySinglePartition(this.constants.keySet());
    }

    public boolean isRepartitionEffective(Collection<Symbol> keys) {
        return !this.global.getPartitioningProperties().isPresent() || this.global.getPartitioningProperties().get().isRepartitionEffective(keys, this.constants.keySet());
    }

    public ActualProperties translate(Function<Symbol, Optional<Symbol>> translator) {
        HashMap<Symbol, Object> translatedConstants = new HashMap<Symbol, Object>();
        for (Map.Entry<Symbol, Object> entry : this.constants.entrySet()) {
            Optional<Symbol> translatedKey = translator.apply(entry.getKey());
            if (!translatedKey.isPresent()) continue;
            translatedConstants.put(translatedKey.get(), entry.getValue());
        }
        return ActualProperties.builder().global(this.global.translate(translator)).local(LocalProperties.translate(this.localProperties, translator)).constants(translatedConstants).build();
    }

    public boolean isHashPartitionedOn(List<Symbol> columns) {
        return this.global.getPartitioningProperties().isPresent() && this.global.getPartitioningProperties().get().isHashPartitionedOn(columns);
    }

    public Map<Symbol, Object> getConstants() {
        return this.constants;
    }

    public List<LocalProperty<Symbol>> getLocalProperties() {
        return this.localProperties;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builderFrom(ActualProperties properties) {
        return new Builder(properties.global, properties.localProperties, properties.constants);
    }

    public int hashCode() {
        return Objects.hash(this.global, this.localProperties, this.constants.keySet());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ActualProperties other = (ActualProperties)obj;
        return Objects.equals(this.global, other.global) && Objects.equals(this.localProperties, other.localProperties) && Objects.equals(this.constants.keySet(), other.constants.keySet());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("globalProperties", (Object)this.global).add("localProperties", this.localProperties).add("constants", this.constants).toString();
    }

    @Immutable
    public static final class Partitioning {
        private final Set<Symbol> partitioningColumns;
        private final Optional<List<Symbol>> hashingOrder;
        private final boolean replicateNulls;

        private Partitioning(Set<Symbol> partitioningColumns, Optional<List<Symbol>> hashingOrder, boolean replicateNulls) {
            this.partitioningColumns = ImmutableSet.copyOf((Collection)Objects.requireNonNull(partitioningColumns, "partitioningColumns is null"));
            this.hashingOrder = Objects.requireNonNull(hashingOrder, "hashingOrder is null").map(ImmutableList::copyOf);
            this.replicateNulls = replicateNulls;
            Preconditions.checkArgument((!replicateNulls || partitioningColumns.size() == 1 ? 1 : 0) != 0, (Object)"replicateNulls can only be set for partitioning of exactly 1 column");
        }

        public static Partitioning hashPartitioned(List<Symbol> columns) {
            return new Partitioning((Set<Symbol>)ImmutableSet.copyOf(columns), Optional.of(columns), false);
        }

        public static Partitioning hashPartitionedWithReplicatedNulls(List<Symbol> columns) {
            return new Partitioning((Set<Symbol>)ImmutableSet.copyOf(columns), Optional.of(columns), true);
        }

        public static Partitioning partitioned(Set<Symbol> columns) {
            return new Partitioning(columns, Optional.empty(), false);
        }

        public static Partitioning singlePartition() {
            return Partitioning.partitioned((Set<Symbol>)ImmutableSet.of());
        }

        public boolean isReplicateNulls() {
            return this.replicateNulls;
        }

        public boolean isPartitionedOn(Collection<Symbol> columns, Set<Symbol> knownConstants) {
            return this.partitioningColumns.stream().filter(symbol -> !knownConstants.contains(symbol)).allMatch(columns::contains);
        }

        public boolean isHashPartitionedOn(List<Symbol> columns) {
            return this.hashingOrder.isPresent() && this.hashingOrder.get().equals(columns);
        }

        public boolean isEffectivelySinglePartition(Set<Symbol> knownConstants) {
            return this.isPartitionedOn((Collection<Symbol>)ImmutableSet.of(), knownConstants);
        }

        public boolean isRepartitionEffective(Collection<Symbol> keys, Set<Symbol> knownConstants) {
            Set keysWithoutConstants = (Set)keys.stream().filter(symbol -> !knownConstants.contains(symbol)).collect(ImmutableCollectors.toImmutableSet());
            return !this.partitioningColumns.stream().filter(symbol -> !knownConstants.contains(symbol)).collect(ImmutableCollectors.toImmutableSet()).equals((Object)keysWithoutConstants);
        }

        public Optional<Partitioning> translate(Function<Symbol, Optional<Symbol>> translator) {
            ImmutableSet.Builder newPartitioningColumns = ImmutableSet.builder();
            for (Symbol partitioningColumn : this.partitioningColumns) {
                Optional<Symbol> translated = translator.apply(partitioningColumn);
                if (!translated.isPresent()) {
                    return Optional.empty();
                }
                newPartitioningColumns.add((Object)translated.get());
            }
            Optional<List<Symbol>> newHashingOrder = this.hashingOrder.map(columns -> columns.stream().map(translator::apply).map(Optional::get).collect(ImmutableCollectors.toImmutableList()));
            return Optional.of(new Partitioning((Set<Symbol>)newPartitioningColumns.build(), newHashingOrder, this.replicateNulls));
        }

        public int hashCode() {
            return Objects.hash(this.partitioningColumns, this.hashingOrder);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Partitioning other = (Partitioning)obj;
            return Objects.equals(this.partitioningColumns, other.partitioningColumns) && Objects.equals(this.hashingOrder, other.hashingOrder);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("partitioningColumns", this.partitioningColumns).add("hashingOrder", this.hashingOrder).add("replicateNulls", this.replicateNulls).toString();
        }
    }

    @Immutable
    public static final class Global {
        private final boolean distributed;
        private final boolean coordinatorOnly;
        private final Optional<Partitioning> partitioningProperties;

        private Global(boolean distributed, boolean coordinatorOnly, Optional<Partitioning> partitioningProperties) {
            this.distributed = distributed;
            this.coordinatorOnly = coordinatorOnly;
            this.partitioningProperties = Objects.requireNonNull(partitioningProperties, "partitioningProperties is null");
        }

        public static Global coordinatorOnly() {
            return new Global(false, true, Optional.of(Partitioning.singlePartition()));
        }

        public static Global undistributed() {
            return new Global(false, false, Optional.of(Partitioning.singlePartition()));
        }

        public static Global distributed(Optional<Partitioning> partitioningProperties) {
            return new Global(true, false, partitioningProperties);
        }

        public static Global distributed() {
            return Global.distributed(Optional.empty());
        }

        public static Global distributed(Partitioning partitioning) {
            return Global.distributed(Optional.of(partitioning));
        }

        public boolean isDistributed() {
            return this.distributed;
        }

        public boolean isCoordinatorOnly() {
            return this.coordinatorOnly;
        }

        public Optional<Partitioning> getPartitioningProperties() {
            return this.partitioningProperties;
        }

        public Global translate(Function<Symbol, Optional<Symbol>> translator) {
            return new Global(this.distributed, this.coordinatorOnly, this.partitioningProperties.flatMap(properties -> properties.translate(translator)));
        }

        public int hashCode() {
            return Objects.hash(this.distributed, this.coordinatorOnly, this.partitioningProperties);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Global other = (Global)obj;
            return Objects.equals(this.distributed, other.distributed) && Objects.equals(this.coordinatorOnly, other.coordinatorOnly) && Objects.equals(this.partitioningProperties, other.partitioningProperties);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("distributed", this.distributed).add("coordinatorOnly", this.coordinatorOnly).add("partitioningProperties", this.partitioningProperties).toString();
        }
    }

    public static class Builder {
        private Global global;
        private List<LocalProperty<Symbol>> localProperties;
        private Map<Symbol, Object> constants;

        public Builder(Global global, List<LocalProperty<Symbol>> localProperties, Map<Symbol, Object> constants) {
            this.global = global;
            this.localProperties = localProperties;
            this.constants = constants;
        }

        public Builder() {
            this.global = null;
            this.localProperties = ImmutableList.of();
            this.constants = ImmutableMap.of();
        }

        public Builder global(Global global) {
            this.global = global;
            return this;
        }

        public Builder global(ActualProperties other) {
            this.global = other.global;
            return this;
        }

        public Builder local(List<? extends LocalProperty<Symbol>> localProperties) {
            this.localProperties = ImmutableList.copyOf(localProperties);
            return this;
        }

        public Builder local(ActualProperties other) {
            this.localProperties = ImmutableList.copyOf((Collection)other.localProperties);
            return this;
        }

        public Builder constants(Map<Symbol, Object> constants) {
            this.constants = ImmutableMap.copyOf(constants);
            return this;
        }

        public Builder constants(ActualProperties other) {
            this.constants = ImmutableMap.copyOf((Map)other.constants);
            return this;
        }

        public ActualProperties build() {
            return new ActualProperties(this.global, this.localProperties, this.constants);
        }
    }
}

