/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.FieldOrExpression;
import com.facebook.presto.sql.analyzer.RelationType;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.planner.DependencyExtractor;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.LiteralInterpreter;
import com.facebook.presto.sql.planner.PlanBuilder;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.QueryPlanner;
import com.facebook.presto.sql.planner.RelationPlan;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.TranslationMap;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.tree.AliasedRelation;
import com.facebook.presto.sql.tree.ArithmeticBinaryExpression;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.DefaultTraversalVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.Join;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.Row;
import com.facebook.presto.sql.tree.SampledRelation;
import com.facebook.presto.sql.tree.SubqueryExpression;
import com.facebook.presto.sql.tree.Table;
import com.facebook.presto.sql.tree.TableSubquery;
import com.facebook.presto.sql.tree.Union;
import com.facebook.presto.sql.tree.Unnest;
import com.facebook.presto.sql.tree.Values;
import com.facebook.presto.type.ArrayType;
import com.facebook.presto.type.MapType;
import com.facebook.presto.util.ImmutableCollectors;
import com.facebook.presto.util.Types;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

class RelationPlanner
extends DefaultTraversalVisitor<RelationPlan, Void> {
    private final Analysis analysis;
    private final SymbolAllocator symbolAllocator;
    private final PlanNodeIdAllocator idAllocator;
    private final Metadata metadata;
    private final Session session;

    RelationPlanner(Analysis analysis, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, Metadata metadata, Session session) {
        Objects.requireNonNull(analysis, "analysis is null");
        Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        Objects.requireNonNull(metadata, "metadata is null");
        Objects.requireNonNull(session, "session is null");
        this.analysis = analysis;
        this.symbolAllocator = symbolAllocator;
        this.idAllocator = idAllocator;
        this.metadata = metadata;
        this.session = session;
    }

    protected RelationPlan visitTable(Table node, Void context) {
        Query namedQuery = this.analysis.getNamedQuery(node);
        if (namedQuery != null) {
            RelationPlan subPlan = (RelationPlan)this.process((Node)namedQuery, null);
            return new RelationPlan(subPlan.getRoot(), this.analysis.getOutputDescriptor((Node)node), subPlan.getOutputSymbols(), subPlan.getSampleWeight());
        }
        RelationType descriptor = this.analysis.getOutputDescriptor((Node)node);
        TableHandle handle = this.analysis.getTableHandle(node);
        ImmutableList.Builder outputSymbolsBuilder = ImmutableList.builder();
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (Field field : descriptor.getAllFields()) {
            Symbol symbol = this.symbolAllocator.newSymbol(field.getName().get(), field.getType());
            outputSymbolsBuilder.add((Object)symbol);
            columns.put((Object)symbol, (Object)this.analysis.getColumn(field));
        }
        ImmutableList planOutputSymbols = outputSymbolsBuilder.build();
        Optional<ColumnHandle> sampleWeightColumn = this.metadata.getSampleWeightColumnHandle(this.session, handle);
        Symbol sampleWeightSymbol = null;
        if (sampleWeightColumn.isPresent()) {
            sampleWeightSymbol = this.symbolAllocator.newSymbol("$sampleWeight", (Type)BigintType.BIGINT);
            outputSymbolsBuilder.add((Object)sampleWeightSymbol);
            columns.put((Object)sampleWeightSymbol, (Object)sampleWeightColumn.get());
        }
        ImmutableList nodeOutputSymbols = outputSymbolsBuilder.build();
        TableScanNode root = new TableScanNode(this.idAllocator.getNextId(), handle, (List<Symbol>)nodeOutputSymbols, (Map<Symbol, ColumnHandle>)columns.build(), Optional.empty(), (TupleDomain<ColumnHandle>)TupleDomain.all(), null);
        return new RelationPlan(root, descriptor, (List<Symbol>)planOutputSymbols, Optional.ofNullable(sampleWeightSymbol));
    }

    protected RelationPlan visitAliasedRelation(AliasedRelation node, Void context) {
        RelationPlan subPlan = (RelationPlan)this.process((Node)node.getRelation(), context);
        RelationType outputDescriptor = this.analysis.getOutputDescriptor((Node)node);
        return new RelationPlan(subPlan.getRoot(), outputDescriptor, subPlan.getOutputSymbols(), subPlan.getSampleWeight());
    }

    protected RelationPlan visitSampledRelation(SampledRelation node, Void context) {
        if (node.getColumnsToStratifyOn().isPresent()) {
            throw new UnsupportedOperationException("STRATIFY ON is not yet implemented");
        }
        RelationPlan subPlan = (RelationPlan)this.process((Node)node.getRelation(), context);
        RelationType outputDescriptor = this.analysis.getOutputDescriptor((Node)node);
        double ratio = this.analysis.getSampleRatio(node);
        Symbol sampleWeightSymbol = null;
        if (node.getType() == SampledRelation.Type.POISSONIZED) {
            sampleWeightSymbol = this.symbolAllocator.newSymbol("$sampleWeight", (Type)BigintType.BIGINT);
        }
        SampleNode planNode = new SampleNode(this.idAllocator.getNextId(), subPlan.getRoot(), ratio, SampleNode.Type.fromType(node.getType()), node.isRescaled(), Optional.ofNullable(sampleWeightSymbol));
        return new RelationPlan(planNode, outputDescriptor, subPlan.getOutputSymbols(), Optional.ofNullable(sampleWeightSymbol));
    }

    protected RelationPlan visitJoin(Join node, Void context) {
        RelationPlan leftPlan = (RelationPlan)this.process((Node)node.getLeft(), context);
        if (node.getRight() instanceof Unnest || node.getRight() instanceof AliasedRelation && ((AliasedRelation)node.getRight()).getRelation() instanceof Unnest) {
            Unnest unnest = node.getRight() instanceof AliasedRelation ? (Unnest)((AliasedRelation)node.getRight()).getRelation() : (Unnest)node.getRight();
            if (node.getType() != Join.Type.CROSS && node.getType() != Join.Type.IMPLICIT) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)unnest, "UNNEST only supported on the right side of CROSS JOIN", new Object[0]);
            }
            return this.planCrossJoinUnnest(leftPlan, node, unnest);
        }
        RelationPlan rightPlan = (RelationPlan)this.process((Node)node.getRight(), context);
        PlanBuilder leftPlanBuilder = this.initializePlanBuilder(leftPlan);
        PlanBuilder rightPlanBuilder = this.initializePlanBuilder(rightPlan);
        RelationType outputDescriptor = this.analysis.getOutputDescriptor((Node)node);
        ImmutableList outputSymbols = ImmutableList.builder().addAll(leftPlan.getOutputSymbols()).addAll(rightPlan.getOutputSymbols()).build();
        ImmutableList.Builder equiClauses = ImmutableList.builder();
        BooleanLiteral postInnerJoinCriteria = new BooleanLiteral("TRUE");
        if (node.getType() != Join.Type.CROSS && node.getType() != Join.Type.IMPLICIT) {
            Expression criteria = this.analysis.getJoinCriteria(node);
            RelationType left = this.analysis.getOutputDescriptor((Node)node.getLeft());
            RelationType right = this.analysis.getOutputDescriptor((Node)node.getRight());
            ArrayList<Expression> leftExpressions = new ArrayList<Expression>();
            ArrayList<Expression> rightExpressions = new ArrayList<Expression>();
            ArrayList<ComparisonExpression.Type> comparisonTypes = new ArrayList<ComparisonExpression.Type>();
            for (Expression conjunct : ExpressionUtils.extractConjuncts(criteria)) {
                Expression rightExpression;
                Expression leftExpression;
                if (!((conjunct = ExpressionUtils.normalize(conjunct)) instanceof ComparisonExpression)) {
                    throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Unsupported non-equi join form: %s", conjunct);
                }
                ComparisonExpression comparison = (ComparisonExpression)conjunct;
                ComparisonExpression.Type comparisonType = comparison.getType();
                if (comparison.getType() != ComparisonExpression.Type.EQUAL && node.getType() != Join.Type.INNER) {
                    throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Non-equi joins only supported for inner join: %s", conjunct);
                }
                Set<QualifiedName> firstDependencies = DependencyExtractor.extractNames(comparison.getLeft(), this.analysis.getColumnReferences());
                Set<QualifiedName> secondDependencies = DependencyExtractor.extractNames(comparison.getRight(), this.analysis.getColumnReferences());
                if (firstDependencies.stream().allMatch(left.canResolvePredicate()) && secondDependencies.stream().allMatch(right.canResolvePredicate())) {
                    leftExpression = comparison.getLeft();
                    rightExpression = comparison.getRight();
                } else if (firstDependencies.stream().allMatch(right.canResolvePredicate()) && secondDependencies.stream().allMatch(left.canResolvePredicate())) {
                    leftExpression = comparison.getRight();
                    rightExpression = comparison.getLeft();
                    comparisonType = ExpressionUtils.flipComparison(comparisonType);
                } else {
                    throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Unsupported non-equi join form: %s", conjunct);
                }
                leftExpressions.add(leftExpression);
                rightExpressions.add(rightExpression);
                comparisonTypes.add(comparisonType);
            }
            Analysis.JoinInPredicates joinInPredicates = this.analysis.getJoinInPredicates(node);
            if (joinInPredicates != null) {
                leftPlanBuilder = this.appendSemiJoins(leftPlanBuilder, joinInPredicates.getLeftInPredicates());
                rightPlanBuilder = this.appendSemiJoins(rightPlanBuilder, joinInPredicates.getRightInPredicates());
            }
            leftPlanBuilder = this.appendProjections(leftPlanBuilder, leftExpressions);
            rightPlanBuilder = this.appendProjections(rightPlanBuilder, rightExpressions);
            ArrayList<Expression> postInnerJoinComparisons = new ArrayList<Expression>();
            for (int i = 0; i < comparisonTypes.size(); ++i) {
                Symbol leftSymbol = leftPlanBuilder.translate((Expression)leftExpressions.get(i));
                Symbol rightSymbol = rightPlanBuilder.translate((Expression)rightExpressions.get(i));
                if (comparisonTypes.get(i) == ComparisonExpression.Type.EQUAL) {
                    equiClauses.add((Object)new JoinNode.EquiJoinClause(leftSymbol, rightSymbol));
                }
                Expression leftExpression = leftPlanBuilder.rewrite((Expression)leftExpressions.get(i));
                Expression rightExpression = rightPlanBuilder.rewrite((Expression)rightExpressions.get(i));
                postInnerJoinComparisons.add((Expression)new ComparisonExpression((ComparisonExpression.Type)comparisonTypes.get(i), leftExpression, rightExpression));
            }
            postInnerJoinCriteria = ExpressionUtils.and(postInnerJoinComparisons);
        }
        PlanNode root = new JoinNode(this.idAllocator.getNextId(), JoinNode.Type.typeConvert(node.getType()), leftPlanBuilder.getRoot(), rightPlanBuilder.getRoot(), (List<JoinNode.EquiJoinClause>)equiClauses.build(), Optional.empty(), Optional.empty());
        if (node.getType() == Join.Type.INNER) {
            root = new FilterNode(this.idAllocator.getNextId(), root, (Expression)postInnerJoinCriteria);
        }
        Optional<Symbol> sampleWeight = Optional.empty();
        if (leftPlanBuilder.getSampleWeight().isPresent() || rightPlanBuilder.getSampleWeight().isPresent()) {
            ArithmeticBinaryExpression expression = new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Type.MULTIPLY, RelationPlanner.oneIfNull(leftPlanBuilder.getSampleWeight()), RelationPlanner.oneIfNull(rightPlanBuilder.getSampleWeight()));
            sampleWeight = Optional.of(this.symbolAllocator.newSymbol((Expression)expression, (Type)BigintType.BIGINT));
            ImmutableMap.Builder projections = ImmutableMap.builder();
            projections.put((Object)sampleWeight.get(), (Object)expression);
            for (Symbol symbol : root.getOutputSymbols()) {
                projections.put((Object)symbol, (Object)new QualifiedNameReference(symbol.toQualifiedName()));
            }
            root = new ProjectNode(this.idAllocator.getNextId(), root, (Map<Symbol, Expression>)projections.build());
        }
        return new RelationPlan(root, outputDescriptor, (List<Symbol>)outputSymbols, sampleWeight);
    }

    private RelationPlan planCrossJoinUnnest(RelationPlan leftPlan, Join joinNode, Unnest node) {
        RelationType outputDescriptor = this.analysis.getOutputDescriptor((Node)joinNode);
        RelationType unnestOutputDescriptor = this.analysis.getOutputDescriptor((Node)node);
        ImmutableList.Builder unnestedSymbolsBuilder = ImmutableList.builder();
        for (Field field : unnestOutputDescriptor.getVisibleFields()) {
            Symbol symbol = this.symbolAllocator.newSymbol(field);
            unnestedSymbolsBuilder.add((Object)symbol);
        }
        ImmutableList unnestedSymbols = unnestedSymbolsBuilder.build();
        PlanBuilder planBuilder = this.initializePlanBuilder(leftPlan);
        planBuilder = this.appendProjections(planBuilder, node.getExpressions());
        TranslationMap translations = planBuilder.getTranslations();
        ProjectNode projectNode = Types.checkType(planBuilder.getRoot(), ProjectNode.class, "planBuilder.getRoot()");
        ImmutableMap.Builder unnestSymbols = ImmutableMap.builder();
        UnmodifiableIterator unnestedSymbolsIterator = unnestedSymbols.iterator();
        for (Expression expression : node.getExpressions()) {
            Type type = this.analysis.getType(expression);
            Symbol inputSymbol = translations.get(expression);
            if (type instanceof ArrayType) {
                unnestSymbols.put((Object)inputSymbol, (Object)ImmutableList.of((Object)unnestedSymbolsIterator.next()));
                continue;
            }
            if (type instanceof MapType) {
                unnestSymbols.put((Object)inputSymbol, (Object)ImmutableList.of((Object)unnestedSymbolsIterator.next(), (Object)unnestedSymbolsIterator.next()));
                continue;
            }
            throw new IllegalArgumentException("Unsupported type for UNNEST: " + type);
        }
        Optional<Symbol> ordinalitySymbol = node.isWithOrdinality() ? Optional.of(unnestedSymbolsIterator.next()) : Optional.empty();
        Preconditions.checkState((!unnestedSymbolsIterator.hasNext() ? 1 : 0) != 0, (Object)"Not all output symbols were matched with input symbols");
        UnnestNode unnestNode = new UnnestNode(this.idAllocator.getNextId(), projectNode, leftPlan.getOutputSymbols(), (Map<Symbol, List<Symbol>>)unnestSymbols.build(), ordinalitySymbol);
        return new RelationPlan(unnestNode, outputDescriptor, unnestNode.getOutputSymbols(), Optional.empty());
    }

    private static Expression oneIfNull(Optional<Symbol> symbol) {
        if (symbol.isPresent()) {
            return new CoalesceExpression(new Expression[]{new QualifiedNameReference(symbol.get().toQualifiedName()), new LongLiteral("1")});
        }
        return new LongLiteral("1");
    }

    protected RelationPlan visitTableSubquery(TableSubquery node, Void context) {
        return (RelationPlan)this.process((Node)node.getQuery(), context);
    }

    protected RelationPlan visitQuery(Query node, Void context) {
        PlanBuilder subPlan = (PlanBuilder)new QueryPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.metadata, this.session).process((Node)node, null);
        ImmutableList.Builder outputSymbols = ImmutableList.builder();
        for (FieldOrExpression fieldOrExpression : this.analysis.getOutputExpressions((Node)node)) {
            outputSymbols.add((Object)subPlan.translate(fieldOrExpression));
        }
        return new RelationPlan(subPlan.getRoot(), this.analysis.getOutputDescriptor((Node)node), (List<Symbol>)outputSymbols.build(), subPlan.getSampleWeight());
    }

    protected RelationPlan visitQuerySpecification(QuerySpecification node, Void context) {
        PlanBuilder subPlan = (PlanBuilder)new QueryPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.metadata, this.session).process((Node)node, null);
        ImmutableList.Builder outputSymbols = ImmutableList.builder();
        for (FieldOrExpression fieldOrExpression : this.analysis.getOutputExpressions((Node)node)) {
            outputSymbols.add((Object)subPlan.translate(fieldOrExpression));
        }
        return new RelationPlan(subPlan.getRoot(), this.analysis.getOutputDescriptor((Node)node), (List<Symbol>)outputSymbols.build(), subPlan.getSampleWeight());
    }

    protected RelationPlan visitValues(Values node, Void context) {
        RelationType descriptor = this.analysis.getOutputDescriptor((Node)node);
        ImmutableList.Builder outputSymbolsBuilder = ImmutableList.builder();
        for (Field field : descriptor.getVisibleFields()) {
            Symbol symbol = this.symbolAllocator.newSymbol(field);
            outputSymbolsBuilder.add((Object)symbol);
        }
        ImmutableList.Builder rows = ImmutableList.builder();
        for (Expression row : node.getRows()) {
            ImmutableList.Builder values = ImmutableList.builder();
            if (row instanceof Row) {
                List items = ((Row)row).getItems();
                for (int i = 0; i < items.size(); ++i) {
                    Expression expression = (Expression)items.get(i);
                    Object constantValue = ExpressionInterpreter.evaluateConstantExpression(expression, this.analysis.getCoercions(), this.metadata, this.session, this.analysis.getColumnReferences());
                    values.add((Object)LiteralInterpreter.toExpression(constantValue, descriptor.getFieldByIndex(i).getType()));
                }
            } else {
                Object constantValue = ExpressionInterpreter.evaluateConstantExpression(row, this.analysis.getCoercions(), this.metadata, this.session, this.analysis.getColumnReferences());
                values.add((Object)LiteralInterpreter.toExpression(constantValue, descriptor.getFieldByIndex(0).getType()));
            }
            rows.add((Object)values.build());
        }
        ValuesNode valuesNode = new ValuesNode(this.idAllocator.getNextId(), (List<Symbol>)outputSymbolsBuilder.build(), (List<List<Expression>>)rows.build());
        return new RelationPlan(valuesNode, descriptor, (List<Symbol>)outputSymbolsBuilder.build(), Optional.empty());
    }

    protected RelationPlan visitUnnest(Unnest node, Void context) {
        RelationType descriptor = this.analysis.getOutputDescriptor((Node)node);
        ImmutableList.Builder outputSymbolsBuilder = ImmutableList.builder();
        for (Field field : descriptor.getVisibleFields()) {
            Symbol symbol = this.symbolAllocator.newSymbol(field);
            outputSymbolsBuilder.add((Object)symbol);
        }
        ImmutableList unnestedSymbols = outputSymbolsBuilder.build();
        ImmutableList.Builder argumentSymbols = ImmutableList.builder();
        ImmutableList.Builder values = ImmutableList.builder();
        ImmutableMap.Builder unnestSymbols = ImmutableMap.builder();
        Iterator unnestedSymbolsIterator = unnestedSymbols.iterator();
        for (Expression expression : node.getExpressions()) {
            Object constantValue = ExpressionInterpreter.evaluateConstantExpression(expression, this.analysis.getCoercions(), this.metadata, this.session, this.analysis.getColumnReferences());
            Type type = this.analysis.getType(expression);
            values.add((Object)LiteralInterpreter.toExpression(constantValue, type));
            Symbol inputSymbol = this.symbolAllocator.newSymbol(expression, type);
            argumentSymbols.add((Object)inputSymbol);
            if (type instanceof ArrayType) {
                unnestSymbols.put((Object)inputSymbol, (Object)ImmutableList.of(unnestedSymbolsIterator.next()));
                continue;
            }
            if (type instanceof MapType) {
                unnestSymbols.put((Object)inputSymbol, (Object)ImmutableList.of(unnestedSymbolsIterator.next(), unnestedSymbolsIterator.next()));
                continue;
            }
            throw new IllegalArgumentException("Unsupported type for UNNEST: " + type);
        }
        Optional<Symbol> ordinalitySymbol = node.isWithOrdinality() ? Optional.of(unnestedSymbolsIterator.next()) : Optional.empty();
        Preconditions.checkState((!unnestedSymbolsIterator.hasNext() ? 1 : 0) != 0, (Object)"Not all output symbols were matched with input symbols");
        ValuesNode valuesNode = new ValuesNode(this.idAllocator.getNextId(), (List<Symbol>)argumentSymbols.build(), (List<List<Expression>>)ImmutableList.of((Object)values.build()));
        UnnestNode unnestNode = new UnnestNode(this.idAllocator.getNextId(), valuesNode, (List<Symbol>)ImmutableList.of(), (Map<Symbol, List<Symbol>>)unnestSymbols.build(), ordinalitySymbol);
        return new RelationPlan(unnestNode, descriptor, (List<Symbol>)unnestedSymbols, Optional.empty());
    }

    private RelationPlan processAndCoerceIfNecessary(Relation node, Void context) {
        Type[] coerceToTypes = this.analysis.getRelationCoercion(node);
        RelationPlan plan = (RelationPlan)node.accept((AstVisitor)this, (Object)context);
        if (coerceToTypes == null) {
            return plan;
        }
        List<Symbol> oldSymbols = plan.getOutputSymbols();
        RelationType oldDescriptor = plan.getDescriptor().withOnlyVisibleFields();
        Verify.verify((coerceToTypes.length == oldSymbols.size() ? 1 : 0) != 0);
        ImmutableList.Builder newSymbols = new ImmutableList.Builder();
        Field[] newFields = new Field[coerceToTypes.length];
        ImmutableMap.Builder assignments = new ImmutableMap.Builder();
        for (int i = 0; i < coerceToTypes.length; ++i) {
            Symbol outputSymbol;
            Symbol inputSymbol = oldSymbols.get(i);
            Type outputType = coerceToTypes[i];
            Type inputType = this.symbolAllocator.getTypes().get(inputSymbol);
            if (outputType != inputType) {
                Cast cast = new Cast((Expression)new QualifiedNameReference(inputSymbol.toQualifiedName()), outputType.getTypeSignature().toString());
                outputSymbol = this.symbolAllocator.newSymbol((Expression)cast, outputType);
                assignments.put((Object)outputSymbol, (Object)cast);
                newSymbols.add((Object)outputSymbol);
            } else {
                QualifiedNameReference qualifiedNameReference = new QualifiedNameReference(inputSymbol.toQualifiedName());
                outputSymbol = this.symbolAllocator.newSymbol((Expression)qualifiedNameReference, outputType);
                assignments.put((Object)outputSymbol, (Object)qualifiedNameReference);
                newSymbols.add((Object)outputSymbol);
            }
            Field oldField = oldDescriptor.getFieldByIndex(i);
            newFields[i] = new Field(oldField.getRelationAlias(), oldField.getName(), coerceToTypes[i], oldField.isHidden());
        }
        ProjectNode projectNode = new ProjectNode(this.idAllocator.getNextId(), plan.getRoot(), (Map<Symbol, Expression>)assignments.build());
        return new RelationPlan(projectNode, new RelationType(newFields), (List<Symbol>)newSymbols.build(), plan.getSampleWeight());
    }

    protected RelationPlan visitUnion(Union node, Void context) {
        Preconditions.checkArgument((!node.getRelations().isEmpty() ? 1 : 0) != 0, (Object)"No relations specified for UNION");
        List unionOutputSymbols = null;
        ImmutableList.Builder sources = ImmutableList.builder();
        ImmutableListMultimap.Builder symbolMapping = ImmutableListMultimap.builder();
        List subPlans = (List)node.getRelations().stream().map(relation -> this.processAndCoerceIfNecessary((Relation)relation, context)).collect(ImmutableCollectors.toImmutableList());
        boolean hasSampleWeight = false;
        for (Object subPlan : subPlans) {
            if (!((RelationPlan)subPlan).getSampleWeight().isPresent()) continue;
            hasSampleWeight = true;
            break;
        }
        Optional<Symbol> outputSampleWeight = Optional.empty();
        for (RelationPlan relationPlan : subPlans) {
            int fieldIndex;
            RelationType descriptor;
            if (hasSampleWeight && !relationPlan.getSampleWeight().isPresent()) {
                relationPlan = this.addConstantSampleWeight(relationPlan);
            }
            List<Symbol> childOutputSymbols = relationPlan.getOutputSymbols();
            if (unionOutputSymbols == null) {
                descriptor = relationPlan.getDescriptor();
                ImmutableList.Builder outputSymbolBuilder = ImmutableList.builder();
                for (Field field : descriptor.getVisibleFields()) {
                    fieldIndex = descriptor.indexOf(field);
                    Symbol symbol = childOutputSymbols.get(fieldIndex);
                    outputSymbolBuilder.add((Object)this.symbolAllocator.newSymbol(symbol.getName(), this.symbolAllocator.getTypes().get(symbol)));
                }
                unionOutputSymbols = outputSymbolBuilder.build();
                outputSampleWeight = relationPlan.getSampleWeight();
            }
            Preconditions.checkArgument(((descriptor = relationPlan.getDescriptor()).getVisibleFieldCount() == unionOutputSymbols.size() ? 1 : 0) != 0, (String)"Expected relation to have %s symbols but has %s symbols", (Object[])new Object[]{descriptor.getVisibleFieldCount(), unionOutputSymbols.size()});
            int unionFieldId = 0;
            for (Field field : descriptor.getVisibleFields()) {
                fieldIndex = descriptor.indexOf(field);
                symbolMapping.put(unionOutputSymbols.get(unionFieldId), (Object)childOutputSymbols.get(fieldIndex));
                ++unionFieldId;
            }
            sources.add((Object)relationPlan.getRoot());
        }
        PlanNode planNode = new UnionNode(this.idAllocator.getNextId(), (List<PlanNode>)sources.build(), (ListMultimap<Symbol, Symbol>)symbolMapping.build());
        if (node.isDistinct()) {
            planNode = this.distinct(planNode);
        }
        return new RelationPlan(planNode, this.analysis.getOutputDescriptor((Node)node), planNode.getOutputSymbols(), outputSampleWeight);
    }

    private RelationPlan addConstantSampleWeight(RelationPlan subPlan) {
        ImmutableMap.Builder projections = ImmutableMap.builder();
        for (Symbol symbol : subPlan.getOutputSymbols()) {
            QualifiedNameReference expression = new QualifiedNameReference(symbol.toQualifiedName());
            projections.put((Object)symbol, (Object)expression);
        }
        LongLiteral one = new LongLiteral("1");
        Symbol sampleWeightSymbol = this.symbolAllocator.newSymbol("$sampleWeight", (Type)BigintType.BIGINT);
        projections.put((Object)sampleWeightSymbol, (Object)one);
        ProjectNode projectNode = new ProjectNode(this.idAllocator.getNextId(), subPlan.getRoot(), (Map<Symbol, Expression>)projections.build());
        return new RelationPlan(projectNode, subPlan.getDescriptor(), projectNode.getOutputSymbols(), Optional.of(sampleWeightSymbol));
    }

    private PlanBuilder initializePlanBuilder(RelationPlan relationPlan) {
        TranslationMap translations = new TranslationMap(relationPlan, this.analysis);
        translations.setFieldMappings(relationPlan.getOutputSymbols());
        return new PlanBuilder(translations, relationPlan.getRoot(), relationPlan.getSampleWeight());
    }

    private PlanBuilder appendProjections(PlanBuilder subPlan, Iterable<Expression> expressions) {
        TranslationMap translations = new TranslationMap(subPlan.getRelationPlan(), this.analysis);
        translations.copyMappingsFrom(subPlan.getTranslations());
        ImmutableMap.Builder projections = ImmutableMap.builder();
        for (Symbol symbol : subPlan.getRoot().getOutputSymbols()) {
            QualifiedNameReference qualifiedNameReference = new QualifiedNameReference(symbol.toQualifiedName());
            projections.put((Object)symbol, (Object)qualifiedNameReference);
        }
        ImmutableMap.Builder newTranslations = ImmutableMap.builder();
        for (Expression expression : expressions) {
            Symbol symbol = this.symbolAllocator.newSymbol(expression, this.analysis.getType(expression));
            projections.put((Object)symbol, (Object)translations.rewrite(expression));
            newTranslations.put((Object)symbol, (Object)expression);
        }
        for (Map.Entry entry : newTranslations.build().entrySet()) {
            translations.put((Expression)entry.getValue(), (Symbol)entry.getKey());
        }
        return new PlanBuilder(translations, new ProjectNode(this.idAllocator.getNextId(), subPlan.getRoot(), (Map<Symbol, Expression>)projections.build()), subPlan.getSampleWeight());
    }

    private PlanBuilder appendSemiJoins(PlanBuilder subPlan, Set<InPredicate> inPredicates) {
        for (InPredicate inPredicate : inPredicates) {
            subPlan = this.appendSemiJoin(subPlan, inPredicate);
        }
        return subPlan;
    }

    private PlanBuilder appendSemiJoin(PlanBuilder subPlan, InPredicate inPredicate) {
        TranslationMap translations = new TranslationMap(subPlan.getRelationPlan(), this.analysis);
        translations.copyMappingsFrom(subPlan.getTranslations());
        subPlan = this.appendProjections(subPlan, (Iterable<Expression>)ImmutableList.of((Object)inPredicate.getValue()));
        Symbol sourceJoinSymbol = subPlan.translate(inPredicate.getValue());
        Preconditions.checkState((boolean)(inPredicate.getValueList() instanceof SubqueryExpression));
        SubqueryExpression subqueryExpression = (SubqueryExpression)inPredicate.getValueList();
        RelationPlanner relationPlanner = new RelationPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.metadata, this.session);
        RelationPlan valueListRelation = (RelationPlan)relationPlanner.process((Node)subqueryExpression.getQuery(), null);
        Symbol filteringSourceJoinSymbol = (Symbol)Iterables.getOnlyElement(valueListRelation.getRoot().getOutputSymbols());
        Symbol semiJoinOutputSymbol = this.symbolAllocator.newSymbol("semijoinresult", (Type)BooleanType.BOOLEAN);
        translations.put((Expression)inPredicate, semiJoinOutputSymbol);
        return new PlanBuilder(translations, new SemiJoinNode(this.idAllocator.getNextId(), subPlan.getRoot(), valueListRelation.getRoot(), sourceJoinSymbol, filteringSourceJoinSymbol, semiJoinOutputSymbol, Optional.empty(), Optional.empty()), subPlan.getSampleWeight());
    }

    private PlanNode distinct(PlanNode node) {
        return new AggregationNode(this.idAllocator.getNextId(), node, node.getOutputSymbols(), (Map<Symbol, FunctionCall>)ImmutableMap.of(), (Map<Symbol, Signature>)ImmutableMap.of(), (Map<Symbol, Symbol>)ImmutableMap.of(), AggregationNode.Step.SINGLE, Optional.empty(), 1.0, Optional.empty());
    }
}

