/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.operator.HashGenerator;
import com.facebook.presto.operator.InterpretedHashGenerator;
import com.facebook.presto.operator.PartitionFunction;
import com.facebook.presto.operator.PrecomputedHashGenerator;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.PartitionFunctionBinding;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.List;

public enum PartitionFunctionHandle {
    SINGLE{

        @Override
        public PartitionFunction createPartitionFunction(PartitionFunctionBinding function, List<Type> partitionChannelTypes) {
            Preconditions.checkArgument((boolean)function.getPartitionCount().isPresent(), (Object)"Partition count must be set before a partition function can be created");
            Preconditions.checkArgument((function.getPartitionCount().getAsInt() == 1 ? 1 : 0) != 0, (Object)"Single partition can only have one partition");
            return new SinglePartitionFunction();
        }
    }
    ,
    HASH{

        @Override
        public PartitionFunction createPartitionFunction(PartitionFunctionBinding function, List<Type> partitionChannelTypes) {
            Preconditions.checkArgument((boolean)function.getPartitionCount().isPresent(), (Object)"Partition count must be set before a partition function can be created");
            int partitionCount = function.getPartitionCount().getAsInt();
            if (function.getHashColumn().isPresent()) {
                return new HashPartitionFunction(new PrecomputedHashGenerator(0), partitionCount);
            }
            int[] hashChannels = new int[partitionChannelTypes.size()];
            for (int i = 0; i < partitionChannelTypes.size(); ++i) {
                hashChannels[i] = i;
            }
            return new HashPartitionFunction(new InterpretedHashGenerator(partitionChannelTypes, hashChannels), partitionCount);
        }
    }
    ,
    ROUND_ROBIN{

        @Override
        public PartitionFunction createPartitionFunction(PartitionFunctionBinding function, List<Type> partitionChannelTypes) {
            Preconditions.checkArgument((boolean)function.getPartitionCount().isPresent(), (Object)"Partition count must be set before a partition function can be created");
            return new RoundRobinPartitionFunction(function.getPartitionCount().getAsInt());
        }
    };


    public abstract PartitionFunction createPartitionFunction(PartitionFunctionBinding var1, List<Type> var2);

    private static class HashPartitionFunction
    implements PartitionFunction {
        private final HashGenerator generator;
        private final int partitionCount;

        public HashPartitionFunction(HashGenerator generator, int partitionCount) {
            Preconditions.checkArgument((partitionCount > 0 ? 1 : 0) != 0, (Object)"partitionCount must be at least 1");
            this.generator = generator;
            this.partitionCount = partitionCount;
        }

        @Override
        public int getPartitionCount() {
            return this.partitionCount;
        }

        @Override
        public int getPartition(Page page, int position) {
            return this.generator.getPartition(this.partitionCount, position, page);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("generator", (Object)this.generator).add("partitionCount", this.partitionCount).toString();
        }
    }

    private static class RoundRobinPartitionFunction
    implements PartitionFunction {
        private final int partitionCount;
        private int counter;

        public RoundRobinPartitionFunction(int partitionCount) {
            Preconditions.checkArgument((partitionCount > 0 ? 1 : 0) != 0, (Object)"partitionCount must be at least 1");
            this.partitionCount = partitionCount;
        }

        @Override
        public int getPartitionCount() {
            return this.partitionCount;
        }

        @Override
        public int getPartition(Page page, int position) {
            int partition = this.counter % this.partitionCount;
            this.counter = this.counter + 1 & Integer.MAX_VALUE;
            return partition;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("partitionCount", this.partitionCount).toString();
        }
    }

    private static class SinglePartitionFunction
    implements PartitionFunction {
        private SinglePartitionFunction() {
        }

        @Override
        public int getPartitionCount() {
            return 1;
        }

        @Override
        public int getPartition(Page page, int position) {
            return 0;
        }
    }
}

