/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.sql.planner.PartitionFunctionHandle;
import com.facebook.presto.sql.planner.Symbol;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public class PartitionFunctionBinding {
    private final PartitionFunctionHandle functionHandle;
    private final List<Symbol> partitioningColumns;
    private final Optional<Symbol> hashColumn;
    private final boolean replicateNulls;
    private final OptionalInt partitionCount;

    public PartitionFunctionBinding(PartitionFunctionHandle functionHandle, List<Symbol> partitioningColumns) {
        this(functionHandle, partitioningColumns, Optional.empty(), false, OptionalInt.empty());
    }

    public PartitionFunctionBinding(PartitionFunctionHandle functionHandle, List<Symbol> partitioningColumns, Optional<Symbol> hashColumn) {
        this(functionHandle, partitioningColumns, hashColumn, false, OptionalInt.empty());
    }

    @JsonCreator
    public PartitionFunctionBinding(@JsonProperty(value="functionHandle") PartitionFunctionHandle functionHandle, @JsonProperty(value="partitioningColumns") List<Symbol> partitioningColumns, @JsonProperty(value="hashColumn") Optional<Symbol> hashColumn, @JsonProperty(value="replicateNulls") boolean replicateNulls, @JsonProperty(value="partitionCount") OptionalInt partitionCount) {
        this.functionHandle = Objects.requireNonNull(functionHandle, "functionHandle is null");
        this.partitioningColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitioningColumns, "partitioningColumns is null"));
        this.hashColumn = Objects.requireNonNull(hashColumn, "hashColumn is null");
        Preconditions.checkArgument((!replicateNulls || partitioningColumns.size() == 1 ? 1 : 0) != 0, (Object)"size of partitioningColumns is not 1 when nullPartition is REPLICATE.");
        this.replicateNulls = replicateNulls;
        this.partitionCount = Objects.requireNonNull(partitionCount, "partitionCount is null");
    }

    @JsonProperty
    public PartitionFunctionHandle getFunctionHandle() {
        return this.functionHandle;
    }

    @JsonProperty
    public List<Symbol> getPartitioningColumns() {
        return this.partitioningColumns;
    }

    @JsonProperty
    public Optional<Symbol> getHashColumn() {
        return this.hashColumn;
    }

    @JsonProperty
    public boolean isReplicateNulls() {
        return this.replicateNulls;
    }

    @JsonProperty
    public OptionalInt getPartitionCount() {
        return this.partitionCount;
    }

    public PartitionFunctionBinding withPartitionCount(OptionalInt partitionCount) {
        return new PartitionFunctionBinding(this.functionHandle, this.partitioningColumns, this.hashColumn, this.replicateNulls, partitionCount);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionFunctionBinding that = (PartitionFunctionBinding)o;
        return Objects.equals((Object)this.functionHandle, (Object)that.functionHandle) && Objects.equals(this.partitioningColumns, that.partitioningColumns) && Objects.equals(this.hashColumn, that.hashColumn) && this.replicateNulls == that.replicateNulls && Objects.equals(this.partitionCount, that.partitionCount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.functionHandle, this.partitioningColumns, this.replicateNulls, this.partitionCount});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("functionHandle", (Object)this.functionHandle).add("partitioningChannels", this.partitioningColumns).add("hashChannel", this.hashColumn).add("replicateNulls", this.replicateNulls).add("partitionCount", (Object)this.partitionCount).toString();
    }
}

