/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.byteCode.ByteCodeBlock;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.Scope;
import com.facebook.presto.byteCode.Variable;
import com.facebook.presto.byteCode.control.IfStatement;
import com.facebook.presto.byteCode.expression.ByteCodeExpressions;
import com.facebook.presto.byteCode.instruction.InstructionNode;
import com.facebook.presto.byteCode.instruction.LabelNode;
import com.facebook.presto.byteCode.instruction.VariableInstruction;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.ByteCodeGenerator;
import com.facebook.presto.sql.gen.ByteCodeGeneratorContext;
import com.facebook.presto.sql.gen.ByteCodeUtils;
import com.facebook.presto.sql.relational.CallExpression;
import com.facebook.presto.sql.relational.RowExpression;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;

public class SwitchCodeGenerator
implements ByteCodeGenerator {
    @Override
    public ByteCodeNode generateExpression(Signature signature, ByteCodeGeneratorContext generatorContext, Type returnType, List<RowExpression> arguments) {
        ByteCodeNode elseValue;
        List<RowExpression> whenClauses;
        Scope scope = generatorContext.getScope();
        RowExpression value = arguments.get(0);
        ByteCodeNode valueBytecode = generatorContext.generate(value);
        RowExpression last = arguments.get(arguments.size() - 1);
        if (last instanceof CallExpression && ((CallExpression)last).getSignature().getName().equals("WHEN")) {
            whenClauses = arguments.subList(1, arguments.size());
            elseValue = new ByteCodeBlock().append(generatorContext.wasNull().set(ByteCodeExpressions.constantTrue())).pushJavaDefault(returnType.getJavaType());
        } else {
            whenClauses = arguments.subList(1, arguments.size() - 1);
            elseValue = generatorContext.generate(last);
        }
        Class valueType = value.getType().getJavaType();
        LabelNode nullValue = new LabelNode("nullCondition");
        Variable tempVariable = scope.createTempVariable(valueType);
        ByteCodeBlock block = new ByteCodeBlock().append(valueBytecode).append(ByteCodeUtils.ifWasNullClearPopAndGoto(scope, nullValue, Void.TYPE, valueType)).putVariable(tempVariable);
        InstructionNode getTempVariableNode = VariableInstruction.loadVariable(tempVariable);
        elseValue = new ByteCodeBlock().visitLabel(nullValue).append(elseValue);
        for (RowExpression clause : Lists.reverse(whenClauses)) {
            Preconditions.checkArgument((clause instanceof CallExpression && ((CallExpression)clause).getSignature().getName().equals("WHEN") ? 1 : 0) != 0);
            RowExpression operand = ((CallExpression)clause).getArguments().get(0);
            RowExpression result = ((CallExpression)clause).getArguments().get(1);
            Signature equalsFunction = generatorContext.getRegistry().resolveOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)value.getType(), (Object)operand.getType()));
            ByteCodeNode equalsCall = generatorContext.generateCall(equalsFunction.getName(), generatorContext.getRegistry().getScalarFunctionImplementation(equalsFunction), (List<ByteCodeNode>)ImmutableList.of((Object)generatorContext.generate(operand), (Object)getTempVariableNode));
            ByteCodeBlock condition = new ByteCodeBlock().append(equalsCall).append(generatorContext.wasNull().set(ByteCodeExpressions.constantFalse()));
            elseValue = new IfStatement("when", new Object[0]).condition(condition).ifTrue(generatorContext.generate(result)).ifFalse(elseValue);
        }
        return block.append(elseValue);
    }
}

