/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.byteCode.Access;
import com.facebook.presto.byteCode.ByteCodeBlock;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.ClassDefinition;
import com.facebook.presto.byteCode.FieldDefinition;
import com.facebook.presto.byteCode.MethodDefinition;
import com.facebook.presto.byteCode.Parameter;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.Scope;
import com.facebook.presto.byteCode.Variable;
import com.facebook.presto.byteCode.control.ForLoop;
import com.facebook.presto.byteCode.control.IfStatement;
import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.facebook.presto.byteCode.expression.ByteCodeExpressions;
import com.facebook.presto.byteCode.instruction.JumpInstruction;
import com.facebook.presto.byteCode.instruction.LabelNode;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.operator.PageProcessor;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.DictionaryBlock;
import com.facebook.presto.spi.block.LazyBlock;
import com.facebook.presto.spi.block.RunLengthEncodedBlock;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.BodyCompiler;
import com.facebook.presto.sql.gen.ByteCodeExpressionVisitor;
import com.facebook.presto.sql.gen.ByteCodeUtils;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.relational.CallExpression;
import com.facebook.presto.sql.relational.ConstantExpression;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.InputReferenceExpression;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.sql.relational.RowExpressionVisitor;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Primitives;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class PageProcessorCompiler
implements BodyCompiler<PageProcessor> {
    private final Metadata metadata;

    public PageProcessorCompiler(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public void generateMethods(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, RowExpression filter, List<RowExpression> projections) {
        ImmutableList.Builder projectMethods = ImmutableList.builder();
        ImmutableList.Builder projectColumnarMethods = ImmutableList.builder();
        ImmutableList.Builder projectDictionaryMethods = ImmutableList.builder();
        for (int i = 0; i < projections.size(); ++i) {
            MethodDefinition project = this.generateProjectMethod(classDefinition, callSiteBinder, "project_" + i, projections.get(i));
            MethodDefinition projectColumnar = PageProcessorCompiler.generateProjectColumnarMethod(classDefinition, callSiteBinder, "projectColumnar_" + i, projections.get(i), project);
            MethodDefinition projectDictionary = PageProcessorCompiler.generateProjectDictionaryMethod(classDefinition, "projectDictionary_" + i, projections.get(i), project, projectColumnar);
            projectMethods.add((Object)project);
            projectColumnarMethods.add((Object)projectColumnar);
            projectDictionaryMethods.add((Object)projectDictionary);
        }
        ImmutableList projectMethodDefinitions = projectMethods.build();
        ImmutableList projectColumnarMethodDefinitions = projectColumnarMethods.build();
        ImmutableList projectDictionaryMethodDefinitions = projectDictionaryMethods.build();
        PageProcessorCompiler.generateConstructor(classDefinition, projections.size());
        PageProcessorCompiler.generateProcessMethod(classDefinition, filter, projections, (List<MethodDefinition>)projectMethodDefinitions);
        PageProcessorCompiler.generateGetNonLazyPageMethod(classDefinition, filter, projections);
        PageProcessorCompiler.generateProcessColumnarMethod(classDefinition, projections, (List<MethodDefinition>)projectColumnarMethodDefinitions);
        PageProcessorCompiler.generateProcessColumnarDictionaryMethod(classDefinition, projections, (List<MethodDefinition>)projectColumnarMethodDefinitions, (List<MethodDefinition>)projectDictionaryMethodDefinitions);
        PageProcessorCompiler.generateFilterPageMethod(classDefinition, filter);
        this.generateFilterMethod(classDefinition, callSiteBinder, filter);
    }

    private static void generateConstructor(ClassDefinition classDefinition, int projectionCount) {
        MethodDefinition constructorDefinition = classDefinition.declareConstructor(Access.a(Access.PUBLIC), new Parameter[0]);
        FieldDefinition inputDictionaries = classDefinition.declareField(Access.a(Access.PRIVATE, Access.FINAL), "inputDictionaries", Block[].class);
        FieldDefinition outputDictionaries = classDefinition.declareField(Access.a(Access.PRIVATE, Access.FINAL), "outputDictionaries", Block[].class);
        ByteCodeBlock body = constructorDefinition.getBody();
        Variable thisVariable = constructorDefinition.getThis();
        body.comment("super();").append(thisVariable).invokeConstructor(Object.class, new Class[0]);
        body.append(thisVariable.setField(inputDictionaries, ByteCodeExpressions.newArray(ParameterizedType.type(Block[].class), projectionCount)));
        body.append(thisVariable.setField(outputDictionaries, ByteCodeExpressions.newArray(ParameterizedType.type(Block[].class), projectionCount)));
        body.ret();
    }

    private static void generateProcessMethod(ClassDefinition classDefinition, RowExpression filter, List<RowExpression> projections, List<MethodDefinition> projectionMethods) {
        Parameter session = Parameter.arg("session", ConnectorSession.class);
        Parameter page = Parameter.arg("page", Page.class);
        Parameter start = Parameter.arg("start", Integer.TYPE);
        Parameter end = Parameter.arg("end", Integer.TYPE);
        Parameter pageBuilder = Parameter.arg("pageBuilder", PageBuilder.class);
        MethodDefinition method = classDefinition.declareMethod(Access.a(Access.PUBLIC), "process", ParameterizedType.type(Integer.TYPE), session, page, start, end, pageBuilder);
        Scope scope = method.getScope();
        ByteCodeBlock body = method.getBody();
        Variable thisVariable = method.getThis();
        List<Integer> allInputChannels = PageProcessorCompiler.getInputChannels(Iterables.concat(projections, (Iterable)ImmutableList.of((Object)filter)));
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int channel : allInputChannels) {
            Variable blockVariable = scope.declareVariable("block_" + channel, body, page.invoke("getBlock", Block.class, ByteCodeExpressions.constantInt(channel)));
            builder.put((Object)channel, (Object)blockVariable);
        }
        ImmutableMap channelBlocks = builder.build();
        Map<RowExpression, List<Variable>> expressionInputBlocks = PageProcessorCompiler.getExpressionInputBlocks(projections, filter, (Map<Integer, Variable>)channelBlocks);
        ImmutableList.Builder variableBuilder = ImmutableList.builder();
        for (int projectionIndex = 0; projectionIndex < projections.size(); ++projectionIndex) {
            Variable blockBuilder = scope.declareVariable("blockBuilder_" + projectionIndex, body, pageBuilder.invoke("getBlockBuilder", BlockBuilder.class, ByteCodeExpressions.constantInt(projectionIndex)));
            variableBuilder.add((Object)blockBuilder);
        }
        ImmutableList blockBuilders = variableBuilder.build();
        Variable position = scope.declareVariable(Integer.TYPE, "position");
        ByteCodeBlock project = new ByteCodeBlock().append(pageBuilder.invoke("declarePosition", Void.TYPE, new ByteCodeExpression[0]));
        for (int projectionIndex = 0; projectionIndex < projections.size(); ++projectionIndex) {
            RowExpression projection = projections.get(projectionIndex);
            project.append(PageProcessorCompiler.invokeProject(thisVariable, session, expressionInputBlocks.get(projection), position, (Variable)blockBuilders.get(projectionIndex), projectionMethods.get(projectionIndex)));
        }
        LabelNode done = new LabelNode("done");
        ForLoop loop = new ForLoop().initialize(position.set(start)).condition(ByteCodeExpressions.lessThan(position, end)).update(position.set(ByteCodeExpressions.add(position, ByteCodeExpressions.constantInt(1)))).body(new ByteCodeBlock().append(new IfStatement().condition(pageBuilder.invoke("isFull", Boolean.TYPE, new ByteCodeExpression[0])).ifTrue(JumpInstruction.jump(done))).append(new IfStatement().condition(PageProcessorCompiler.invokeFilter(thisVariable, session, expressionInputBlocks.get(filter), position)).ifTrue(project)));
        body.append(loop).visitLabel(done).append(position.ret());
    }

    private static void generateProcessColumnarMethod(ClassDefinition classDefinition, List<RowExpression> projections, List<MethodDefinition> projectColumnarMethods) {
        Parameter session = Parameter.arg("session", ConnectorSession.class);
        Parameter page = Parameter.arg("page", Page.class);
        Parameter types = Parameter.arg("types", List.class);
        MethodDefinition method = classDefinition.declareMethod(Access.a(Access.PUBLIC), "processColumnar", ParameterizedType.type(Page.class), session, page, types);
        Scope scope = method.getScope();
        ByteCodeBlock body = method.getBody();
        Variable thisVariable = method.getThis();
        Variable selectedPositions = scope.declareVariable("selectedPositions", body, thisVariable.invoke("filterPage", int[].class, session, page));
        Variable cardinality = scope.declareVariable("cardinality", body, selectedPositions.length());
        body.comment("if no rows selected return null").append(new IfStatement().condition(ByteCodeExpressions.equal(cardinality, ByteCodeExpressions.constantInt(0))).ifTrue(ByteCodeExpressions.constantNull(Page.class).ret()));
        if (projections.isEmpty()) {
            body.append(ByteCodeExpressions.newInstance(Page.class, cardinality, ByteCodeExpressions.newArray(ParameterizedType.type(Block[].class), 0)).ret());
            return;
        }
        Variable pageBuilder = scope.declareVariable("pageBuilder", body, ByteCodeExpressions.newInstance(PageBuilder.class, cardinality, types));
        Variable outputBlocks = scope.declareVariable("outputBlocks", body, ByteCodeExpressions.newArray(ParameterizedType.type(Block[].class), projections.size()));
        for (int projectionIndex = 0; projectionIndex < projections.size(); ++projectionIndex) {
            ImmutableList params = ImmutableList.builder().add((Object)session).add((Object)page).add((Object)selectedPositions).add((Object)pageBuilder).add((Object)ByteCodeExpressions.constantInt(projectionIndex)).build();
            body.append(outputBlocks.setElement(projectionIndex, thisVariable.invoke(projectColumnarMethods.get(projectionIndex), (Iterable<? extends ByteCodeExpression>)params)));
        }
        body.append(ByteCodeExpressions.newInstance(Page.class, cardinality, outputBlocks).ret());
    }

    private static MethodDefinition generateProjectColumnarMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, String methodName, RowExpression projection, MethodDefinition projectionMethod) {
        Parameter session = Parameter.arg("session", ConnectorSession.class);
        Parameter page = Parameter.arg("page", Page.class);
        Parameter selectedPositions = Parameter.arg("selectedPositions", int[].class);
        Parameter pageBuilder = Parameter.arg("pageBuilder", PageBuilder.class);
        Parameter projectionIndex = Parameter.arg("projectionIndex", Integer.TYPE);
        ImmutableList params = ImmutableList.builder().add((Object)session).add((Object)page).add((Object)selectedPositions).add((Object)pageBuilder).add((Object)projectionIndex).build();
        MethodDefinition method = classDefinition.declareMethod(Access.a(Access.PRIVATE), methodName, ParameterizedType.type(Block.class), (Iterable<Parameter>)params);
        ByteCodeBlock body = method.getBody();
        Scope scope = method.getScope();
        Variable thisVariable = method.getThis();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int channel : PageProcessorCompiler.getInputChannels(projection)) {
            Variable blockVariable = scope.declareVariable("block_" + channel, body, page.invoke("getBlock", Block.class, ByteCodeExpressions.constantInt(channel)));
            builder.add((Object)blockVariable);
        }
        ImmutableList inputs = builder.build();
        Variable positionCount = scope.declareVariable("positionCount", body, page.invoke("getPositionCount", Integer.TYPE, new ByteCodeExpression[0]));
        Variable position = scope.declareVariable("position", body, ByteCodeExpressions.constantInt(0));
        Variable cardinality = scope.declareVariable("cardinality", body, selectedPositions.length());
        Variable outputBlock = scope.declareVariable(Block.class, "outputBlock");
        Variable blockBuilder = scope.declareVariable("blockBuilder", body, pageBuilder.invoke("getBlockBuilder", BlockBuilder.class, projectionIndex));
        Variable type = scope.declareVariable("type", body, pageBuilder.invoke("getType", Type.class, projectionIndex));
        ByteCodeBlock projectBlock = new ByteCodeBlock().append(new ForLoop().initialize(position.set(ByteCodeExpressions.constantInt(0))).condition(ByteCodeExpressions.lessThan(position, cardinality)).update(position.increment()).body(PageProcessorCompiler.invokeProject(thisVariable, session, (List<? extends Variable>)inputs, selectedPositions.getElement(position), blockBuilder, projectionMethod))).append(outputBlock.set(blockBuilder.invoke("build", Block.class, new ByteCodeExpression[0])));
        if (PageProcessorCompiler.isIdentityExpression(projection)) {
            body.append(new IfStatement().condition(ByteCodeExpressions.equal(cardinality, positionCount)).ifTrue(outputBlock.set((ByteCodeExpression)inputs.get(0))).ifFalse(projectBlock));
        } else if (PageProcessorCompiler.isConstantExpression(projection)) {
            ConstantExpression constantExpression = (ConstantExpression)projection;
            Verify.verify((boolean)PageProcessorCompiler.getInputChannels(projection).isEmpty());
            ByteCodeExpression value = ByteCodeUtils.loadConstant(callSiteBinder, constantExpression.getValue(), Object.class);
            body.append(outputBlock.set(ByteCodeExpressions.invokeStatic(RunLengthEncodedBlock.class, "create", Block.class, type, value, cardinality)));
        } else {
            body.append(projectBlock);
        }
        body.append(outputBlock.ret());
        return method;
    }

    private static MethodDefinition generateProjectDictionaryMethod(ClassDefinition classDefinition, String methodName, RowExpression projection, MethodDefinition project, MethodDefinition projectColumnar) {
        Parameter session = Parameter.arg("session", ConnectorSession.class);
        Parameter page = Parameter.arg("page", Page.class);
        Parameter selectedPositions = Parameter.arg("selectedPositions", int[].class);
        Parameter pageBuilder = Parameter.arg("pageBuilder", PageBuilder.class);
        Parameter projectionIndex = Parameter.arg("projectionIndex", Integer.TYPE);
        ImmutableList params = ImmutableList.builder().add((Object)session).add((Object)page).add((Object)selectedPositions).add((Object)pageBuilder).add((Object)projectionIndex).build();
        MethodDefinition method = classDefinition.declareMethod(Access.a(Access.PRIVATE), methodName, ParameterizedType.type(Block.class), (Iterable<Parameter>)params);
        ByteCodeBlock body = method.getBody();
        Scope scope = method.getScope();
        Variable thisVariable = method.getThis();
        List<Integer> inputChannels = PageProcessorCompiler.getInputChannels(projection);
        if (inputChannels.size() != 1) {
            body.append(thisVariable.invoke(projectColumnar, (Iterable<? extends ByteCodeExpression>)params).ret());
            return method;
        }
        Variable inputBlock = scope.declareVariable("inputBlock", body, page.invoke("getBlock", Block.class, ByteCodeExpressions.constantInt((Integer)Iterables.getOnlyElement(inputChannels))));
        IfStatement ifStatement = new IfStatement().condition(inputBlock.instanceOf(DictionaryBlock.class)).ifFalse(thisVariable.invoke(projectColumnar, (Iterable<? extends ByteCodeExpression>)params).ret());
        body.append(ifStatement);
        Variable blockBuilder = scope.declareVariable("blockBuilder", body, pageBuilder.invoke("getBlockBuilder", BlockBuilder.class, projectionIndex));
        Variable cardinality = scope.declareVariable("cardinality", body, selectedPositions.length());
        Variable dictionary = scope.declareVariable(Block.class, "dictionary");
        Variable ids = scope.declareVariable(Slice.class, "ids");
        Variable dictionaryCount = scope.declareVariable(Integer.TYPE, "dictionaryCount");
        Variable outputDictionary = scope.declareVariable(Block.class, "outputDictionary");
        Variable outputIds = scope.declareVariable(int[].class, "outputIds");
        ByteCodeExpression inputDictionaries = thisVariable.getField("inputDictionaries", Block[].class);
        ByteCodeExpression outputDictionaries = thisVariable.getField("outputDictionaries", Block[].class);
        Variable position = scope.declareVariable("position", body, ByteCodeExpressions.constantInt(0));
        body.comment("Extract dictionary and ids").append(dictionary.set(inputBlock.cast(DictionaryBlock.class).invoke("getDictionary", Block.class, new ByteCodeExpression[0]))).append(ids.set(inputBlock.cast(DictionaryBlock.class).invoke("getIds", Slice.class, new ByteCodeExpression[0]))).append(dictionaryCount.set(dictionary.invoke("getPositionCount", Integer.TYPE, new ByteCodeExpression[0])));
        ByteCodeBlock projectDictionary = new ByteCodeBlock().comment("Project dictionary").append(new ForLoop().initialize(position.set(ByteCodeExpressions.constantInt(0))).condition(ByteCodeExpressions.lessThan(position, dictionaryCount)).update(position.increment()).body(PageProcessorCompiler.invokeProject(thisVariable, session, (List<? extends Variable>)ImmutableList.of((Object)dictionary), position, blockBuilder, project))).append(outputDictionary.set(blockBuilder.invoke("build", Block.class, new ByteCodeExpression[0]))).append(inputDictionaries.setElement(projectionIndex, (ByteCodeExpression)dictionary)).append(outputDictionaries.setElement(projectionIndex, (ByteCodeExpression)outputDictionary));
        body.comment("Use processed dictionary, if available, else project it").append(new IfStatement().condition(ByteCodeExpressions.equal(inputDictionaries.getElement(projectionIndex), dictionary)).ifTrue(outputDictionary.set(outputDictionaries.getElement(projectionIndex))).ifFalse(projectDictionary));
        body.comment("Filter ids").append(outputIds.set(ByteCodeExpressions.newArray(ParameterizedType.type(int[].class), cardinality))).append(new ForLoop().initialize(position.set(ByteCodeExpressions.constantInt(0))).condition(ByteCodeExpressions.lessThan(position, cardinality)).update(position.increment()).body(outputIds.setElement(position, ids.invoke("getInt", Integer.TYPE, ByteCodeExpressions.multiply(selectedPositions.getElement(position), ByteCodeExpressions.constantInt(4))))));
        body.append(ByteCodeExpressions.newInstance(DictionaryBlock.class, cardinality, outputDictionary, ByteCodeExpressions.invokeStatic(Slices.class, "wrappedIntArray", Slice.class, outputIds)).cast(Block.class).ret());
        return method;
    }

    private static void generateProcessColumnarDictionaryMethod(ClassDefinition classDefinition, List<RowExpression> projections, List<MethodDefinition> projectColumnarMethods, List<MethodDefinition> projectDictionaryMethods) {
        Parameter session = Parameter.arg("session", ConnectorSession.class);
        Parameter page = Parameter.arg("page", Page.class);
        Parameter types = Parameter.arg("types", List.class);
        MethodDefinition method = classDefinition.declareMethod(Access.a(Access.PUBLIC), "processColumnarDictionary", ParameterizedType.type(Page.class), session, page, types);
        Scope scope = method.getScope();
        ByteCodeBlock body = method.getBody();
        Variable thisVariable = method.getThis();
        Variable selectedPositions = scope.declareVariable("selectedPositions", body, thisVariable.invoke("filterPage", int[].class, session, page));
        Variable cardinality = scope.declareVariable("cardinality", body, selectedPositions.length());
        body.comment("if no rows selected return null").append(new IfStatement().condition(ByteCodeExpressions.equal(cardinality, ByteCodeExpressions.constantInt(0))).ifTrue(ByteCodeExpressions.constantNull(Page.class).ret()));
        if (projectColumnarMethods.isEmpty()) {
            body.append(ByteCodeExpressions.newInstance(Page.class, cardinality, ByteCodeExpressions.newArray(ParameterizedType.type(Block[].class), 0)).ret());
            return;
        }
        Variable pageBuilder = scope.declareVariable("pageBuilder", body, ByteCodeExpressions.newInstance(PageBuilder.class, cardinality, types));
        body.append(page.set(thisVariable.invoke("getNonLazyPage", Page.class, page)));
        Variable outputBlocks = scope.declareVariable("outputBlocks", body, ByteCodeExpressions.newArray(ParameterizedType.type(Block[].class), projections.size()));
        for (int projectionIndex = 0; projectionIndex < projections.size(); ++projectionIndex) {
            ImmutableList params = ImmutableList.builder().add((Object)session).add((Object)page).add((Object)selectedPositions).add((Object)pageBuilder).add((Object)ByteCodeExpressions.constantInt(projectionIndex)).build();
            body.append(outputBlocks.setElement(projectionIndex, thisVariable.invoke(projectDictionaryMethods.get(projectionIndex), (Iterable<? extends ByteCodeExpression>)params)));
        }
        body.append(ByteCodeExpressions.newInstance(Page.class, cardinality, outputBlocks).ret());
    }

    private static void generateGetNonLazyPageMethod(ClassDefinition classDefinition, RowExpression filter, List<RowExpression> projections) {
        Parameter page = Parameter.arg("page", Page.class);
        MethodDefinition method = classDefinition.declareMethod(Access.a(Access.PRIVATE), "getNonLazyPage", ParameterizedType.type(Page.class), page);
        Scope scope = method.getScope();
        ByteCodeBlock body = method.getBody();
        List<Integer> allInputChannels = PageProcessorCompiler.getInputChannels(Iterables.concat(projections, (Iterable)ImmutableList.of((Object)filter)));
        if (allInputChannels.isEmpty()) {
            body.append(page.ret());
            return;
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int channel : allInputChannels) {
            Variable blockVariable = scope.declareVariable("block_" + channel, body, page.invoke("getBlock", Block.class, ByteCodeExpressions.constantInt(channel)));
            builder.put((Object)channel, (Object)blockVariable);
        }
        ImmutableMap channelBlocks = builder.build();
        Variable blocks = scope.declareVariable("blocks", body, page.invoke("getBlocks", Block[].class, new ByteCodeExpression[0]));
        Variable positionCount = scope.declareVariable("positionCount", body, page.invoke("getPositionCount", Integer.TYPE, new ByteCodeExpression[0]));
        Variable createNewPage = scope.declareVariable("createNewPage", body, ByteCodeExpressions.constantFalse());
        for (Map.Entry entry : channelBlocks.entrySet()) {
            int channel = (Integer)entry.getKey();
            Variable inputBlock = (Variable)entry.getValue();
            IfStatement ifStmt = new IfStatement();
            ifStmt.condition(inputBlock.instanceOf(LazyBlock.class)).ifTrue().append(blocks.setElement(channel, inputBlock.cast(LazyBlock.class).invoke("getBlock", Block.class, new ByteCodeExpression[0]))).append(createNewPage.set(ByteCodeExpressions.constantTrue()));
            body.append(ifStmt);
        }
        body.append(new IfStatement().condition(createNewPage).ifTrue(page.set(ByteCodeExpressions.newInstance(Page.class, positionCount, blocks))));
        body.append(page.ret());
    }

    private static void generateFilterPageMethod(ClassDefinition classDefinition, RowExpression filter) {
        Parameter session = Parameter.arg("session", ConnectorSession.class);
        Parameter page = Parameter.arg("page", Page.class);
        MethodDefinition method = classDefinition.declareMethod(Access.a(Access.PUBLIC), "filterPage", ParameterizedType.type(int[].class), session, page);
        method.comment("Filter: %s rows in the page", filter.toString());
        Scope scope = method.getScope();
        Variable thisVariable = method.getThis();
        ByteCodeBlock body = method.getBody();
        Variable positionCount = scope.declareVariable("positionCount", body, page.invoke("getPositionCount", Integer.TYPE, new ByteCodeExpression[0]));
        Variable selectedPositions = scope.declareVariable("selectedPositions", body, ByteCodeExpressions.newArray(ParameterizedType.type(int[].class), positionCount));
        List<Integer> filterChannels = PageProcessorCompiler.getInputChannels(filter);
        ImmutableList.Builder blockVariablesBuilder = ImmutableList.builder();
        for (int channel : filterChannels) {
            Variable blockVariable = scope.declareVariable("block_" + channel, body, page.invoke("getBlock", Block.class, ByteCodeExpressions.constantInt(channel)));
            blockVariablesBuilder.add((Object)blockVariable);
        }
        ImmutableList blockVariables = blockVariablesBuilder.build();
        Variable selectedCount = scope.declareVariable("selectedCount", body, ByteCodeExpressions.constantInt(0));
        Variable position = scope.declareVariable(Integer.TYPE, "position");
        IfStatement ifStatement = new IfStatement();
        ifStatement.condition(PageProcessorCompiler.invokeFilter(thisVariable, session, (List<? extends ByteCodeExpression>)blockVariables, position)).ifTrue().append(selectedPositions.setElement(selectedCount, (ByteCodeExpression)position)).append(selectedCount.increment());
        body.append(new ForLoop().initialize(position.set(ByteCodeExpressions.constantInt(0))).condition(ByteCodeExpressions.lessThan(position, positionCount)).update(position.increment()).body(ifStatement));
        body.append(ByteCodeExpressions.invokeStatic(Arrays.class, "copyOf", int[].class, selectedPositions, selectedCount).ret());
    }

    private void generateFilterMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, RowExpression filter) {
        Parameter session = Parameter.arg("session", ConnectorSession.class);
        Parameter position = Parameter.arg("position", Integer.TYPE);
        List<Parameter> blocks = PageProcessorCompiler.toBlockParameters(PageProcessorCompiler.getInputChannels(filter));
        MethodDefinition method = classDefinition.declareMethod(Access.a(Access.PUBLIC), "filter", ParameterizedType.type(Boolean.TYPE), (Iterable<Parameter>)ImmutableList.builder().add((Object)session).addAll(blocks).add((Object)position).build());
        method.comment("Filter: %s", filter.toString());
        ByteCodeBlock body = method.getBody();
        Scope scope = method.getScope();
        Variable wasNullVariable = scope.declareVariable("wasNull", body, ByteCodeExpressions.constantFalse());
        ByteCodeExpressionVisitor visitor = new ByteCodeExpressionVisitor(callSiteBinder, PageProcessorCompiler.fieldReferenceCompiler(callSiteBinder, position, wasNullVariable), this.metadata.getFunctionRegistry());
        ByteCodeNode visitorBody = filter.accept(visitor, scope);
        Variable result = scope.declareVariable(Boolean.TYPE, "result");
        body.append(visitorBody).putVariable(result).append(new IfStatement().condition(wasNullVariable).ifTrue(ByteCodeExpressions.constantFalse().ret()).ifFalse(result.ret()));
    }

    private MethodDefinition generateProjectMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, String methodName, RowExpression projection) {
        Parameter session = Parameter.arg("session", ConnectorSession.class);
        List<Parameter> inputs = PageProcessorCompiler.toBlockParameters(PageProcessorCompiler.getInputChannels(projection));
        Parameter position = Parameter.arg("position", Integer.TYPE);
        Parameter output = Parameter.arg("output", BlockBuilder.class);
        MethodDefinition method = classDefinition.declareMethod(Access.a(Access.PUBLIC), methodName, ParameterizedType.type(Void.TYPE), (Iterable<Parameter>)ImmutableList.builder().add((Object)session).addAll(inputs).add((Object)position).add((Object)output).build());
        method.comment("Projection: %s", projection.toString());
        Scope scope = method.getScope();
        ByteCodeBlock body = method.getBody();
        Variable wasNullVariable = scope.declareVariable("wasNull", body, ByteCodeExpressions.constantFalse());
        ByteCodeExpressionVisitor visitor = new ByteCodeExpressionVisitor(callSiteBinder, PageProcessorCompiler.fieldReferenceCompiler(callSiteBinder, position, wasNullVariable), this.metadata.getFunctionRegistry());
        body.getVariable(output).comment("evaluate projection: " + projection.toString()).append(projection.accept(visitor, scope)).append(ByteCodeUtils.generateWrite(callSiteBinder, scope, wasNullVariable, projection.getType())).ret();
        return method;
    }

    private static boolean isIdentityExpression(RowExpression expression) {
        List<RowExpression> rowExpressions = Expressions.subExpressions((Iterable<RowExpression>)ImmutableList.of((Object)expression));
        return rowExpressions.size() == 1 && Iterables.getOnlyElement(rowExpressions) instanceof InputReferenceExpression;
    }

    private static boolean isConstantExpression(RowExpression expression) {
        List<RowExpression> rowExpressions = Expressions.subExpressions((Iterable<RowExpression>)ImmutableList.of((Object)expression));
        return rowExpressions.size() == 1 && Iterables.getOnlyElement(rowExpressions) instanceof ConstantExpression && ((ConstantExpression)Iterables.getOnlyElement(rowExpressions)).getValue() != null;
    }

    private static List<Integer> getInputChannels(Iterable<RowExpression> expressions) {
        TreeSet<Integer> channels = new TreeSet<Integer>();
        for (RowExpression expression : Expressions.subExpressions(expressions)) {
            if (!(expression instanceof InputReferenceExpression)) continue;
            channels.add(((InputReferenceExpression)expression).getField());
        }
        return ImmutableList.copyOf(channels);
    }

    private static List<Integer> getInputChannels(RowExpression expression) {
        return PageProcessorCompiler.getInputChannels((Iterable<RowExpression>)ImmutableList.of((Object)expression));
    }

    private static List<Parameter> toBlockParameters(List<Integer> inputChannels) {
        ImmutableList.Builder parameters = ImmutableList.builder();
        for (int channel : inputChannels) {
            parameters.add((Object)Parameter.arg("block_" + channel, Block.class));
        }
        return parameters.build();
    }

    private static RowExpressionVisitor<Scope, ByteCodeNode> fieldReferenceCompiler(final CallSiteBinder callSiteBinder, final Variable positionVariable, final Variable wasNullVariable) {
        return new RowExpressionVisitor<Scope, ByteCodeNode>(){

            @Override
            public ByteCodeNode visitInputReference(InputReferenceExpression node, Scope scope) {
                int field = node.getField();
                Type type = node.getType();
                Variable block = scope.getVariable("block_" + field);
                Class<Object> javaType = type.getJavaType();
                if (!javaType.isPrimitive() && javaType != Slice.class) {
                    javaType = Object.class;
                }
                IfStatement ifStatement = new IfStatement();
                ifStatement.condition().setDescription(String.format("block_%d.get%s()", field, type)).append(block).getVariable(positionVariable).invokeInterface(Block.class, "isNull", Boolean.TYPE, Integer.TYPE);
                ifStatement.ifTrue().putVariable(wasNullVariable, true).pushJavaDefault(javaType);
                String methodName = "get" + Primitives.wrap(javaType).getSimpleName();
                ifStatement.ifFalse().append(ByteCodeUtils.loadConstant(callSiteBinder.bind(type, Type.class))).append(block).getVariable(positionVariable).invokeInterface(Type.class, methodName, javaType, Block.class, Integer.TYPE);
                return ifStatement;
            }

            @Override
            public ByteCodeNode visitCall(CallExpression call, Scope scope) {
                throw new UnsupportedOperationException("not yet implemented");
            }

            @Override
            public ByteCodeNode visitConstant(ConstantExpression literal, Scope scope) {
                throw new UnsupportedOperationException("not yet implemented");
            }
        };
    }

    private static Map<RowExpression, List<Variable>> getExpressionInputBlocks(List<RowExpression> projections, RowExpression filter, Map<Integer, Variable> channelBlock) {
        HashMap<RowExpression, List<Variable>> inputBlocksBuilder = new HashMap<RowExpression, List<Variable>>();
        for (RowExpression projection : projections) {
            List inputBlocks = PageProcessorCompiler.getInputChannels(projection).stream().map(channelBlock::get).collect(Collectors.toList());
            List existingVariables = (List)inputBlocksBuilder.get(projection);
            Preconditions.checkState((existingVariables == null || existingVariables.equals(inputBlocks) ? 1 : 0) != 0, (Object)"malformed RowExpression");
            inputBlocksBuilder.put(projection, inputBlocks);
        }
        List filterBlocks = PageProcessorCompiler.getInputChannels(filter).stream().map(channelBlock::get).collect(Collectors.toList());
        inputBlocksBuilder.put(filter, filterBlocks);
        return inputBlocksBuilder;
    }

    private static ByteCodeExpression invokeFilter(ByteCodeExpression objRef, ByteCodeExpression session, List<? extends ByteCodeExpression> blockVariables, ByteCodeExpression position) {
        ImmutableList params = ImmutableList.builder().add((Object)session).addAll(blockVariables).add((Object)position).build();
        return objRef.invoke("filter", Boolean.TYPE, (Iterable<? extends ByteCodeExpression>)params);
    }

    private static ByteCodeNode invokeProject(Variable objRef, Variable session, List<? extends Variable> blockVariables, ByteCodeExpression position, Variable blockBuilder, MethodDefinition projectionMethod) {
        ImmutableList params = ImmutableList.builder().add((Object)session).addAll(blockVariables).add((Object)position).add((Object)blockBuilder).build();
        return new ByteCodeBlock().append(objRef.invoke(projectionMethod, (Iterable<? extends ByteCodeExpression>)params));
    }
}

