/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.byteCode.Access;
import com.facebook.presto.byteCode.ByteCodeBlock;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.ClassDefinition;
import com.facebook.presto.byteCode.DynamicClassLoader;
import com.facebook.presto.byteCode.FieldDefinition;
import com.facebook.presto.byteCode.MethodDefinition;
import com.facebook.presto.byteCode.OpCode;
import com.facebook.presto.byteCode.Parameter;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.Scope;
import com.facebook.presto.byteCode.Variable;
import com.facebook.presto.byteCode.control.ForLoop;
import com.facebook.presto.byteCode.control.IfStatement;
import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.facebook.presto.byteCode.expression.ByteCodeExpressions;
import com.facebook.presto.byteCode.instruction.LabelNode;
import com.facebook.presto.operator.InMemoryJoinHash;
import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.PagesHashStrategy;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.CompilerOperations;
import com.facebook.presto.sql.gen.CompilerUtils;
import com.facebook.presto.sql.gen.IsolatedClass;
import com.facebook.presto.sql.gen.SqlTypeByteCodeExpression;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.UncheckedExecutionException;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;

public class JoinCompiler {
    private final LoadingCache<CacheKey, LookupSourceFactory> lookupSourceFactories = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<CacheKey, LookupSourceFactory>(){

        public LookupSourceFactory load(CacheKey key) throws Exception {
            return JoinCompiler.this.internalCompileLookupSourceFactory(key.getTypes(), key.getJoinChannels());
        }
    });
    private final LoadingCache<CacheKey, Class<? extends PagesHashStrategy>> hashStrategies = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<CacheKey, Class<? extends PagesHashStrategy>>(){

        public Class<? extends PagesHashStrategy> load(CacheKey key) throws Exception {
            return JoinCompiler.this.internalCompileHashStrategy(key.getTypes(), key.getJoinChannels());
        }
    });

    public LookupSourceFactory compileLookupSourceFactory(List<? extends Type> types, List<Integer> joinChannels) {
        try {
            return (LookupSourceFactory)this.lookupSourceFactories.get((Object)new CacheKey(types, joinChannels));
        }
        catch (ExecutionError | UncheckedExecutionException | ExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    public PagesHashStrategyFactory compilePagesHashStrategyFactory(List<Type> types, List<Integer> joinChannels) {
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(joinChannels, "joinChannels is null");
        try {
            return new PagesHashStrategyFactory((Class)this.hashStrategies.get((Object)new CacheKey(types, joinChannels)));
        }
        catch (ExecutionError | UncheckedExecutionException | ExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    private LookupSourceFactory internalCompileLookupSourceFactory(List<Type> types, List<Integer> joinChannels) {
        Class<? extends PagesHashStrategy> pagesHashStrategyClass = this.internalCompileHashStrategy(types, joinChannels);
        Class<InMemoryJoinHash> lookupSourceClass = IsolatedClass.isolateClass(new DynamicClassLoader(this.getClass().getClassLoader()), LookupSource.class, InMemoryJoinHash.class, new Class[0]);
        return new LookupSourceFactory(lookupSourceClass, new PagesHashStrategyFactory(pagesHashStrategyClass));
    }

    private Class<? extends PagesHashStrategy> internalCompileHashStrategy(List<Type> types, List<Integer> joinChannels) {
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        ClassDefinition classDefinition = new ClassDefinition(Access.a(Access.PUBLIC, Access.FINAL), CompilerUtils.makeClassName("PagesHashStrategy"), ParameterizedType.type(Object.class), ParameterizedType.type(PagesHashStrategy.class));
        FieldDefinition sizeField = classDefinition.declareField(Access.a(Access.PRIVATE, Access.FINAL), "size", ParameterizedType.type(Long.TYPE));
        ArrayList<FieldDefinition> channelFields = new ArrayList<FieldDefinition>();
        for (int i = 0; i < types.size(); ++i) {
            FieldDefinition channelField = classDefinition.declareField(Access.a(Access.PRIVATE, Access.FINAL), "channel_" + i, ParameterizedType.type(List.class, Block.class));
            channelFields.add(channelField);
        }
        ArrayList<Type> joinChannelTypes = new ArrayList<Type>();
        ArrayList<FieldDefinition> joinChannelFields = new ArrayList<FieldDefinition>();
        for (int i = 0; i < joinChannels.size(); ++i) {
            joinChannelTypes.add(types.get(joinChannels.get(i)));
            FieldDefinition channelField = classDefinition.declareField(Access.a(Access.PRIVATE, Access.FINAL), "joinChannel_" + i, ParameterizedType.type(List.class, Block.class));
            joinChannelFields.add(channelField);
        }
        FieldDefinition hashChannelField = classDefinition.declareField(Access.a(Access.PRIVATE, Access.FINAL), "hashChannel", ParameterizedType.type(List.class, Block.class));
        JoinCompiler.generateConstructor(classDefinition, joinChannels, sizeField, channelFields, joinChannelFields, hashChannelField);
        JoinCompiler.generateGetChannelCountMethod(classDefinition, channelFields);
        JoinCompiler.generateGetSizeInBytesMethod(classDefinition, sizeField);
        JoinCompiler.generateAppendToMethod(classDefinition, callSiteBinder, types, channelFields);
        JoinCompiler.generateHashPositionMethod(classDefinition, callSiteBinder, joinChannelTypes, joinChannelFields, hashChannelField);
        JoinCompiler.generateHashRowMethod(classDefinition, callSiteBinder, joinChannelTypes);
        JoinCompiler.generateRowEqualsRowMethod(classDefinition, callSiteBinder, joinChannelTypes);
        JoinCompiler.generatePositionEqualsRowMethod(classDefinition, callSiteBinder, joinChannelTypes, joinChannelFields);
        JoinCompiler.generatePositionEqualsRowWithPageMethod(classDefinition, callSiteBinder, joinChannelTypes, joinChannelFields);
        JoinCompiler.generatePositionEqualsPositionMethod(classDefinition, callSiteBinder, joinChannelTypes, joinChannelFields);
        return CompilerUtils.defineClass(classDefinition, PagesHashStrategy.class, callSiteBinder.getBindings(), this.getClass().getClassLoader());
    }

    private static void generateConstructor(ClassDefinition classDefinition, List<Integer> joinChannels, FieldDefinition sizeField, List<FieldDefinition> channelFields, List<FieldDefinition> joinChannelFields, FieldDefinition hashChannelField) {
        int index;
        Parameter channels = Parameter.arg("channels", ParameterizedType.type(List.class, ParameterizedType.type(List.class, Block.class)));
        Parameter hashChannel = Parameter.arg("hashChannel", ParameterizedType.type(Optional.class, Integer.class));
        MethodDefinition constructorDefinition = classDefinition.declareConstructor(Access.a(Access.PUBLIC), channels, hashChannel);
        Variable thisVariable = constructorDefinition.getThis();
        Variable blockIndex = constructorDefinition.getScope().declareVariable(Integer.TYPE, "blockIndex");
        ByteCodeBlock constructor = constructorDefinition.getBody().comment("super();").append(thisVariable).invokeConstructor(Object.class, new Class[0]);
        constructor.comment("this.size = 0").append(thisVariable.setField(sizeField, ByteCodeExpressions.constantLong(0L)));
        constructor.comment("Set channel fields");
        for (index = 0; index < channelFields.size(); ++index) {
            ByteCodeExpression channel = channels.invoke("get", Object.class, ByteCodeExpressions.constantInt(index)).cast(ParameterizedType.type(List.class, Block.class));
            constructor.append(thisVariable.setField(channelFields.get(index), channel));
            ByteCodeBlock loopBody = new ByteCodeBlock();
            constructor.comment("for(blockIndex = 0; blockIndex < channel.size(); blockIndex++) { size += channel.get(i).getRetainedSizeInBytes() }").append(new ForLoop().initialize(blockIndex.set(ByteCodeExpressions.constantInt(0))).condition(new ByteCodeBlock().append(blockIndex).append(channel.invoke("size", Integer.TYPE, new ByteCodeExpression[0])).invokeStatic(CompilerOperations.class, "lessThan", Boolean.TYPE, Integer.TYPE, Integer.TYPE)).update(new ByteCodeBlock().incrementVariable(blockIndex, (byte)1)).body(loopBody));
            loopBody.append(thisVariable).append(thisVariable).getField(sizeField).append(channel.invoke("get", Object.class, blockIndex).cast(ParameterizedType.type(Block.class)).invoke("getRetainedSizeInBytes", Integer.TYPE, new ByteCodeExpression[0]).cast(Long.TYPE)).longAdd().putField(sizeField);
        }
        constructor.comment("Set join channel fields");
        for (index = 0; index < joinChannelFields.size(); ++index) {
            ByteCodeExpression joinChannel = channels.invoke("get", Object.class, ByteCodeExpressions.constantInt(joinChannels.get(index))).cast(ParameterizedType.type(List.class, Block.class));
            constructor.append(thisVariable.setField(joinChannelFields.get(index), joinChannel));
        }
        constructor.comment("Set hashChannel");
        constructor.append(new IfStatement().condition(hashChannel.invoke("isPresent", Boolean.TYPE, new ByteCodeExpression[0])).ifTrue(thisVariable.setField(hashChannelField, channels.invoke("get", Object.class, hashChannel.invoke("get", Object.class, new ByteCodeExpression[0]).cast(Integer.class).cast(Integer.TYPE)))).ifFalse(thisVariable.setField(hashChannelField, ByteCodeExpressions.constantNull(hashChannelField.getType()))));
        constructor.ret();
    }

    private static void generateGetChannelCountMethod(ClassDefinition classDefinition, List<FieldDefinition> channelFields) {
        classDefinition.declareMethod(Access.a(Access.PUBLIC), "getChannelCount", ParameterizedType.type(Integer.TYPE), new Parameter[0]).getBody().push(channelFields.size()).retInt();
    }

    private static void generateGetSizeInBytesMethod(ClassDefinition classDefinition, FieldDefinition sizeField) {
        MethodDefinition getSizeInBytesMethod = classDefinition.declareMethod(Access.a(Access.PUBLIC), "getSizeInBytes", ParameterizedType.type(Long.TYPE), new Parameter[0]);
        Variable thisVariable = getSizeInBytesMethod.getThis();
        getSizeInBytesMethod.getBody().append(thisVariable.getField(sizeField)).retLong();
    }

    private static void generateAppendToMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, List<Type> types, List<FieldDefinition> channelFields) {
        Parameter blockIndex = Parameter.arg("blockIndex", Integer.TYPE);
        Parameter blockPosition = Parameter.arg("blockPosition", Integer.TYPE);
        Parameter pageBuilder = Parameter.arg("pageBuilder", PageBuilder.class);
        Parameter outputChannelOffset = Parameter.arg("outputChannelOffset", Integer.TYPE);
        MethodDefinition appendToMethod = classDefinition.declareMethod(Access.a(Access.PUBLIC), "appendTo", ParameterizedType.type(Void.TYPE), blockIndex, blockPosition, pageBuilder, outputChannelOffset);
        Variable thisVariable = appendToMethod.getThis();
        ByteCodeBlock appendToBody = appendToMethod.getBody();
        for (int index = 0; index < channelFields.size(); ++index) {
            Type type = types.get(index);
            SqlTypeByteCodeExpression typeExpression = SqlTypeByteCodeExpression.constantType(callSiteBinder, type);
            ByteCodeExpression block = thisVariable.getField(channelFields.get(index)).invoke("get", Object.class, blockIndex).cast(Block.class);
            appendToBody.comment("%s.appendTo(channel_%s.get(blockIndex), blockPosition, pageBuilder.getBlockBuilder(outputChannelOffset + %s));", type.getClass(), index, index).append(typeExpression).append(block).append(blockPosition).append(pageBuilder).append(outputChannelOffset).push(index).append(OpCode.IADD).invokeVirtual(PageBuilder.class, "getBlockBuilder", BlockBuilder.class, Integer.TYPE).invokeInterface(Type.class, "appendTo", Void.TYPE, Block.class, Integer.TYPE, BlockBuilder.class);
        }
        appendToBody.ret();
    }

    private static void generateHashPositionMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, List<Type> joinChannelTypes, List<FieldDefinition> joinChannelFields, FieldDefinition hashChannelField) {
        Parameter blockIndex = Parameter.arg("blockIndex", Integer.TYPE);
        Parameter blockPosition = Parameter.arg("blockPosition", Integer.TYPE);
        MethodDefinition hashPositionMethod = classDefinition.declareMethod(Access.a(Access.PUBLIC), "hashPosition", ParameterizedType.type(Integer.TYPE), blockIndex, blockPosition);
        Variable thisVariable = hashPositionMethod.getThis();
        ByteCodeExpression hashChannel = thisVariable.getField(hashChannelField);
        SqlTypeByteCodeExpression bigintType = SqlTypeByteCodeExpression.constantType(callSiteBinder, (Type)BigintType.BIGINT);
        IfStatement ifStatement = new IfStatement();
        ifStatement.condition(ByteCodeExpressions.notEqual(hashChannel, ByteCodeExpressions.constantNull(hashChannelField.getType())));
        ifStatement.ifTrue(bigintType.invoke("getLong", Long.TYPE, hashChannel.invoke("get", Object.class, blockIndex).cast(Block.class), blockPosition).cast(Integer.TYPE).ret());
        hashPositionMethod.getBody().append(ifStatement);
        Variable resultVariable = hashPositionMethod.getScope().declareVariable(Integer.TYPE, "result");
        hashPositionMethod.getBody().push(0).putVariable(resultVariable);
        for (int index = 0; index < joinChannelTypes.size(); ++index) {
            SqlTypeByteCodeExpression type = SqlTypeByteCodeExpression.constantType(callSiteBinder, joinChannelTypes.get(index));
            ByteCodeExpression block = hashPositionMethod.getThis().getField(joinChannelFields.get(index)).invoke("get", Object.class, blockIndex).cast(Block.class);
            hashPositionMethod.getBody().getVariable(resultVariable).push(31).append(OpCode.IMUL).append(JoinCompiler.typeHashCode(type, block, blockPosition)).append(OpCode.IADD).putVariable(resultVariable);
        }
        hashPositionMethod.getBody().getVariable(resultVariable).retInt();
    }

    private static void generateHashRowMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, List<Type> joinChannelTypes) {
        Parameter position = Parameter.arg("position", Integer.TYPE);
        Parameter blocks = Parameter.arg("blocks", Block[].class);
        MethodDefinition hashRowMethod = classDefinition.declareMethod(Access.a(Access.PUBLIC), "hashRow", ParameterizedType.type(Integer.TYPE), position, blocks);
        Variable resultVariable = hashRowMethod.getScope().declareVariable(Integer.TYPE, "result");
        hashRowMethod.getBody().push(0).putVariable(resultVariable);
        for (int index = 0; index < joinChannelTypes.size(); ++index) {
            SqlTypeByteCodeExpression type = SqlTypeByteCodeExpression.constantType(callSiteBinder, joinChannelTypes.get(index));
            ByteCodeExpression block = blocks.getElement(index).cast(Block.class);
            hashRowMethod.getBody().getVariable(resultVariable).push(31).append(OpCode.IMUL).append(JoinCompiler.typeHashCode(type, block, position)).append(OpCode.IADD).putVariable(resultVariable);
        }
        hashRowMethod.getBody().getVariable(resultVariable).retInt();
    }

    private static ByteCodeNode typeHashCode(ByteCodeExpression type, ByteCodeExpression blockRef, ByteCodeExpression blockPosition) {
        return new IfStatement().condition(blockRef.invoke("isNull", Boolean.TYPE, blockPosition)).ifTrue(ByteCodeExpressions.constantInt(0)).ifFalse(type.invoke("hash", Integer.TYPE, blockRef, blockPosition));
    }

    private static void generateRowEqualsRowMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, List<Type> joinChannelTypes) {
        MethodDefinition rowEqualsRowMethod = classDefinition.declareMethod(Access.a(Access.PUBLIC), "rowEqualsRow", ParameterizedType.type(Boolean.TYPE), Parameter.arg("leftPosition", Integer.TYPE), Parameter.arg("leftBlocks", Block[].class), Parameter.arg("rightPosition", Integer.TYPE), Parameter.arg("rightBlocks", Block[].class));
        Scope compilerContext = rowEqualsRowMethod.getScope();
        for (int index = 0; index < joinChannelTypes.size(); ++index) {
            SqlTypeByteCodeExpression type = SqlTypeByteCodeExpression.constantType(callSiteBinder, joinChannelTypes.get(index));
            ByteCodeExpression leftBlock = compilerContext.getVariable("leftBlocks").getElement(index);
            ByteCodeExpression rightBlock = compilerContext.getVariable("rightBlocks").getElement(index);
            LabelNode checkNextField = new LabelNode("checkNextField");
            rowEqualsRowMethod.getBody().append(JoinCompiler.typeEquals(type, leftBlock, compilerContext.getVariable("leftPosition"), rightBlock, compilerContext.getVariable("rightPosition"))).ifTrueGoto(checkNextField).push(false).retBoolean().visitLabel(checkNextField);
        }
        rowEqualsRowMethod.getBody().push(true).retInt();
    }

    private static void generatePositionEqualsRowMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, List<Type> joinChannelTypes, List<FieldDefinition> joinChannelFields) {
        Parameter leftBlockIndex = Parameter.arg("leftBlockIndex", Integer.TYPE);
        Parameter leftBlockPosition = Parameter.arg("leftBlockPosition", Integer.TYPE);
        Parameter rightPosition = Parameter.arg("rightPosition", Integer.TYPE);
        Parameter rightBlocks = Parameter.arg("rightBlocks", Block[].class);
        MethodDefinition positionEqualsRowMethod = classDefinition.declareMethod(Access.a(Access.PUBLIC), "positionEqualsRow", ParameterizedType.type(Boolean.TYPE), leftBlockIndex, leftBlockPosition, rightPosition, rightBlocks);
        Variable thisVariable = positionEqualsRowMethod.getThis();
        for (int index = 0; index < joinChannelTypes.size(); ++index) {
            SqlTypeByteCodeExpression type = SqlTypeByteCodeExpression.constantType(callSiteBinder, joinChannelTypes.get(index));
            ByteCodeExpression leftBlock = thisVariable.getField(joinChannelFields.get(index)).invoke("get", Object.class, leftBlockIndex).cast(Block.class);
            ByteCodeExpression rightBlock = rightBlocks.getElement(index);
            LabelNode checkNextField = new LabelNode("checkNextField");
            positionEqualsRowMethod.getBody().append(JoinCompiler.typeEquals(type, leftBlock, leftBlockPosition, rightBlock, rightPosition)).ifTrueGoto(checkNextField).push(false).retBoolean().visitLabel(checkNextField);
        }
        positionEqualsRowMethod.getBody().push(true).retInt();
    }

    private static void generatePositionEqualsRowWithPageMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, List<Type> joinChannelTypes, List<FieldDefinition> joinChannelFields) {
        Parameter leftBlockIndex = Parameter.arg("leftBlockIndex", Integer.TYPE);
        Parameter leftBlockPosition = Parameter.arg("leftBlockPosition", Integer.TYPE);
        Parameter rightPosition = Parameter.arg("rightPosition", Integer.TYPE);
        Parameter page = Parameter.arg("page", Page.class);
        Parameter rightChannels = Parameter.arg("rightChannels", int[].class);
        MethodDefinition positionEqualsRowMethod = classDefinition.declareMethod(Access.a(Access.PUBLIC), "positionEqualsRow", ParameterizedType.type(Boolean.TYPE), leftBlockIndex, leftBlockPosition, rightPosition, page, rightChannels);
        Variable thisVariable = positionEqualsRowMethod.getThis();
        ByteCodeBlock body = positionEqualsRowMethod.getBody();
        for (int index = 0; index < joinChannelTypes.size(); ++index) {
            SqlTypeByteCodeExpression type = SqlTypeByteCodeExpression.constantType(callSiteBinder, joinChannelTypes.get(index));
            ByteCodeExpression leftBlock = thisVariable.getField(joinChannelFields.get(index)).invoke("get", Object.class, leftBlockIndex).cast(Block.class);
            ByteCodeExpression rightBlock = page.invoke("getBlock", Block.class, rightChannels.getElement(index));
            body.append(new IfStatement().condition(JoinCompiler.typeEquals(type, leftBlock, leftBlockPosition, rightBlock, rightPosition)).ifFalse(ByteCodeExpressions.constantFalse().ret()));
        }
        body.append(ByteCodeExpressions.constantTrue().ret());
    }

    private static void generatePositionEqualsPositionMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, List<Type> joinChannelTypes, List<FieldDefinition> joinChannelFields) {
        Parameter leftBlockIndex = Parameter.arg("leftBlockIndex", Integer.TYPE);
        Parameter leftBlockPosition = Parameter.arg("leftBlockPosition", Integer.TYPE);
        Parameter rightBlockIndex = Parameter.arg("rightBlockIndex", Integer.TYPE);
        Parameter rightBlockPosition = Parameter.arg("rightBlockPosition", Integer.TYPE);
        MethodDefinition positionEqualsPositionMethod = classDefinition.declareMethod(Access.a(Access.PUBLIC), "positionEqualsPosition", ParameterizedType.type(Boolean.TYPE), leftBlockIndex, leftBlockPosition, rightBlockIndex, rightBlockPosition);
        Variable thisVariable = positionEqualsPositionMethod.getThis();
        for (int index = 0; index < joinChannelTypes.size(); ++index) {
            SqlTypeByteCodeExpression type = SqlTypeByteCodeExpression.constantType(callSiteBinder, joinChannelTypes.get(index));
            ByteCodeExpression leftBlock = thisVariable.getField(joinChannelFields.get(index)).invoke("get", Object.class, leftBlockIndex).cast(Block.class);
            ByteCodeExpression rightBlock = thisVariable.getField(joinChannelFields.get(index)).invoke("get", Object.class, rightBlockIndex).cast(Block.class);
            LabelNode checkNextField = new LabelNode("checkNextField");
            positionEqualsPositionMethod.getBody().append(JoinCompiler.typeEquals(type, leftBlock, leftBlockPosition, rightBlock, rightBlockPosition)).ifTrueGoto(checkNextField).push(false).retBoolean().visitLabel(checkNextField);
        }
        positionEqualsPositionMethod.getBody().push(true).retInt();
    }

    private static ByteCodeNode typeEquals(ByteCodeExpression type, ByteCodeExpression leftBlock, ByteCodeExpression leftBlockPosition, ByteCodeExpression rightBlock, ByteCodeExpression rightBlockPosition) {
        IfStatement ifStatement = new IfStatement();
        ifStatement.condition().append(leftBlock.invoke("isNull", Boolean.TYPE, leftBlockPosition)).append(rightBlock.invoke("isNull", Boolean.TYPE, rightBlockPosition)).append(OpCode.IOR);
        ifStatement.ifTrue().append(leftBlock.invoke("isNull", Boolean.TYPE, leftBlockPosition)).append(rightBlock.invoke("isNull", Boolean.TYPE, rightBlockPosition)).append(OpCode.IAND);
        ifStatement.ifFalse().append(type.invoke("equalTo", Boolean.TYPE, leftBlock, leftBlockPosition, rightBlock, rightBlockPosition));
        return ifStatement;
    }

    private static final class CacheKey {
        private final List<Type> types;
        private final List<Integer> joinChannels;

        private CacheKey(List<? extends Type> types, List<Integer> joinChannels) {
            this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
            this.joinChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(joinChannels, "joinChannels is null"));
        }

        private List<Type> getTypes() {
            return this.types;
        }

        private List<Integer> getJoinChannels() {
            return this.joinChannels;
        }

        public int hashCode() {
            return Objects.hash(this.types, this.joinChannels);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            return Objects.equals(this.types, other.types) && Objects.equals(this.joinChannels, other.joinChannels);
        }
    }

    public static class PagesHashStrategyFactory {
        private final Constructor<? extends PagesHashStrategy> constructor;

        public PagesHashStrategyFactory(Class<? extends PagesHashStrategy> pagesHashStrategyClass) {
            try {
                this.constructor = pagesHashStrategyClass.getConstructor(List.class, Optional.class);
            }
            catch (NoSuchMethodException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        public PagesHashStrategy createPagesHashStrategy(List<? extends List<Block>> channels, Optional<Integer> hashChannel) {
            try {
                return this.constructor.newInstance(channels, hashChannel);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    public static class LookupSourceFactory {
        private final Constructor<? extends LookupSource> constructor;
        private final PagesHashStrategyFactory pagesHashStrategyFactory;

        public LookupSourceFactory(Class<? extends LookupSource> lookupSourceClass, PagesHashStrategyFactory pagesHashStrategyFactory) {
            this.pagesHashStrategyFactory = pagesHashStrategyFactory;
            try {
                this.constructor = lookupSourceClass.getConstructor(LongArrayList.class, PagesHashStrategy.class);
            }
            catch (NoSuchMethodException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        public LookupSource createLookupSource(LongArrayList addresses, List<List<Block>> channels, Optional<Integer> hashChannel) {
            PagesHashStrategy pagesHashStrategy = this.pagesHashStrategyFactory.createPagesHashStrategy(channels, hashChannel);
            try {
                return this.constructor.newInstance(addresses, pagesHashStrategy);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }
}

