/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.byteCode.ByteCodeBlock;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.Variable;
import com.facebook.presto.byteCode.control.IfStatement;
import com.facebook.presto.byteCode.expression.ByteCodeExpressions;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.Binding;
import com.facebook.presto.sql.gen.ByteCodeGenerator;
import com.facebook.presto.sql.gen.ByteCodeGeneratorContext;
import com.facebook.presto.sql.gen.ByteCodeUtils;
import com.facebook.presto.sql.gen.CompilerOperations;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.type.UnknownType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;

public class IsDistinctFromCodeGenerator
implements ByteCodeGenerator {
    @Override
    public ByteCodeNode generateExpression(Signature signature, ByteCodeGeneratorContext generatorContext, Type returnType, List<RowExpression> arguments) {
        Preconditions.checkArgument((arguments.size() == 2 ? 1 : 0) != 0);
        Variable wasNull = generatorContext.wasNull();
        RowExpression left = arguments.get(0);
        RowExpression right = arguments.get(1);
        Type leftType = left.getType();
        Type rightType = right.getType();
        Signature equalsSignature = generatorContext.getRegistry().resolveOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)leftType, (Object)rightType));
        MethodHandle methodHandle = generatorContext.getRegistry().getScalarFunctionImplementation(equalsSignature).getMethodHandle();
        Binding binding = generatorContext.getCallSiteBinder().bind(methodHandle);
        ByteCodeBlock equalsCall = new ByteCodeBlock().comment("equals(%s, %s)", leftType, rightType).append(ByteCodeUtils.invoke(binding, equalsSignature));
        ByteCodeBlock neitherSideIsNull = leftType instanceof UnknownType || rightType instanceof UnknownType ? new ByteCodeBlock().comment("unreachable code").push(false) : new ByteCodeBlock().append(equalsCall).invokeStatic(CompilerOperations.class, "not", Boolean.TYPE, Boolean.TYPE);
        ByteCodeBlock block = new ByteCodeBlock().comment("IS DISTINCT FROM").comment("left").append(generatorContext.generate(left)).append(new IfStatement().condition(wasNull).ifTrue(new ByteCodeBlock().pop(leftType.getJavaType()).append(wasNull.set(ByteCodeExpressions.constantFalse())).comment("right is not null").append(generatorContext.generate(right)).pop(rightType.getJavaType()).append(wasNull).invokeStatic(CompilerOperations.class, "not", Boolean.TYPE, Boolean.TYPE)).ifFalse(new ByteCodeBlock().comment("right").append(generatorContext.generate(right)).append(new IfStatement().condition(wasNull).ifTrue(new ByteCodeBlock().pop(leftType.getJavaType()).pop(rightType.getJavaType()).push(true)).ifFalse(neitherSideIsNull)))).append(wasNull.set(ByteCodeExpressions.constantFalse()));
        return block;
    }
}

