/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.byteCode.Access;
import com.facebook.presto.byteCode.ByteCodeBlock;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.ClassDefinition;
import com.facebook.presto.byteCode.MethodDefinition;
import com.facebook.presto.byteCode.OpCode;
import com.facebook.presto.byteCode.Parameter;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.Scope;
import com.facebook.presto.byteCode.Variable;
import com.facebook.presto.byteCode.control.ForLoop;
import com.facebook.presto.byteCode.control.IfStatement;
import com.facebook.presto.byteCode.instruction.LabelNode;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.operator.CursorProcessor;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.BodyCompiler;
import com.facebook.presto.sql.gen.ByteCodeExpressionVisitor;
import com.facebook.presto.sql.gen.ByteCodeUtils;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.CompilerOperations;
import com.facebook.presto.sql.relational.CallExpression;
import com.facebook.presto.sql.relational.ConstantExpression;
import com.facebook.presto.sql.relational.InputReferenceExpression;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.sql.relational.RowExpressionVisitor;
import com.google.common.primitives.Primitives;
import io.airlift.slice.Slice;
import java.util.List;

public class CursorProcessorCompiler
implements BodyCompiler<CursorProcessor> {
    private final Metadata metadata;

    public CursorProcessorCompiler(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public void generateMethods(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, RowExpression filter, List<RowExpression> projections) {
        classDefinition.declareDefaultConstructor(Access.a(Access.PUBLIC));
        this.generateProcessMethod(classDefinition, projections.size());
        this.generateFilterMethod(classDefinition, callSiteBinder, filter);
        for (int i = 0; i < projections.size(); ++i) {
            this.generateProjectMethod(classDefinition, callSiteBinder, "project_" + i, projections.get(i));
        }
    }

    private void generateProcessMethod(ClassDefinition classDefinition, int projections) {
        Parameter session = Parameter.arg("session", ConnectorSession.class);
        Parameter cursor = Parameter.arg("cursor", RecordCursor.class);
        Parameter count = Parameter.arg("count", Integer.TYPE);
        Parameter pageBuilder = Parameter.arg("pageBuilder", PageBuilder.class);
        MethodDefinition method = classDefinition.declareMethod(Access.a(Access.PUBLIC), "process", ParameterizedType.type(Integer.TYPE), session, cursor, count, pageBuilder);
        Scope scope = method.getScope();
        Variable completedPositionsVariable = scope.declareVariable(Integer.TYPE, "completedPositions");
        method.getBody().comment("int completedPositions = 0;").putVariable(completedPositionsVariable, 0);
        LabelNode done = new LabelNode("done");
        ForLoop forLoop = new ForLoop().initialize(OpCode.NOP).condition(new ByteCodeBlock().comment("completedPositions < count").getVariable(completedPositionsVariable).getVariable(count).invokeStatic(CompilerOperations.class, "lessThan", Boolean.TYPE, Integer.TYPE, Integer.TYPE)).update(new ByteCodeBlock().comment("completedPositions++").incrementVariable(completedPositionsVariable, (byte)1));
        ByteCodeBlock forLoopBody = new ByteCodeBlock().comment("if (pageBuilder.isFull()) break;").append(new ByteCodeBlock().getVariable(pageBuilder).invokeVirtual(PageBuilder.class, "isFull", Boolean.TYPE, new Class[0]).ifTrueGoto(done)).comment("if (!cursor.advanceNextPosition()) break;").append(new ByteCodeBlock().getVariable(cursor).invokeInterface(RecordCursor.class, "advanceNextPosition", Boolean.TYPE, new Class[0]).ifFalseGoto(done));
        forLoop.body(forLoopBody);
        IfStatement ifStatement = new IfStatement();
        ifStatement.condition().append(method.getThis()).getVariable(session).getVariable(cursor).invokeVirtual(classDefinition.getType(), "filter", ParameterizedType.type(Boolean.TYPE), ParameterizedType.type(ConnectorSession.class), ParameterizedType.type(RecordCursor.class));
        ifStatement.ifTrue().getVariable(pageBuilder).invokeVirtual(PageBuilder.class, "declarePosition", Void.TYPE, new Class[0]);
        for (int projectionIndex = 0; projectionIndex < projections; ++projectionIndex) {
            ifStatement.ifTrue().append(method.getThis()).getVariable(session).getVariable(cursor);
            ifStatement.ifTrue().getVariable(pageBuilder).push(projectionIndex).invokeVirtual(PageBuilder.class, "getBlockBuilder", BlockBuilder.class, Integer.TYPE);
            ifStatement.ifTrue().invokeVirtual(classDefinition.getType(), "project_" + projectionIndex, ParameterizedType.type(Void.TYPE), ParameterizedType.type(ConnectorSession.class), ParameterizedType.type(RecordCursor.class), ParameterizedType.type(BlockBuilder.class));
        }
        forLoopBody.append(ifStatement);
        method.getBody().append(forLoop).visitLabel(done).comment("return completedPositions;").getVariable(completedPositionsVariable).retInt();
    }

    private void generateFilterMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, RowExpression filter) {
        Parameter session = Parameter.arg("session", ConnectorSession.class);
        Parameter cursor = Parameter.arg("cursor", RecordCursor.class);
        MethodDefinition method = classDefinition.declareMethod(Access.a(Access.PUBLIC), "filter", ParameterizedType.type(Boolean.TYPE), session, cursor);
        method.comment("Filter: %s", filter);
        Scope scope = method.getScope();
        Variable wasNullVariable = scope.declareVariable(ParameterizedType.type(Boolean.TYPE), "wasNull");
        ByteCodeExpressionVisitor visitor = new ByteCodeExpressionVisitor(callSiteBinder, this.fieldReferenceCompiler(cursor, wasNullVariable), this.metadata.getFunctionRegistry());
        LabelNode end = new LabelNode("end");
        method.getBody().comment("boolean wasNull = false;").putVariable(wasNullVariable, false).comment("evaluate filter: " + filter).append(filter.accept(visitor, scope)).comment("if (wasNull) return false;").getVariable(wasNullVariable).ifFalseGoto(end).pop(Boolean.TYPE).push(false).visitLabel(end).retBoolean();
    }

    private void generateProjectMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, String methodName, RowExpression projection) {
        Parameter session = Parameter.arg("session", ConnectorSession.class);
        Parameter cursor = Parameter.arg("cursor", RecordCursor.class);
        Parameter output = Parameter.arg("output", BlockBuilder.class);
        MethodDefinition method = classDefinition.declareMethod(Access.a(Access.PUBLIC), methodName, ParameterizedType.type(Void.TYPE), session, cursor, output);
        method.comment("Projection: %s", projection.toString());
        Scope scope = method.getScope();
        Variable wasNullVariable = scope.declareVariable(ParameterizedType.type(Boolean.TYPE), "wasNull");
        ByteCodeBlock body = method.getBody().comment("boolean wasNull = false;").putVariable(wasNullVariable, false);
        ByteCodeExpressionVisitor visitor = new ByteCodeExpressionVisitor(callSiteBinder, this.fieldReferenceCompiler(cursor, wasNullVariable), this.metadata.getFunctionRegistry());
        body.getVariable(output).comment("evaluate projection: " + projection.toString()).append(projection.accept(visitor, scope)).append(ByteCodeUtils.generateWrite(callSiteBinder, scope, wasNullVariable, projection.getType())).ret();
    }

    private RowExpressionVisitor<Scope, ByteCodeNode> fieldReferenceCompiler(final Variable cursorVariable, final Variable wasNullVariable) {
        return new RowExpressionVisitor<Scope, ByteCodeNode>(){

            @Override
            public ByteCodeNode visitInputReference(InputReferenceExpression node, Scope scope) {
                int field = node.getField();
                Type type = node.getType();
                Class<Object> javaType = type.getJavaType();
                if (!javaType.isPrimitive() && javaType != Slice.class) {
                    javaType = Object.class;
                }
                IfStatement ifStatement = new IfStatement();
                ifStatement.condition().setDescription(String.format("cursor.get%s(%d)", type, field)).getVariable(cursorVariable).push(field).invokeInterface(RecordCursor.class, "isNull", Boolean.TYPE, Integer.TYPE);
                ifStatement.ifTrue().putVariable(wasNullVariable, true).pushJavaDefault(javaType);
                ifStatement.ifFalse().getVariable(cursorVariable).push(field).invokeInterface(RecordCursor.class, "get" + Primitives.wrap(javaType).getSimpleName(), javaType, Integer.TYPE);
                return ifStatement;
            }

            @Override
            public ByteCodeNode visitCall(CallExpression call, Scope scope) {
                throw new UnsupportedOperationException("not yet implemented");
            }

            @Override
            public ByteCodeNode visitConstant(ConstantExpression literal, Scope scope) {
                throw new UnsupportedOperationException("not yet implemented");
            }
        };
    }
}

