/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.byteCode.ByteCodeBlock;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.OpCode;
import com.facebook.presto.byteCode.Scope;
import com.facebook.presto.byteCode.Variable;
import com.facebook.presto.byteCode.control.IfStatement;
import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.facebook.presto.byteCode.expression.ByteCodeExpressions;
import com.facebook.presto.byteCode.instruction.LabelNode;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.Binding;
import com.facebook.presto.sql.gen.Bootstrap;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Primitives;
import io.airlift.slice.Slice;
import java.lang.constant.Constable;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.util.ArrayList;
import java.util.List;

public final class ByteCodeUtils {
    private ByteCodeUtils() {
    }

    public static ByteCodeNode ifWasNullPopAndGoto(Scope scope, LabelNode label, Class<?> returnType, Class<?> ... stackArgsToPop) {
        return ByteCodeUtils.handleNullValue(scope, label, returnType, ImmutableList.copyOf((Object[])stackArgsToPop), false);
    }

    public static ByteCodeNode ifWasNullPopAndGoto(Scope scope, LabelNode label, Class<?> returnType, Iterable<? extends Class<?>> stackArgsToPop) {
        return ByteCodeUtils.handleNullValue(scope, label, returnType, ImmutableList.copyOf(stackArgsToPop), false);
    }

    public static ByteCodeNode ifWasNullClearPopAndGoto(Scope scope, LabelNode label, Class<?> returnType, Class<?> ... stackArgsToPop) {
        return ByteCodeUtils.handleNullValue(scope, label, returnType, ImmutableList.copyOf((Object[])stackArgsToPop), true);
    }

    public static ByteCodeNode handleNullValue(Scope scope, LabelNode label, Class<?> returnType, List<Class<?>> stackArgsToPop, boolean clearNullFlag) {
        Variable wasNull = scope.getVariable("wasNull");
        ByteCodeBlock nullCheck = new ByteCodeBlock().setDescription("ifWasNullGoto").append(wasNull);
        String clearComment = null;
        if (clearNullFlag) {
            nullCheck.append(wasNull.set(ByteCodeExpressions.constantFalse()));
            clearComment = "clear wasNull";
        }
        ByteCodeBlock isNull = new ByteCodeBlock();
        for (Class<?> parameterType : stackArgsToPop) {
            isNull.pop(parameterType);
        }
        isNull.pushJavaDefault(returnType);
        String loadDefaultComment = null;
        if (returnType != Void.TYPE) {
            loadDefaultComment = String.format("loadJavaDefault(%s)", returnType.getName());
        }
        isNull.gotoLabel(label);
        String popComment = null;
        if (!stackArgsToPop.isEmpty()) {
            popComment = String.format("pop(%s)", Joiner.on((String)", ").join(stackArgsToPop));
        }
        return new IfStatement("if wasNull then %s", Joiner.on((String)", ").skipNulls().join((Object)clearComment, (Object)popComment, new Object[]{loadDefaultComment, "goto " + label.getLabel()})).condition(nullCheck).ifTrue(isNull);
    }

    public static ByteCodeNode boxPrimitive(Class<?> type) {
        ByteCodeBlock block = new ByteCodeBlock().comment("box primitive");
        if (type == Long.TYPE) {
            return block.invokeStatic(Long.class, "valueOf", Long.class, Long.TYPE);
        }
        if (type == Double.TYPE) {
            return block.invokeStatic(Double.class, "valueOf", Double.class, Double.TYPE);
        }
        if (type == Boolean.TYPE) {
            return block.invokeStatic(Boolean.class, "valueOf", Boolean.class, Boolean.TYPE);
        }
        if (type.isPrimitive()) {
            throw new UnsupportedOperationException("not yet implemented: " + type);
        }
        return OpCode.NOP;
    }

    public static ByteCodeNode unboxPrimitive(Class<?> unboxedType) {
        ByteCodeBlock block = new ByteCodeBlock().comment("unbox primitive");
        if (unboxedType == Long.TYPE) {
            return block.invokeVirtual(Long.class, "longValue", Long.TYPE, new Class[0]);
        }
        if (unboxedType == Double.TYPE) {
            return block.invokeVirtual(Double.class, "doubleValue", Double.TYPE, new Class[0]);
        }
        if (unboxedType == Boolean.TYPE) {
            return block.invokeVirtual(Boolean.class, "booleanValue", Boolean.TYPE, new Class[0]);
        }
        throw new UnsupportedOperationException("not yet implemented: " + unboxedType);
    }

    public static ByteCodeExpression loadConstant(CallSiteBinder callSiteBinder, Object constant, Class<?> type) {
        Binding binding = callSiteBinder.bind(MethodHandles.constant(type, constant));
        return ByteCodeUtils.loadConstant(binding);
    }

    public static ByteCodeExpression loadConstant(Binding binding) {
        return ByteCodeExpressions.invokeDynamic(Bootstrap.BOOTSTRAP_METHOD, (Iterable<? extends Object>)ImmutableList.of((Object)binding.getBindingId()), "constant_" + binding.getBindingId(), binding.getType().returnType(), new ByteCodeExpression[0]);
    }

    public static ByteCodeNode generateInvocation(Scope scope, String name, ScalarFunctionImplementation function, List<ByteCodeNode> arguments, Binding binding) {
        MethodType methodType = binding.getType();
        TypeDescriptor.OfField returnType = methodType.returnType();
        Class unboxedReturnType = Primitives.unwrap((Class)returnType);
        LabelNode end = new LabelNode("end");
        ByteCodeBlock block = new ByteCodeBlock().setDescription("invoke " + name);
        ArrayList stackTypes = new ArrayList();
        int index = 0;
        for (Class<?> type : methodType.parameterArray()) {
            stackTypes.add(type);
            if (type == ConnectorSession.class) {
                block.append(scope.getVariable("session"));
                continue;
            }
            block.append(arguments.get(index));
            if (!function.getNullableArguments().get(index).booleanValue()) {
                Preconditions.checkArgument((!Primitives.isWrapperType(type) ? 1 : 0) != 0, (Object)"Non-nullable argument must not be primitive wrapper type");
                block.append(ByteCodeUtils.ifWasNullPopAndGoto(scope, end, unboxedReturnType, Lists.reverse(stackTypes)));
            } else {
                block.append(ByteCodeUtils.boxPrimitiveIfNecessary(scope, type));
                block.append(scope.getVariable("wasNull").set(ByteCodeExpressions.constantFalse()));
            }
            ++index;
        }
        block.append(ByteCodeUtils.invoke(binding, name));
        if (function.isNullable()) {
            block.append(ByteCodeUtils.unboxPrimitiveIfNecessary(scope, returnType));
        }
        block.visitLabel(end);
        return block;
    }

    public static ByteCodeBlock unboxPrimitiveIfNecessary(Scope scope, Class<?> boxedType) {
        ByteCodeBlock block = new ByteCodeBlock();
        LabelNode end = new LabelNode("end");
        Class unboxedType = Primitives.unwrap(boxedType);
        Variable wasNull = scope.getVariable("wasNull");
        if (unboxedType == Void.TYPE) {
            block.pop(boxedType).append(wasNull.set(ByteCodeExpressions.constantTrue()));
        } else if (unboxedType.isPrimitive()) {
            LabelNode notNull = new LabelNode("notNull");
            block.dup(boxedType).ifNotNullGoto(notNull).append(wasNull.set(ByteCodeExpressions.constantTrue())).comment("swap boxed null with unboxed default").pop(boxedType).pushJavaDefault(unboxedType).gotoLabel(end).visitLabel(notNull).append(ByteCodeUtils.unboxPrimitive(unboxedType));
        } else {
            block.dup(boxedType).ifNotNullGoto(end).append(wasNull.set(ByteCodeExpressions.constantTrue()));
        }
        block.visitLabel(end);
        return block;
    }

    public static ByteCodeNode boxPrimitiveIfNecessary(Scope scope, Class<?> type) {
        Class<Constable> expectedCurrentStackType;
        if (!Primitives.isWrapperType(type)) {
            return OpCode.NOP;
        }
        ByteCodeBlock notNull = new ByteCodeBlock().comment("box primitive");
        if (type == Long.class) {
            notNull.invokeStatic(Long.class, "valueOf", Long.class, Long.TYPE);
            expectedCurrentStackType = Long.TYPE;
        } else if (type == Double.class) {
            notNull.invokeStatic(Double.class, "valueOf", Double.class, Double.TYPE);
            expectedCurrentStackType = Double.TYPE;
        } else if (type == Boolean.class) {
            notNull.invokeStatic(Boolean.class, "valueOf", Boolean.class, Boolean.TYPE);
            expectedCurrentStackType = Boolean.TYPE;
        } else {
            if (type == Void.class) {
                notNull.pushNull().checkCast(Void.class);
                return notNull;
            }
            throw new UnsupportedOperationException("not yet implemented: " + type);
        }
        ByteCodeBlock condition = new ByteCodeBlock().append(scope.getVariable("wasNull"));
        ByteCodeBlock wasNull = new ByteCodeBlock().pop(expectedCurrentStackType).pushNull().checkCast(type);
        return new IfStatement().condition(condition).ifTrue(wasNull).ifFalse(notNull);
    }

    public static ByteCodeNode invoke(Binding binding, String name) {
        return ByteCodeExpressions.invokeDynamic(Bootstrap.BOOTSTRAP_METHOD, (Iterable<? extends Object>)ImmutableList.of((Object)binding.getBindingId()), name, binding.getType(), new ByteCodeExpression[0]);
    }

    public static ByteCodeNode invoke(Binding binding, Signature signature) {
        return ByteCodeUtils.invoke(binding, signature.getName());
    }

    public static ByteCodeNode generateWrite(CallSiteBinder callSiteBinder, Scope scope, Variable wasNullVariable, Type type) {
        if (type.getJavaType() == Void.TYPE) {
            return new ByteCodeBlock().comment("output.appendNull();").invokeInterface(BlockBuilder.class, "appendNull", BlockBuilder.class, new Class[0]).pop();
        }
        Class<Object> valueJavaType = type.getJavaType();
        if (!valueJavaType.isPrimitive() && valueJavaType != Slice.class) {
            valueJavaType = Object.class;
        }
        String methodName = "write" + Primitives.wrap(valueJavaType).getSimpleName();
        Variable tempValue = scope.createTempVariable(valueJavaType);
        Variable tempOutput = scope.createTempVariable(BlockBuilder.class);
        return new ByteCodeBlock().comment("if (wasNull)").append(new IfStatement().condition(wasNullVariable).ifTrue(new ByteCodeBlock().comment("output.appendNull();").pop(valueJavaType).invokeInterface(BlockBuilder.class, "appendNull", BlockBuilder.class, new Class[0]).pop()).ifFalse(new ByteCodeBlock().comment("%s.%s(output, %s)", type.getTypeSignature(), methodName, valueJavaType.getSimpleName()).putVariable(tempValue).putVariable(tempOutput).append(ByteCodeUtils.loadConstant(callSiteBinder.bind(type, Type.class))).getVariable(tempOutput).getVariable(tempValue).invokeInterface(Type.class, methodName, Void.TYPE, BlockBuilder.class, valueJavaType)));
    }
}

