/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.Scope;
import com.facebook.presto.byteCode.Variable;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.sql.gen.Binding;
import com.facebook.presto.sql.gen.ByteCodeExpressionVisitor;
import com.facebook.presto.sql.gen.ByteCodeUtils;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.relational.RowExpression;
import java.util.List;
import java.util.Objects;

public class ByteCodeGeneratorContext {
    private final ByteCodeExpressionVisitor byteCodeGenerator;
    private final Scope scope;
    private final CallSiteBinder callSiteBinder;
    private final FunctionRegistry registry;
    private final Variable wasNull;

    public ByteCodeGeneratorContext(ByteCodeExpressionVisitor byteCodeGenerator, Scope scope, CallSiteBinder callSiteBinder, FunctionRegistry registry) {
        Objects.requireNonNull(byteCodeGenerator, "byteCodeGenerator is null");
        Objects.requireNonNull(scope, "scope is null");
        Objects.requireNonNull(callSiteBinder, "callSiteBinder is null");
        Objects.requireNonNull(registry, "registry is null");
        this.byteCodeGenerator = byteCodeGenerator;
        this.scope = scope;
        this.callSiteBinder = callSiteBinder;
        this.registry = registry;
        this.wasNull = scope.getVariable("wasNull");
    }

    public Scope getScope() {
        return this.scope;
    }

    public CallSiteBinder getCallSiteBinder() {
        return this.callSiteBinder;
    }

    public ByteCodeNode generate(RowExpression expression) {
        return expression.accept(this.byteCodeGenerator, this.scope);
    }

    public FunctionRegistry getRegistry() {
        return this.registry;
    }

    public ByteCodeNode generateCall(String name, ScalarFunctionImplementation function, List<ByteCodeNode> arguments) {
        Binding binding = this.callSiteBinder.bind(function.getMethodHandle());
        return ByteCodeUtils.generateInvocation(this.scope, name, function, arguments, binding);
    }

    public Variable wasNull() {
        return this.wasNull;
    }
}

