/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.byteCode.ByteCodeBlock;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.Scope;
import com.facebook.presto.byteCode.expression.ByteCodeExpressions;
import com.facebook.presto.byteCode.instruction.Constant;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.sql.gen.AndCodeGenerator;
import com.facebook.presto.sql.gen.Binding;
import com.facebook.presto.sql.gen.ByteCodeGenerator;
import com.facebook.presto.sql.gen.ByteCodeGeneratorContext;
import com.facebook.presto.sql.gen.ByteCodeUtils;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.CastCodeGenerator;
import com.facebook.presto.sql.gen.CoalesceCodeGenerator;
import com.facebook.presto.sql.gen.FunctionCallCodeGenerator;
import com.facebook.presto.sql.gen.IfCodeGenerator;
import com.facebook.presto.sql.gen.InCodeGenerator;
import com.facebook.presto.sql.gen.IsDistinctFromCodeGenerator;
import com.facebook.presto.sql.gen.IsNullCodeGenerator;
import com.facebook.presto.sql.gen.NullIfCodeGenerator;
import com.facebook.presto.sql.gen.OrCodeGenerator;
import com.facebook.presto.sql.gen.SwitchCodeGenerator;
import com.facebook.presto.sql.relational.CallExpression;
import com.facebook.presto.sql.relational.ConstantExpression;
import com.facebook.presto.sql.relational.InputReferenceExpression;
import com.facebook.presto.sql.relational.RowExpressionVisitor;
import com.facebook.presto.sql.relational.Signatures;

public class ByteCodeExpressionVisitor
implements RowExpressionVisitor<Scope, ByteCodeNode> {
    private final CallSiteBinder callSiteBinder;
    private final RowExpressionVisitor<Scope, ByteCodeNode> fieldReferenceCompiler;
    private final FunctionRegistry registry;

    public ByteCodeExpressionVisitor(CallSiteBinder callSiteBinder, RowExpressionVisitor<Scope, ByteCodeNode> fieldReferenceCompiler, FunctionRegistry registry) {
        this.callSiteBinder = callSiteBinder;
        this.fieldReferenceCompiler = fieldReferenceCompiler;
        this.registry = registry;
    }

    @Override
    public ByteCodeNode visitCall(CallExpression call, Scope scope) {
        ByteCodeGenerator generator;
        if (call.getSignature().getName().equals(Signatures.CAST)) {
            generator = new CastCodeGenerator();
        } else {
            switch (call.getSignature().getName()) {
                case "IF": {
                    generator = new IfCodeGenerator();
                    break;
                }
                case "NULL_IF": {
                    generator = new NullIfCodeGenerator();
                    break;
                }
                case "SWITCH": {
                    generator = new SwitchCodeGenerator();
                    break;
                }
                case "IS_NULL": {
                    generator = new IsNullCodeGenerator();
                    break;
                }
                case "IS_DISTINCT_FROM": {
                    generator = new IsDistinctFromCodeGenerator();
                    break;
                }
                case "COALESCE": {
                    generator = new CoalesceCodeGenerator();
                    break;
                }
                case "IN": {
                    generator = new InCodeGenerator(this.registry);
                    break;
                }
                case "AND": {
                    generator = new AndCodeGenerator();
                    break;
                }
                case "OR": {
                    generator = new OrCodeGenerator();
                    break;
                }
                default: {
                    generator = new FunctionCallCodeGenerator();
                }
            }
        }
        ByteCodeGeneratorContext generatorContext = new ByteCodeGeneratorContext(this, scope, this.callSiteBinder, this.registry);
        return generator.generateExpression(call.getSignature(), generatorContext, call.getType(), call.getArguments());
    }

    @Override
    public ByteCodeNode visitConstant(ConstantExpression constant, Scope scope) {
        Object value = constant.getValue();
        Class javaType = constant.getType().getJavaType();
        ByteCodeBlock block = new ByteCodeBlock();
        if (value == null) {
            return block.comment("constant null").append(scope.getVariable("wasNull").set(ByteCodeExpressions.constantTrue())).pushJavaDefault(javaType);
        }
        block.comment("constant " + constant.getType().getTypeSignature());
        if (javaType == Boolean.TYPE) {
            return block.append(Constant.loadBoolean((Boolean)value));
        }
        if (javaType == Byte.TYPE || javaType == Short.TYPE || javaType == Integer.TYPE) {
            return block.append(Constant.loadInt(((Number)value).intValue()));
        }
        if (javaType == Long.TYPE) {
            return block.append(Constant.loadLong((Long)value));
        }
        if (javaType == Float.TYPE) {
            return block.append(Constant.loadFloat(((Float)value).floatValue()));
        }
        if (javaType == Double.TYPE) {
            return block.append(Constant.loadDouble((Double)value));
        }
        if (javaType == String.class) {
            return block.append(Constant.loadString((String)value));
        }
        if (javaType == Void.TYPE) {
            return block;
        }
        Binding binding = this.callSiteBinder.bind(value, constant.getType().getJavaType());
        return new ByteCodeBlock().setDescription("constant " + constant.getType()).comment(constant.toString()).append(ByteCodeUtils.loadConstant(binding));
    }

    @Override
    public ByteCodeNode visitInputReference(InputReferenceExpression node, Scope scope) {
        return this.fieldReferenceCompiler.visitInputReference(node, scope);
    }
}

