/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.byteCode.ByteCodeBlock;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.MethodGenerationContext;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.Scope;
import com.facebook.presto.byteCode.Variable;
import com.facebook.presto.byteCode.control.ForLoop;
import com.facebook.presto.byteCode.control.IfStatement;
import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.facebook.presto.byteCode.expression.ByteCodeExpressions;
import com.facebook.presto.byteCode.instruction.VariableInstruction;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.SqlTypeByteCodeExpression;
import com.facebook.presto.type.UnknownType;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;

public class ArrayMapByteCodeExpression
extends ByteCodeExpression {
    private static final AtomicLong NEXT_VARIABLE_ID = new AtomicLong();
    private final ByteCodeBlock body = new ByteCodeBlock();
    private final String oneLineDescription;

    public ArrayMapByteCodeExpression(Scope scope, CallSiteBinder binder, ByteCodeExpression array, Type fromType, Type toType, Function<ByteCodeExpression, ByteCodeExpression> mapper) {
        super(ParameterizedType.type(Block.class));
        String mapperDescription;
        ByteCodeBlock mapElement;
        Variable blockBuilder = scope.declareVariable(BlockBuilder.class, "blockBuilder_" + NEXT_VARIABLE_ID.getAndIncrement());
        this.body.append(blockBuilder.set(SqlTypeByteCodeExpression.constantType(binder, toType).invoke("createBlockBuilder", BlockBuilder.class, ByteCodeExpressions.newInstance(BlockBuilderStatus.class, new ByteCodeExpression[0]), array.invoke("getPositionCount", Integer.TYPE, new ByteCodeExpression[0]))));
        Variable position = scope.declareVariable(Integer.TYPE, "position_" + NEXT_VARIABLE_ID.getAndIncrement());
        if (fromType instanceof UnknownType) {
            mapElement = new ByteCodeBlock().comment("unreachable code");
            mapperDescription = "null";
        } else {
            Variable element = scope.declareVariable(fromType.getJavaType(), "element_" + NEXT_VARIABLE_ID.getAndIncrement());
            Variable newElement = scope.declareVariable(toType.getJavaType(), "newElement_" + NEXT_VARIABLE_ID.getAndIncrement());
            SqlTypeByteCodeExpression elementTypeConstant = SqlTypeByteCodeExpression.constantType(binder, fromType);
            SqlTypeByteCodeExpression newElementTypeConstant = SqlTypeByteCodeExpression.constantType(binder, toType);
            mapElement = new ByteCodeBlock().append(element.set(elementTypeConstant.getValue(array, position))).append(newElement.set(mapper.apply(element))).append(newElementTypeConstant.writeValue(blockBuilder, newElement));
            mapperDescription = mapper.apply(element).toString();
        }
        this.body.append(new ForLoop().initialize(position.set(ByteCodeExpressions.constantInt(0))).condition(ByteCodeExpressions.lessThan(position, array.invoke("getPositionCount", Integer.TYPE, new ByteCodeExpression[0]))).update(VariableInstruction.incrementVariable(position, (byte)1)).body(new IfStatement().condition(array.invoke("isNull", Boolean.TYPE, position)).ifTrue(blockBuilder.invoke("appendNull", BlockBuilder.class, new ByteCodeExpression[0]).pop()).ifFalse(mapElement)));
        this.body.append(blockBuilder.invoke("build", Block.class, new ByteCodeExpression[0]));
        this.oneLineDescription = "arrayMap(" + array + ", element -> " + mapperDescription + ")";
    }

    @Override
    public ByteCodeNode getByteCode(MethodGenerationContext generationContext) {
        return this.body;
    }

    @Override
    public List<ByteCodeNode> getChildNodes() {
        return ImmutableList.of();
    }

    @Override
    protected String formatOneLine() {
        return this.oneLineDescription;
    }
}

