/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.server.ForAsyncHttp;
import com.facebook.presto.util.Types;
import io.airlift.concurrent.ThreadPoolExecutorMBean;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import javax.inject.Inject;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class AsyncHttpExecutionMBean {
    private final ThreadPoolExecutorMBean responseExecutor;
    private final ThreadPoolExecutorMBean timeoutExecutor;

    @Inject
    public AsyncHttpExecutionMBean(@ForAsyncHttp ExecutorService responseExecutor, @ForAsyncHttp ScheduledExecutorService timeoutExecutor) {
        Objects.requireNonNull(responseExecutor, "responseExecutor is null");
        Objects.requireNonNull(timeoutExecutor, "timeoutExecutor is null");
        this.responseExecutor = new ThreadPoolExecutorMBean(Types.checkType(responseExecutor, ThreadPoolExecutor.class, "response-executor"));
        this.timeoutExecutor = new ThreadPoolExecutorMBean(Types.checkType(timeoutExecutor, ThreadPoolExecutor.class, "timeout-executor"));
    }

    @Managed
    @Nested
    public ThreadPoolExecutorMBean getResponseExecutor() {
        return this.responseExecutor;
    }

    @Managed
    @Nested
    public ThreadPoolExecutorMBean getTimeoutExecutor() {
        return this.timeoutExecutor;
    }
}

