/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.security;

import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.security.ConnectorAccessControl;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.security.SystemAccessControl;
import com.facebook.presto.spi.security.SystemAccessControlFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.airlift.log.Logger;
import io.airlift.stats.CounterStat;
import java.io.File;
import java.io.FileInputStream;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class AccessControlManager
implements AccessControl {
    private static final Logger log = Logger.get(AccessControlManager.class);
    private static final File ACCESS_CONTROL_CONFIGURATION = new File("etc/access-control.properties");
    private static final String ACCESS_CONTROL_PROPERTY_NAME = "access-control.name";
    public static final String ALLOW_ALL_ACCESS_CONTROL = "allow-all";
    private final Map<String, SystemAccessControlFactory> systemAccessControlFactories = new ConcurrentHashMap<String, SystemAccessControlFactory>();
    private final Map<String, ConnectorAccessControl> catalogAccessControl = new ConcurrentHashMap<String, ConnectorAccessControl>();
    private final AtomicReference<SystemAccessControl> systemAccessControl = new AtomicReference<InitializingSystemAccessControl>(new InitializingSystemAccessControl());
    private final AtomicBoolean systemAccessControlLoading = new AtomicBoolean();
    private final CounterStat authenticationSuccess = new CounterStat();
    private final CounterStat authenticationFail = new CounterStat();
    private final CounterStat authorizationSuccess = new CounterStat();
    private final CounterStat authorizationFail = new CounterStat();

    @Inject
    public AccessControlManager() {
        this.systemAccessControlFactories.put(ALLOW_ALL_ACCESS_CONTROL, new SystemAccessControlFactory(){

            public String getName() {
                return AccessControlManager.ALLOW_ALL_ACCESS_CONTROL;
            }

            public SystemAccessControl create(Map<String, String> config) {
                Objects.requireNonNull(config, "config is null");
                Preconditions.checkArgument((boolean)config.isEmpty(), (Object)"The none access-controller does not support any configuration properties");
                return new AllowAllSystemAccessControl();
            }
        });
    }

    public void addSystemAccessControlFactory(SystemAccessControlFactory accessControlFactory) {
        Objects.requireNonNull(accessControlFactory, "accessControlFactory is null");
        if (this.systemAccessControlFactories.putIfAbsent(accessControlFactory.getName(), accessControlFactory) != null) {
            throw new IllegalArgumentException(String.format("Access control '%s' is already registered", accessControlFactory.getName()));
        }
    }

    public void addCatalogAccessControl(String catalogName, ConnectorAccessControl accessControl) {
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(accessControl, "accessControl is null");
        if (this.catalogAccessControl.putIfAbsent(catalogName, accessControl) != null) {
            throw new IllegalArgumentException(String.format("Access control for catalog '%s' is already registered", catalogName));
        }
    }

    public void loadSystemAccessControl() throws Exception {
        if (ACCESS_CONTROL_CONFIGURATION.exists()) {
            HashMap<String, String> properties = new HashMap<String, String>(AccessControlManager.loadProperties(ACCESS_CONTROL_CONFIGURATION));
            String accessControlName = (String)properties.remove(ACCESS_CONTROL_PROPERTY_NAME);
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)accessControlName) ? 1 : 0) != 0, (String)"Access control configuration %s does not contain %s", (Object[])new Object[]{ACCESS_CONTROL_CONFIGURATION.getAbsoluteFile(), ACCESS_CONTROL_PROPERTY_NAME});
            this.setSystemAccessControl(accessControlName, properties);
        } else {
            this.setSystemAccessControl(ALLOW_ALL_ACCESS_CONTROL, (Map<String, String>)ImmutableMap.of());
        }
    }

    @VisibleForTesting
    protected void setSystemAccessControl(String name, Map<String, String> properties) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(properties, "properties is null");
        Preconditions.checkState((boolean)this.systemAccessControlLoading.compareAndSet(false, true), (Object)"System access control already initialized");
        log.info("-- Loading system access control --");
        SystemAccessControlFactory systemAccessControlFactory = this.systemAccessControlFactories.get(name);
        Preconditions.checkState((systemAccessControlFactory != null ? 1 : 0) != 0, (String)"Access control %s is not registered", (Object[])new Object[]{name});
        SystemAccessControl systemAccessControl = systemAccessControlFactory.create((Map)ImmutableMap.copyOf(properties));
        this.systemAccessControl.set(systemAccessControl);
        log.info("-- Loaded system access control %s --", new Object[]{name});
    }

    @Override
    public void checkCanSetUser(Principal principal, String userName) {
        Objects.requireNonNull(userName, "userName is null");
        this.authenticationCheck(() -> this.systemAccessControl.get().checkCanSetUser(principal, userName));
    }

    @Override
    public void checkCanCreateTable(Identity identity, QualifiedObjectName tableName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        ConnectorAccessControl accessControl = this.catalogAccessControl.get(tableName.getCatalogName());
        if (accessControl != null) {
            this.authorizationCheck(() -> accessControl.checkCanCreateTable(identity, tableName.asSchemaTableName()));
        }
    }

    @Override
    public void checkCanDropTable(Identity identity, QualifiedObjectName tableName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        ConnectorAccessControl accessControl = this.catalogAccessControl.get(tableName.getCatalogName());
        if (accessControl != null) {
            this.authorizationCheck(() -> accessControl.checkCanDropTable(identity, tableName.asSchemaTableName()));
        }
    }

    @Override
    public void checkCanRenameTable(Identity identity, QualifiedObjectName tableName, QualifiedObjectName newTableName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(newTableName, "newTableName is null");
        ConnectorAccessControl accessControl = this.catalogAccessControl.get(tableName.getCatalogName());
        if (accessControl != null) {
            this.authorizationCheck(() -> accessControl.checkCanRenameTable(identity, tableName.asSchemaTableName(), newTableName.asSchemaTableName()));
        }
    }

    @Override
    public void checkCanAddColumns(Identity identity, QualifiedObjectName tableName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        ConnectorAccessControl accessControl = this.catalogAccessControl.get(tableName.getCatalogName());
        if (accessControl != null) {
            this.authorizationCheck(() -> accessControl.checkCanAddColumn(identity, tableName.asSchemaTableName()));
        }
    }

    @Override
    public void checkCanRenameColumn(Identity identity, QualifiedObjectName tableName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        ConnectorAccessControl accessControl = this.catalogAccessControl.get(tableName.getCatalogName());
        if (accessControl != null) {
            this.authorizationCheck(() -> accessControl.checkCanRenameColumn(identity, tableName.asSchemaTableName()));
        }
    }

    @Override
    public void checkCanSelectFromTable(Identity identity, QualifiedObjectName tableName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        ConnectorAccessControl accessControl = this.catalogAccessControl.get(tableName.getCatalogName());
        if (accessControl != null) {
            this.authorizationCheck(() -> accessControl.checkCanSelectFromTable(identity, tableName.asSchemaTableName()));
        }
    }

    @Override
    public void checkCanInsertIntoTable(Identity identity, QualifiedObjectName tableName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        ConnectorAccessControl accessControl = this.catalogAccessControl.get(tableName.getCatalogName());
        if (accessControl != null) {
            this.authorizationCheck(() -> accessControl.checkCanInsertIntoTable(identity, tableName.asSchemaTableName()));
        }
    }

    @Override
    public void checkCanDeleteFromTable(Identity identity, QualifiedObjectName tableName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        ConnectorAccessControl accessControl = this.catalogAccessControl.get(tableName.getCatalogName());
        if (accessControl != null) {
            this.authorizationCheck(() -> accessControl.checkCanDeleteFromTable(identity, tableName.asSchemaTableName()));
        }
    }

    @Override
    public void checkCanCreateView(Identity identity, QualifiedObjectName viewName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(viewName, "viewName is null");
        ConnectorAccessControl accessControl = this.catalogAccessControl.get(viewName.getCatalogName());
        if (accessControl != null) {
            this.authorizationCheck(() -> accessControl.checkCanCreateView(identity, viewName.asSchemaTableName()));
        }
    }

    @Override
    public void checkCanDropView(Identity identity, QualifiedObjectName viewName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(viewName, "viewName is null");
        ConnectorAccessControl accessControl = this.catalogAccessControl.get(viewName.getCatalogName());
        if (accessControl != null) {
            this.authorizationCheck(() -> accessControl.checkCanDropView(identity, viewName.asSchemaTableName()));
        }
    }

    @Override
    public void checkCanSelectFromView(Identity identity, QualifiedObjectName viewName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(viewName, "viewName is null");
        ConnectorAccessControl accessControl = this.catalogAccessControl.get(viewName.getCatalogName());
        if (accessControl != null) {
            this.authorizationCheck(() -> accessControl.checkCanSelectFromView(identity, viewName.asSchemaTableName()));
        }
    }

    @Override
    public void checkCanCreateViewWithSelectFromTable(Identity identity, QualifiedObjectName tableName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        ConnectorAccessControl accessControl = this.catalogAccessControl.get(tableName.getCatalogName());
        if (accessControl != null) {
            this.authorizationCheck(() -> accessControl.checkCanCreateViewWithSelectFromTable(identity, tableName.asSchemaTableName()));
        }
    }

    @Override
    public void checkCanCreateViewWithSelectFromView(Identity identity, QualifiedObjectName viewName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(viewName, "viewName is null");
        ConnectorAccessControl accessControl = this.catalogAccessControl.get(viewName.getCatalogName());
        if (accessControl != null) {
            this.authorizationCheck(() -> accessControl.checkCanCreateViewWithSelectFromView(identity, viewName.asSchemaTableName()));
        }
    }

    @Override
    public void checkCanSetSystemSessionProperty(Identity identity, String propertyName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(propertyName, "propertyName is null");
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanSetSystemSessionProperty(identity, propertyName));
    }

    @Override
    public void checkCanSetCatalogSessionProperty(Identity identity, String catalogName, String propertyName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(propertyName, "propertyName is null");
        ConnectorAccessControl accessControl = this.catalogAccessControl.get(catalogName);
        if (accessControl != null) {
            this.authorizationCheck(() -> accessControl.checkCanSetCatalogSessionProperty(identity, propertyName));
        }
    }

    @Managed
    @Nested
    public CounterStat getAuthenticationSuccess() {
        return this.authenticationSuccess;
    }

    @Managed
    @Nested
    public CounterStat getAuthenticationFail() {
        return this.authenticationFail;
    }

    @Managed
    @Nested
    public CounterStat getAuthorizationSuccess() {
        return this.authorizationSuccess;
    }

    @Managed
    @Nested
    public CounterStat getAuthorizationFail() {
        return this.authorizationFail;
    }

    private void authenticationCheck(Runnable runnable) {
        try {
            runnable.run();
            this.authenticationSuccess.update(1L);
        }
        catch (PrestoException e) {
            this.authenticationFail.update(1L);
            throw e;
        }
    }

    private void authorizationCheck(Runnable runnable) {
        try {
            runnable.run();
            this.authorizationSuccess.update(1L);
        }
        catch (PrestoException e) {
            this.authorizationFail.update(1L);
            throw e;
        }
    }

    private static Map<String, String> loadProperties(File file) throws Exception {
        Objects.requireNonNull(file, "file is null");
        Properties properties = new Properties();
        try (FileInputStream in = new FileInputStream(file);){
            properties.load(in);
        }
        return Maps.fromProperties((Properties)properties);
    }

    private static class AllowAllSystemAccessControl
    implements SystemAccessControl {
        private AllowAllSystemAccessControl() {
        }

        public void checkCanSetUser(Principal principal, String userName) {
        }

        public void checkCanSetSystemSessionProperty(Identity identity, String propertyName) {
        }
    }

    private static class InitializingSystemAccessControl
    implements SystemAccessControl {
        private InitializingSystemAccessControl() {
        }

        public void checkCanSetUser(Principal principal, String userName) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.SERVER_STARTING_UP, "Presto server is still initializing");
        }

        public void checkCanSetSystemSessionProperty(Identity identity, String propertyName) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.SERVER_STARTING_UP, "Presto server is still initializing");
        }
    }
}

