/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlOperator;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.operator.scalar.RowEqualOperator;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;

public class RowNotEqualOperator
extends SqlOperator {
    public static final RowNotEqualOperator ROW_NOT_EQUAL = new RowNotEqualOperator();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(RowNotEqualOperator.class, "notEqual", Type.class, Block.class, Block.class);

    private RowNotEqualOperator() {
        super(OperatorType.NOT_EQUAL, (List<TypeParameter>)ImmutableList.of((Object)Signature.comparableWithVariadicBound("T", "row")), "boolean", (List<String>)ImmutableList.of((Object)"T", (Object)"T"));
    }

    @Override
    public ScalarFunctionImplementation specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type type = types.get("T");
        return new ScalarFunctionImplementation(false, (List<Boolean>)ImmutableList.of((Object)false, (Object)false), METHOD_HANDLE.bindTo(type), this.isDeterministic());
    }

    public static boolean notEqual(Type rowType, Block leftRow, Block rightRow) {
        return !RowEqualOperator.equals(rowType, leftRow, rightRow);
    }
}

