/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.operator.aggregation.TypedSet;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.InterleavedBlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;

public class MapConcatFunction
extends SqlScalarFunction {
    public static final MapConcatFunction MAP_CONCAT_FUNCTION = new MapConcatFunction();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(MapConcatFunction.class, "mapConcat", Type.class, Type.class, Block.class, Block.class);

    public MapConcatFunction() {
        super("map_concat", (List<TypeParameter>)ImmutableList.of((Object)Signature.typeParameter("K"), (Object)Signature.typeParameter("V")), "map<K,V>", (List<String>)ImmutableList.of((Object)"map<K,V>", (Object)"map<K,V>"));
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public String getDescription() {
        return "Concatenates given maps";
    }

    @Override
    public ScalarFunctionImplementation specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type kType = types.get("K");
        Type vType = types.get("V");
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(kType).bindTo(vType);
        return new ScalarFunctionImplementation(false, (List<Boolean>)ImmutableList.of((Object)false, (Object)false), methodHandle, this.isDeterministic());
    }

    public static Block mapConcat(Type keyType, Type valueType, Block leftMap, Block rightMap) {
        int i;
        TypedSet typedSet = new TypedSet(keyType, rightMap.getPositionCount());
        InterleavedBlockBuilder blockBuilder = new InterleavedBlockBuilder((List)ImmutableList.of((Object)keyType, (Object)valueType), new BlockBuilderStatus(), leftMap.getPositionCount() + rightMap.getPositionCount());
        for (i = 0; i < rightMap.getPositionCount(); i += 2) {
            typedSet.add(rightMap, i);
            keyType.appendTo(rightMap, i, (BlockBuilder)blockBuilder);
            valueType.appendTo(rightMap, i + 1, (BlockBuilder)blockBuilder);
        }
        for (i = 0; i < leftMap.getPositionCount(); i += 2) {
            if (typedSet.contains(leftMap, i)) continue;
            keyType.appendTo(leftMap, i, (BlockBuilder)blockBuilder);
            valueType.appendTo(leftMap, i + 1, (BlockBuilder)blockBuilder);
        }
        return blockBuilder.build();
    }
}

