/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.byteCode.Access;
import com.facebook.presto.byteCode.ByteCodeBlock;
import com.facebook.presto.byteCode.ClassDefinition;
import com.facebook.presto.byteCode.MethodDefinition;
import com.facebook.presto.byteCode.Parameter;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.Scope;
import com.facebook.presto.byteCode.Variable;
import com.facebook.presto.byteCode.expression.ByteCodeExpressions;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlOperator;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.sql.gen.ArrayGeneratorUtils;
import com.facebook.presto.sql.gen.ArrayMapByteCodeExpression;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.CompilerUtils;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;

public class ArrayToArrayCast
extends SqlOperator {
    public static final ArrayToArrayCast ARRAY_TO_ARRAY_CAST = new ArrayToArrayCast();

    private ArrayToArrayCast() {
        super(OperatorType.CAST, (List<TypeParameter>)ImmutableList.of((Object)Signature.typeParameter("F"), (Object)Signature.typeParameter("T")), "array<T>", (List<String>)ImmutableList.of((Object)"array<F>"));
    }

    @Override
    public ScalarFunctionImplementation specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Preconditions.checkArgument((arity == 1 ? 1 : 0) != 0, (Object)"Expected arity to be 1");
        Type fromType = types.get("F");
        Type toType = types.get("T");
        Signature signature = Signature.internalOperator(OperatorType.CAST.name(), toType.getTypeSignature(), (List<TypeSignature>)ImmutableList.of((Object)fromType.getTypeSignature()));
        ScalarFunctionImplementation function = functionRegistry.getScalarFunctionImplementation(signature);
        Class<?> castOperatorClass = ArrayToArrayCast.generateArrayCast(typeManager, signature, function);
        MethodHandle methodHandle = Reflection.methodHandle(castOperatorClass, "castArray", ConnectorSession.class, Block.class);
        return new ScalarFunctionImplementation(false, (List<Boolean>)ImmutableList.of((Object)false), methodHandle, this.isDeterministic());
    }

    private static Class<?> generateArrayCast(TypeManager typeManager, Signature elementCastSignature, ScalarFunctionImplementation elementCast) {
        CallSiteBinder binder = new CallSiteBinder();
        ClassDefinition definition = new ClassDefinition(Access.a(Access.PUBLIC, Access.FINAL), CompilerUtils.makeClassName(Joiner.on((String)"$").join((Object)"ArrayCast", (Object)elementCastSignature.getArgumentTypes().get(0), new Object[]{elementCastSignature.getReturnType()})), ParameterizedType.type(Object.class), new ParameterizedType[0]);
        definition.declareDefaultConstructor(Access.a(Access.PRIVATE));
        Parameter session = Parameter.arg("session", ConnectorSession.class);
        Parameter value = Parameter.arg("value", Block.class);
        MethodDefinition method = definition.declareMethod(Access.a(Access.PUBLIC, Access.STATIC), "castArray", ParameterizedType.type(Block.class), session, value);
        Scope scope = method.getScope();
        ByteCodeBlock body = method.getBody();
        Variable wasNull = scope.declareVariable(Boolean.TYPE, "wasNull");
        body.append(wasNull.set(ByteCodeExpressions.constantBoolean(false)));
        Type fromElementType = typeManager.getType(elementCastSignature.getArgumentTypes().get(0));
        Type toElementType = typeManager.getType(elementCastSignature.getReturnType());
        ArrayMapByteCodeExpression newArray = ArrayGeneratorUtils.map(scope, binder, fromElementType, toElementType, value, elementCastSignature.getName(), elementCast);
        body.append(newArray.ret());
        return CompilerUtils.defineClass(definition, Object.class, binder.getBindings(), ArrayToArrayCast.class.getClassLoader());
    }
}

