/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlOperator;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.operator.scalar.CombineHashFunction;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.type.TypeUtils;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;

public class ArrayHashCodeOperator
extends SqlOperator {
    public static final ArrayHashCodeOperator ARRAY_HASH_CODE = new ArrayHashCodeOperator();
    public static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(ArrayHashCodeOperator.class, "hash", Type.class, Block.class);

    private ArrayHashCodeOperator() {
        super(OperatorType.HASH_CODE, (List<TypeParameter>)ImmutableList.of((Object)Signature.comparableTypeParameter("T")), "bigint", (List<String>)ImmutableList.of((Object)"array<T>"));
    }

    @Override
    public ScalarFunctionImplementation specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type type = types.get("T");
        return new ScalarFunctionImplementation(false, (List<Boolean>)ImmutableList.of((Object)false), METHOD_HANDLE.bindTo(type), this.isDeterministic());
    }

    public static long hash(Type type, Block block) {
        int hash = 0;
        for (int i = 0; i < block.getPositionCount(); ++i) {
            TypeUtils.checkElementNotNull(block.isNull(i), "ARRAY comparison not supported for arrays with null elements");
            hash = (int)CombineHashFunction.getHash(hash, type.hash(block, i));
        }
        return hash;
    }
}

