/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;

public final class ArrayContains
extends SqlScalarFunction {
    public static final ArrayContains ARRAY_CONTAINS = new ArrayContains();
    private static final String FUNCTION_NAME = "contains";
    private static final MethodHandle METHOD_HANDLE_UNKNOWN = Reflection.methodHandle(ArrayContains.class, "arrayWithUnknownType", Type.class, MethodHandle.class, Block.class, Void.class);

    public ArrayContains() {
        super(FUNCTION_NAME, (List<TypeParameter>)ImmutableList.of((Object)Signature.comparableTypeParameter("T")), "boolean", (List<String>)ImmutableList.of((Object)"array<T>", (Object)"T"));
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public String getDescription() {
        return "Determines whether given value exists in the array";
    }

    @Override
    public ScalarFunctionImplementation specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        MethodHandle methodHandle;
        ImmutableList nullableArguments;
        Type type = types.get("T");
        MethodHandle equalsHandle = functionRegistry.getScalarFunctionImplementation(Signature.internalOperator(OperatorType.EQUAL, (Type)BooleanType.BOOLEAN, (List<? extends Type>)ImmutableList.of((Object)type, (Object)type))).getMethodHandle();
        if (type.getJavaType() == Void.TYPE) {
            nullableArguments = ImmutableList.of((Object)false, (Object)true);
            methodHandle = METHOD_HANDLE_UNKNOWN;
        } else {
            nullableArguments = ImmutableList.of((Object)false, (Object)false);
            methodHandle = Reflection.methodHandle(ArrayContains.class, FUNCTION_NAME, Type.class, MethodHandle.class, Block.class, type.getJavaType());
        }
        return new ScalarFunctionImplementation(true, (List<Boolean>)nullableArguments, methodHandle.bindTo(type).bindTo(equalsHandle), this.isDeterministic());
    }

    public static Boolean arrayWithUnknownType(Type elementType, MethodHandle equals, Block arrayBlock, Void value) {
        return null;
    }

    public static Boolean contains(Type elementType, MethodHandle equals, Block arrayBlock, Block value) {
        boolean foundNull = false;
        for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
            if (arrayBlock.isNull(i)) {
                foundNull = true;
                continue;
            }
            try {
                if (!equals.invokeExact((Block)elementType.getObject(arrayBlock, i), value)) continue;
                return true;
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, t);
            }
        }
        if (foundNull) {
            return null;
        }
        return false;
    }

    public static Boolean contains(Type elementType, MethodHandle equals, Block arrayBlock, Slice value) {
        boolean foundNull = false;
        for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
            if (arrayBlock.isNull(i)) {
                foundNull = true;
                continue;
            }
            try {
                if (!equals.invokeExact(elementType.getSlice(arrayBlock, i), value)) continue;
                return true;
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, t);
            }
        }
        if (foundNull) {
            return null;
        }
        return false;
    }

    public static Boolean contains(Type elementType, MethodHandle equals, Block arrayBlock, long value) {
        boolean foundNull = false;
        for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
            if (arrayBlock.isNull(i)) {
                foundNull = true;
                continue;
            }
            try {
                if (!equals.invokeExact(elementType.getLong(arrayBlock, i), value)) continue;
                return true;
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, t);
            }
        }
        if (foundNull) {
            return null;
        }
        return false;
    }

    public static Boolean contains(Type elementType, MethodHandle equals, Block arrayBlock, boolean value) {
        boolean foundNull = false;
        for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
            if (arrayBlock.isNull(i)) {
                foundNull = true;
                continue;
            }
            try {
                if (!equals.invokeExact(elementType.getBoolean(arrayBlock, i), value)) continue;
                return true;
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, t);
            }
        }
        if (foundNull) {
            return null;
        }
        return false;
    }

    public static Boolean contains(Type elementType, MethodHandle equals, Block arrayBlock, double value) {
        boolean foundNull = false;
        for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
            if (arrayBlock.isNull(i)) {
                foundNull = true;
                continue;
            }
            try {
                if (!equals.invokeExact(elementType.getDouble(arrayBlock, i), value)) continue;
                return true;
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, t);
            }
        }
        if (foundNull) {
            return null;
        }
        return false;
    }
}

