/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;

public final class ArrayCardinalityFunction
extends SqlScalarFunction {
    public static final ArrayCardinalityFunction ARRAY_CARDINALITY = new ArrayCardinalityFunction();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(ArrayCardinalityFunction.class, "arrayLength", Block.class);

    public ArrayCardinalityFunction() {
        super("cardinality", (List<TypeParameter>)ImmutableList.of((Object)Signature.typeParameter("E")), "bigint", (List<String>)ImmutableList.of((Object)"array<E>"));
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public String getDescription() {
        return "Returns the cardinality (length) of the array";
    }

    @Override
    public ScalarFunctionImplementation specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        return new ScalarFunctionImplementation(false, (List<Boolean>)ImmutableList.of((Object)false), METHOD_HANDLE, this.isDeterministic());
    }

    public static long arrayLength(Block block) {
        return block.getPositionCount();
    }
}

