/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.annotation.UsedByGeneratedCode;
import com.facebook.presto.byteCode.Access;
import com.facebook.presto.byteCode.ByteCodeBlock;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.ClassDefinition;
import com.facebook.presto.byteCode.DynamicClassLoader;
import com.facebook.presto.byteCode.MethodDefinition;
import com.facebook.presto.byteCode.Parameter;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.Scope;
import com.facebook.presto.byteCode.Variable;
import com.facebook.presto.byteCode.control.IfStatement;
import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.sql.gen.ByteCodeUtils;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.CompilerUtils;
import com.facebook.presto.util.ImmutableCollectors;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public abstract class AbstractGreatestLeast
extends SqlScalarFunction {
    private static final MethodHandle CHECK_NOT_NAN = Reflection.methodHandle(AbstractGreatestLeast.class, "checkNotNaN", String.class, Double.TYPE);
    private final OperatorType operatorType;

    protected AbstractGreatestLeast(String name, OperatorType operatorType) {
        super(name, (List<TypeParameter>)ImmutableList.of((Object)Signature.orderableTypeParameter("E")), "E", (List<String>)ImmutableList.of((Object)"E"), true);
        this.operatorType = Objects.requireNonNull(operatorType, "operatorType is null");
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public ScalarFunctionImplementation specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type type = types.get("E");
        Preconditions.checkArgument((boolean)type.isOrderable(), (Object)"Type must be orderable");
        MethodHandle compareMethod = functionRegistry.getScalarFunctionImplementation(Signature.internalOperator(this.operatorType, (Type)BooleanType.BOOLEAN, (List<? extends Type>)ImmutableList.of((Object)type, (Object)type))).getMethodHandle();
        List javaTypes = (List)IntStream.range(0, arity).mapToObj(i -> type.getJavaType()).collect(ImmutableCollectors.toImmutableList());
        Class<?> clazz = this.generate(javaTypes, type, compareMethod);
        MethodHandle methodHandle = Reflection.methodHandle(clazz, this.getSignature().getName(), javaTypes.toArray(new Class[javaTypes.size()]));
        ImmutableList nullableParameters = ImmutableList.copyOf(Collections.nCopies(javaTypes.size(), false));
        return new ScalarFunctionImplementation(false, (List<Boolean>)nullableParameters, methodHandle, this.isDeterministic());
    }

    @UsedByGeneratedCode
    public static void checkNotNaN(String name, double value) {
        if (Double.isNaN(value)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Invalid argument to %s(): NaN", name));
        }
    }

    private Class<?> generate(List<Class<?>> javaTypes, Type type, MethodHandle compareMethod) {
        String javaTypeName = javaTypes.stream().map(Class::getSimpleName).collect(Collectors.joining());
        ClassDefinition definition = new ClassDefinition(Access.a(Access.PUBLIC, Access.FINAL), CompilerUtils.makeClassName(javaTypeName + "$" + this.getSignature().getName()), ParameterizedType.type(Object.class), new ParameterizedType[0]);
        definition.declareDefaultConstructor(Access.a(Access.PRIVATE));
        List parameters = (List)IntStream.range(0, javaTypes.size()).mapToObj(i -> Parameter.arg("arg" + i, (Class)javaTypes.get(i))).collect(ImmutableCollectors.toImmutableList());
        MethodDefinition method = definition.declareMethod(Access.a(Access.PUBLIC, Access.STATIC), this.getSignature().getName(), ParameterizedType.type(javaTypes.get(0)), parameters);
        Scope scope = method.getScope();
        ByteCodeBlock body = method.getBody();
        CallSiteBinder binder = new CallSiteBinder();
        if (type.getTypeSignature().getBase().equals("double")) {
            for (Parameter parameter : parameters) {
                body.append(parameter);
                body.append(ByteCodeUtils.invoke(binder.bind(CHECK_NOT_NAN.bindTo(this.getSignature().getName())), "checkNotNaN"));
            }
        }
        Variable value = scope.declareVariable(javaTypes.get(0), "value");
        body.append(value.set((ByteCodeExpression)parameters.get(0)));
        for (int i2 = 1; i2 < javaTypes.size(); ++i2) {
            body.append(new IfStatement().condition(new ByteCodeBlock().append((ByteCodeNode)parameters.get(i2)).append(value).append(ByteCodeUtils.invoke(binder.bind(compareMethod), "compare"))).ifTrue(value.set((ByteCodeExpression)parameters.get(i2))));
        }
        body.append(value.ret());
        return CompilerUtils.defineClass(definition, Object.class, binder.getBindings(), new DynamicClassLoader(this.getClass().getClassLoader()));
    }
}

