/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.annotation.UsedByGeneratedCode;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;

public abstract class AbstractArrayMinMaxFunction
extends SqlScalarFunction {
    private final OperatorType operatorType;
    private final String description;
    private static final Map<Class<?>, MethodHandle> METHOD_HANDLES = ImmutableMap.builder().put(Boolean.TYPE, (Object)Reflection.methodHandle(AbstractArrayMinMaxFunction.class, "booleanArrayMinMax", MethodHandle.class, Type.class, Block.class)).put(Long.TYPE, (Object)Reflection.methodHandle(AbstractArrayMinMaxFunction.class, "longArrayMinMax", MethodHandle.class, Type.class, Block.class)).put(Double.TYPE, (Object)Reflection.methodHandle(AbstractArrayMinMaxFunction.class, "doubleArrayMinMax", MethodHandle.class, Type.class, Block.class)).put(Slice.class, (Object)Reflection.methodHandle(AbstractArrayMinMaxFunction.class, "sliceArrayMinMax", MethodHandle.class, Type.class, Block.class)).put(Void.TYPE, (Object)Reflection.methodHandle(AbstractArrayMinMaxFunction.class, "arrayWithUnknownType", MethodHandle.class, Type.class, Block.class)).build();
    private static final MethodHandle METHOD_HANDLE_OBJECT = Reflection.methodHandle(AbstractArrayMinMaxFunction.class, "objectArrayMinMax", MethodHandle.class, Type.class, Block.class);

    protected AbstractArrayMinMaxFunction(OperatorType operatorType, String functionName, String description) {
        super(functionName, (List<TypeParameter>)ImmutableList.of((Object)Signature.orderableTypeParameter("E")), "E", (List<String>)ImmutableList.of((Object)"array<E>"));
        this.operatorType = operatorType;
        this.description = description;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public ScalarFunctionImplementation specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Preconditions.checkArgument((types.size() == 1 ? 1 : 0) != 0, (String)"Expected one type, got %s", (Object[])new Object[]{types});
        Type elementType = types.get("E");
        Preconditions.checkArgument((boolean)elementType.isOrderable(), (Object)"Type must be orderable");
        MethodHandle compareMethodHandle = functionRegistry.getScalarFunctionImplementation(Signature.internalOperator(this.operatorType, (Type)BooleanType.BOOLEAN, (List<? extends Type>)ImmutableList.of((Object)elementType, (Object)elementType))).getMethodHandle();
        MethodHandle methodHandle = METHOD_HANDLES.get(elementType.getJavaType());
        if (methodHandle == null) {
            methodHandle = METHOD_HANDLE_OBJECT;
            compareMethodHandle = compareMethodHandle.asType(compareMethodHandle.type().changeParameterType(0, Object.class).changeParameterType(1, Object.class));
        }
        methodHandle = methodHandle.bindTo(compareMethodHandle).bindTo(elementType);
        return new ScalarFunctionImplementation(true, (List<Boolean>)ImmutableList.of((Object)false), methodHandle, this.isDeterministic());
    }

    @UsedByGeneratedCode
    public static void arrayWithUnknownType(MethodHandle compareMethodHandle, Type elementType, Block block) {
    }

    @UsedByGeneratedCode
    public static Long longArrayMinMax(MethodHandle compareMethodHandle, Type elementType, Block block) {
        try {
            if (block.getPositionCount() == 0) {
                return null;
            }
            long selectedValue = elementType.getLong(block, 0);
            for (int i = 0; i < block.getPositionCount(); ++i) {
                if (block.isNull(i)) {
                    return null;
                }
                long value = elementType.getLong(block, i);
                if (!compareMethodHandle.invokeExact(value, selectedValue)) continue;
                selectedValue = value;
            }
            return selectedValue;
        }
        catch (Throwable t) {
            Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
            Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, t);
        }
    }

    @UsedByGeneratedCode
    public static Boolean booleanArrayMinMax(MethodHandle compareMethodHandle, Type elementType, Block block) {
        try {
            if (block.getPositionCount() == 0) {
                return null;
            }
            boolean selectedValue = elementType.getBoolean(block, 0);
            for (int i = 0; i < block.getPositionCount(); ++i) {
                if (block.isNull(i)) {
                    return null;
                }
                boolean value = elementType.getBoolean(block, i);
                if (!compareMethodHandle.invokeExact(value, selectedValue)) continue;
                selectedValue = value;
            }
            return selectedValue;
        }
        catch (Throwable t) {
            Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
            Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, t);
        }
    }

    @UsedByGeneratedCode
    public static Double doubleArrayMinMax(MethodHandle compareMethodHandle, Type elementType, Block block) {
        try {
            if (block.getPositionCount() == 0) {
                return null;
            }
            double selectedValue = elementType.getDouble(block, 0);
            for (int i = 0; i < block.getPositionCount(); ++i) {
                if (block.isNull(i)) {
                    return null;
                }
                double value = elementType.getDouble(block, i);
                if (!compareMethodHandle.invokeExact(value, selectedValue)) continue;
                selectedValue = value;
            }
            return selectedValue;
        }
        catch (Throwable t) {
            Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
            Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, t);
        }
    }

    @UsedByGeneratedCode
    public static Slice sliceArrayMinMax(MethodHandle compareMethodHandle, Type elementType, Block block) {
        try {
            if (block.getPositionCount() == 0) {
                return null;
            }
            Slice selectedValue = elementType.getSlice(block, 0);
            for (int i = 0; i < block.getPositionCount(); ++i) {
                if (block.isNull(i)) {
                    return null;
                }
                Slice value = elementType.getSlice(block, i);
                if (!compareMethodHandle.invokeExact(value, selectedValue)) continue;
                selectedValue = value;
            }
            return selectedValue;
        }
        catch (Throwable t) {
            Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
            Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, t);
        }
    }

    @UsedByGeneratedCode
    public static Object objectArrayMinMax(MethodHandle compareMethodHandle, Type elementType, Block block) {
        try {
            if (block.getPositionCount() == 0) {
                return null;
            }
            Object selectedValue = elementType.getObject(block, 0);
            for (int i = 0; i < block.getPositionCount(); ++i) {
                if (block.isNull(i)) {
                    return null;
                }
                Object value = elementType.getObject(block, i);
                if (!compareMethodHandle.invokeExact(value, selectedValue)) continue;
                selectedValue = value;
            }
            return selectedValue;
        }
        catch (Throwable t) {
            Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
            Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, t);
        }
    }
}

