/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.operator.aggregation.state.AbstractGroupedAccumulatorState;
import com.facebook.presto.operator.aggregation.state.AccumulatorStateFactory;
import com.facebook.presto.operator.aggregation.state.ArrayAggregationState;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.util.array.ObjectBigArray;
import java.util.Objects;

public class ArrayAggregationStateFactory
implements AccumulatorStateFactory<ArrayAggregationState> {
    @Override
    public ArrayAggregationState createSingleState() {
        return new SingleArrayAggregationState();
    }

    @Override
    public Class<? extends ArrayAggregationState> getSingleStateClass() {
        return SingleArrayAggregationState.class;
    }

    @Override
    public ArrayAggregationState createGroupedState() {
        return new GroupedArrayAggregationState();
    }

    @Override
    public Class<? extends ArrayAggregationState> getGroupedStateClass() {
        return GroupedArrayAggregationState.class;
    }

    public static class SingleArrayAggregationState
    implements ArrayAggregationState {
        private BlockBuilder blockBuilder;

        @Override
        public long getEstimatedSize() {
            if (this.blockBuilder == null) {
                return 0L;
            }
            return this.blockBuilder.getRetainedSizeInBytes();
        }

        @Override
        public BlockBuilder getBlockBuilder() {
            return this.blockBuilder;
        }

        @Override
        public void setBlockBuilder(BlockBuilder value) {
            Objects.requireNonNull(value, "value is null");
            this.blockBuilder = value;
        }

        @Override
        public void addMemoryUsage(long memory) {
        }
    }

    public static class GroupedArrayAggregationState
    extends AbstractGroupedAccumulatorState
    implements ArrayAggregationState {
        private final ObjectBigArray<BlockBuilder> blockBuilders = new ObjectBigArray();
        private long size;

        @Override
        public void ensureCapacity(long size) {
            this.blockBuilders.ensureCapacity(size);
        }

        @Override
        public long getEstimatedSize() {
            return this.size + this.blockBuilders.sizeOf();
        }

        @Override
        public void addMemoryUsage(long memory) {
            this.size += memory;
        }

        @Override
        public BlockBuilder getBlockBuilder() {
            return this.blockBuilders.get(this.getGroupId());
        }

        @Override
        public void setBlockBuilder(BlockBuilder value) {
            Objects.requireNonNull(value, "value is null");
            BlockBuilder previous = this.getBlockBuilder();
            if (previous != null) {
                this.size -= (long)previous.getRetainedSizeInBytes();
            }
            this.blockBuilders.set(this.getGroupId(), value);
            this.size += (long)value.getRetainedSizeInBytes();
        }
    }
}

