/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.byteCode.DynamicClassLoader;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlAggregationFunction;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.operator.aggregation.AccumulatorCompiler;
import com.facebook.presto.operator.aggregation.AggregationMetadata;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.GenericAccumulatorFactoryBinder;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.state.ArrayAggregationState;
import com.facebook.presto.operator.aggregation.state.ArrayAggregationStateFactory;
import com.facebook.presto.operator.aggregation.state.ArrayAggregationStateSerializer;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.type.ArrayType;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;

public class ArrayAggregationFunction
extends SqlAggregationFunction {
    public static final ArrayAggregationFunction ARRAY_AGGREGATION = new ArrayAggregationFunction();
    private static final String NAME = "array_agg";
    private static final MethodHandle INPUT_FUNCTION = Reflection.methodHandle(ArrayAggregationFunction.class, "input", Type.class, ArrayAggregationState.class, Block.class, Integer.TYPE);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(ArrayAggregationFunction.class, "combine", Type.class, ArrayAggregationState.class, ArrayAggregationState.class);
    private static final MethodHandle OUTPUT_FUNCTION = Reflection.methodHandle(ArrayAggregationFunction.class, "output", Type.class, ArrayAggregationState.class, BlockBuilder.class);

    public ArrayAggregationFunction() {
        super(NAME, (List<TypeParameter>)ImmutableList.of((Object)Signature.typeParameter("T")), "array<T>", (List<String>)ImmutableList.of((Object)"T"));
    }

    @Override
    public String getDescription() {
        return "return an array of values";
    }

    @Override
    public InternalAggregationFunction specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type type = types.get("T");
        return ArrayAggregationFunction.generateAggregation(type);
    }

    private static InternalAggregationFunction generateAggregation(Type type) {
        DynamicClassLoader classLoader = new DynamicClassLoader(ArrayAggregationFunction.class.getClassLoader());
        ArrayAggregationStateSerializer stateSerializer = new ArrayAggregationStateSerializer(type);
        ArrayAggregationStateFactory stateFactory = new ArrayAggregationStateFactory();
        ImmutableList inputTypes = ImmutableList.of((Object)type);
        ArrayType outputType = new ArrayType(type);
        Type intermediateType = stateSerializer.getSerializedType();
        List<AggregationMetadata.ParameterMetadata> inputParameterMetadata = ArrayAggregationFunction.createInputParameterMetadata(type);
        MethodHandle inputFunction = INPUT_FUNCTION.bindTo(type);
        MethodHandle combineFunction = COMBINE_FUNCTION.bindTo(type);
        MethodHandle outputFunction = OUTPUT_FUNCTION.bindTo((Object)outputType);
        Class<ArrayAggregationState> stateInterface = ArrayAggregationState.class;
        AggregationMetadata metadata = new AggregationMetadata(AggregationUtils.generateAggregationName(NAME, type, (List<Type>)inputTypes), inputParameterMetadata, inputFunction, null, null, combineFunction, outputFunction, stateInterface, stateSerializer, stateFactory, (Type)outputType, false);
        GenericAccumulatorFactoryBinder factory = new AccumulatorCompiler().generateAccumulatorFactoryBinder(metadata, classLoader);
        return new InternalAggregationFunction(NAME, (List<Type>)inputTypes, intermediateType, (Type)outputType, true, false, factory);
    }

    private static List<AggregationMetadata.ParameterMetadata> createInputParameterMetadata(Type value) {
        return ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INPUT_CHANNEL, value), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INDEX));
    }

    public static void input(Type type, ArrayAggregationState state, Block value, int position) {
        BlockBuilder blockBuilder = state.getBlockBuilder();
        if (blockBuilder == null) {
            blockBuilder = type.createBlockBuilder(new BlockBuilderStatus(), 100);
            state.setBlockBuilder(blockBuilder);
        }
        long startSize = blockBuilder.getRetainedSizeInBytes();
        type.appendTo(value, position, blockBuilder);
        state.addMemoryUsage((long)blockBuilder.getRetainedSizeInBytes() - startSize);
    }

    public static void combine(Type type, ArrayAggregationState state, ArrayAggregationState otherState) {
        BlockBuilder stateBlockBuilder = state.getBlockBuilder();
        BlockBuilder otherStateBlockBuilder = otherState.getBlockBuilder();
        if (otherStateBlockBuilder == null) {
            return;
        }
        if (stateBlockBuilder == null) {
            state.setBlockBuilder(otherStateBlockBuilder);
            return;
        }
        int otherPositionCount = otherStateBlockBuilder.getPositionCount();
        long startSize = stateBlockBuilder.getRetainedSizeInBytes();
        for (int i = 0; i < otherPositionCount; ++i) {
            type.appendTo((Block)otherStateBlockBuilder, i, stateBlockBuilder);
        }
        state.addMemoryUsage((long)stateBlockBuilder.getRetainedSizeInBytes() - startSize);
    }

    public static void output(Type outputType, ArrayAggregationState state, BlockBuilder out) {
        BlockBuilder stateBlockBuilder = state.getBlockBuilder();
        if (stateBlockBuilder == null || stateBlockBuilder.getPositionCount() == 0) {
            out.appendNull();
        } else {
            outputType.writeObject(out, (Object)stateBlockBuilder.build());
        }
    }
}

