/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.byteCode.DynamicClassLoader;
import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.operator.aggregation.AggregationMetadata;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.CombineFunction;
import com.facebook.presto.operator.aggregation.InputFunction;
import com.facebook.presto.operator.aggregation.IntermediateInputFunction;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.LazyAccumulatorFactoryBinder;
import com.facebook.presto.operator.aggregation.OutputFunction;
import com.facebook.presto.operator.aggregation.state.AccumulatorState;
import com.facebook.presto.operator.aggregation.state.AccumulatorStateFactory;
import com.facebook.presto.operator.aggregation.state.AccumulatorStateSerializer;
import com.facebook.presto.operator.aggregation.state.StateCompiler;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.type.SqlType;
import com.facebook.presto.type.TypeRegistry;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class AggregationCompiler {
    private final TypeManager typeManager;

    public AggregationCompiler() {
        this(new TypeRegistry());
    }

    public AggregationCompiler(TypeManager typeManager) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    private static List<Method> findPublicStaticMethodsWithAnnotation(Class<?> clazz, Class<?> annotationClass) {
        ImmutableList.Builder methods = ImmutableList.builder();
        for (Method method : clazz.getMethods()) {
            for (Annotation annotation : method.getAnnotations()) {
                if (!annotationClass.isInstance(annotation)) continue;
                Preconditions.checkArgument((Modifier.isStatic(method.getModifiers()) && Modifier.isPublic(method.getModifiers()) ? 1 : 0) != 0, (String)"%s annotated with %s must be static and public", (Object[])new Object[]{method.getName(), annotationClass.getSimpleName()});
                methods.add((Object)method);
            }
        }
        return methods.build();
    }

    public InternalAggregationFunction generateAggregationFunction(Class<?> clazz) {
        List<InternalAggregationFunction> aggregations = this.generateAggregationFunctions(clazz);
        Preconditions.checkArgument((aggregations.size() == 1 ? 1 : 0) != 0, (Object)"More than one aggregation function found");
        return aggregations.get(0);
    }

    public InternalAggregationFunction generateAggregationFunction(Class<?> clazz, Type returnType, List<Type> argumentTypes) {
        Objects.requireNonNull(returnType, "returnType is null");
        Objects.requireNonNull(argumentTypes, "argumentTypes is null");
        for (InternalAggregationFunction aggregation : this.generateAggregationFunctions(clazz)) {
            if (!aggregation.getFinalType().equals(returnType) || !aggregation.getParameterTypes().equals(argumentTypes)) continue;
            return aggregation;
        }
        throw new IllegalArgumentException(String.format("No method with return type %s and arguments %s", returnType, argumentTypes));
    }

    public List<InternalAggregationFunction> generateAggregationFunctions(Class<?> clazz) {
        AggregationFunction aggregationAnnotation = clazz.getAnnotation(AggregationFunction.class);
        Objects.requireNonNull(aggregationAnnotation, "aggregationAnnotation is null");
        DynamicClassLoader classLoader = new DynamicClassLoader(clazz.getClassLoader());
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Class<?> stateClass : AggregationCompiler.getStateClasses(clazz)) {
            AccumulatorStateSerializer<?> stateSerializer = new StateCompiler().generateStateSerializer(stateClass, classLoader);
            Type intermediateType = stateSerializer.getSerializedType();
            Method intermediateInputFunction = AggregationCompiler.getIntermediateInputFunction(clazz, stateClass);
            Method combineFunction = AggregationCompiler.getCombineFunction(clazz, stateClass);
            AccumulatorStateFactory<?> stateFactory = new StateCompiler().generateStateFactory(stateClass, classLoader);
            for (Method outputFunction : AggregationCompiler.getOutputFunctions(clazz, stateClass)) {
                for (Method inputFunction : AggregationCompiler.getInputFunctions(clazz, stateClass)) {
                    for (String name : AggregationCompiler.getNames(outputFunction, aggregationAnnotation)) {
                        AggregationMetadata metadata;
                        List<Type> inputTypes = this.getInputTypes(inputFunction);
                        Type outputType = AggregationUtils.getOutputType(outputFunction, stateSerializer, this.typeManager);
                        try {
                            MethodHandle inputHandle = MethodHandles.lookup().unreflect(inputFunction);
                            MethodHandle intermediateInputHandle = intermediateInputFunction == null ? null : MethodHandles.lookup().unreflect(intermediateInputFunction);
                            MethodHandle combineHandle = combineFunction == null ? null : MethodHandles.lookup().unreflect(combineFunction);
                            MethodHandle outputHandle = outputFunction == null ? null : MethodHandles.lookup().unreflect(outputFunction);
                            metadata = new AggregationMetadata(AggregationUtils.generateAggregationName(name, outputType, inputTypes), this.getParameterMetadata(inputFunction, aggregationAnnotation.approximate()), inputHandle, this.getParameterMetadata(intermediateInputFunction, false), intermediateInputHandle, combineHandle, outputHandle, stateClass, stateSerializer, stateFactory, outputType, aggregationAnnotation.approximate());
                        }
                        catch (IllegalAccessException e) {
                            throw Throwables.propagate((Throwable)e);
                        }
                        LazyAccumulatorFactoryBinder factory = new LazyAccumulatorFactoryBinder(metadata, classLoader);
                        builder.add((Object)new InternalAggregationFunction(name, inputTypes, intermediateType, outputType, aggregationAnnotation.decomposable(), aggregationAnnotation.approximate(), factory));
                    }
                }
            }
        }
        return builder.build();
    }

    private List<AggregationMetadata.ParameterMetadata> getParameterMetadata(@Nullable Method method, boolean sampleWeightAllowed) {
        if (method == null) {
            return null;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE));
        Annotation[][] annotations = method.getParameterAnnotations();
        for (int i = 1; i < annotations.length; ++i) {
            builder.add((Object)AggregationMetadata.ParameterMetadata.fromAnnotations(annotations[i], method.getDeclaringClass() + "." + method.getName(), this.typeManager, sampleWeightAllowed));
        }
        return builder.build();
    }

    private static List<String> getNames(@Nullable Method outputFunction, AggregationFunction aggregationAnnotation) {
        ImmutableList defaultNames = ImmutableList.builder().add((Object)aggregationAnnotation.value()).addAll(Arrays.asList(aggregationAnnotation.alias())).build();
        if (outputFunction == null) {
            return defaultNames;
        }
        AggregationFunction annotation = outputFunction.getAnnotation(AggregationFunction.class);
        if (annotation == null) {
            return defaultNames;
        }
        return ImmutableList.builder().add((Object)annotation.value()).addAll(Arrays.asList(annotation.alias())).build();
    }

    private static Method getIntermediateInputFunction(Class<?> clazz, Class<?> stateClass) {
        for (Method method : AggregationCompiler.findPublicStaticMethodsWithAnnotation(clazz, IntermediateInputFunction.class)) {
            if (method.getParameterTypes()[0] != stateClass) continue;
            return method;
        }
        return null;
    }

    private static Method getCombineFunction(Class<?> clazz, Class<?> stateClass) {
        for (Method method : AggregationCompiler.findPublicStaticMethodsWithAnnotation(clazz, CombineFunction.class)) {
            if (method.getParameterTypes()[0] != stateClass) continue;
            return method;
        }
        return null;
    }

    private static List<Method> getOutputFunctions(Class<?> clazz, Class<?> stateClass) {
        List methods = (List)AggregationCompiler.findPublicStaticMethodsWithAnnotation(clazz, OutputFunction.class).stream().filter(method -> method.getParameterTypes()[0] == stateClass).collect(ImmutableCollectors.toImmutableList());
        Preconditions.checkArgument((!methods.isEmpty() ? 1 : 0) != 0, (Object)"Aggregation has no output functions");
        return methods;
    }

    private static List<Method> getInputFunctions(Class<?> clazz, Class<?> stateClass) {
        List inputFunctions = (List)AggregationCompiler.findPublicStaticMethodsWithAnnotation(clazz, InputFunction.class).stream().filter(method -> method.getParameterTypes()[0] == stateClass).collect(ImmutableCollectors.toImmutableList());
        Preconditions.checkArgument((!inputFunctions.isEmpty() ? 1 : 0) != 0, (Object)"Aggregation has no input functions");
        return inputFunctions;
    }

    private List<Type> getInputTypes(Method inputFunction) {
        Annotation[][] parameterAnnotations;
        ImmutableList.Builder builder = ImmutableList.builder();
        Annotation[][] annotationArray = parameterAnnotations = inputFunction.getParameterAnnotations();
        int n = annotationArray.length;
        for (int i = 0; i < n; ++i) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = annotationArray[i]) {
                if (!(annotation instanceof SqlType)) continue;
                String typeName = ((SqlType)annotation).value();
                builder.add((Object)this.typeManager.getType(TypeSignature.parseTypeSignature((String)typeName)));
            }
        }
        return builder.build();
    }

    private static Set<Class<?>> getStateClasses(Class<?> clazz) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Method inputFunction : AggregationCompiler.findPublicStaticMethodsWithAnnotation(clazz, InputFunction.class)) {
            Preconditions.checkArgument((inputFunction.getParameterTypes().length > 0 ? 1 : 0) != 0, (Object)"Input function has no parameters");
            Class<?> stateClass = inputFunction.getParameterTypes()[0];
            Preconditions.checkArgument((boolean)AccumulatorState.class.isAssignableFrom(stateClass), (Object)"stateClass is not a subclass of AccumulatorState");
            builder.add(stateClass);
        }
        ImmutableSet stateClasses = builder.build();
        Preconditions.checkArgument((!stateClasses.isEmpty() ? 1 : 0) != 0, (Object)"No input functions found");
        return stateClasses;
    }
}

