/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.execution.SharedBuffer;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.OutputFactory;
import com.facebook.presto.operator.PartitionFunction;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;

public class PartitionedOutputOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final ListenableFuture<PagePartitioner> partitionFunction;
    private ListenableFuture<?> blocked = NOT_BLOCKED;
    private boolean finished;

    public PartitionedOutputOperator(OperatorContext operatorContext, List<Type> sourceTypes, PartitionFunction partitionFunction, List<Integer> partitionChannels, OptionalInt nullChannel, SharedBuffer sharedBuffer) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.partitionFunction = Futures.immediateFuture((Object)new PagePartitioner(partitionFunction, partitionChannels, nullChannel, sharedBuffer, sourceTypes));
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return ImmutableList.of();
    }

    @Override
    public void finish() {
        this.finished = true;
        this.blocked = ((PagePartitioner)Futures.getUnchecked(this.partitionFunction)).flush(true);
    }

    @Override
    public boolean isFinished() {
        return this.finished && this.isBlocked().isDone();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        if (!this.partitionFunction.isDone()) {
            return this.partitionFunction;
        }
        if (this.blocked != NOT_BLOCKED && this.blocked.isDone()) {
            this.blocked = NOT_BLOCKED;
        }
        return this.blocked;
    }

    @Override
    public boolean needsInput() {
        return !this.finished && this.isBlocked().isDone();
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((boolean)this.isBlocked().isDone(), (Object)"output is already blocked");
        if (page.getPositionCount() == 0) {
            return;
        }
        this.blocked = ((PagePartitioner)Futures.getUnchecked(this.partitionFunction)).partitionPage(page);
        this.operatorContext.recordGeneratedOutput(page.getSizeInBytes(), page.getPositionCount());
    }

    @Override
    public Page getOutput() {
        return null;
    }

    private static class PagePartitioner {
        private final SharedBuffer sharedBuffer;
        private final List<Type> sourceTypes;
        private final PartitionFunction partitionFunction;
        private final List<Integer> partitionChannels;
        private final List<PageBuilder> pageBuilders;
        private final OptionalInt nullChannel;

        public PagePartitioner(PartitionFunction partitionFunction, List<Integer> partitionChannels, OptionalInt nullChannel, SharedBuffer sharedBuffer, List<Type> sourceTypes) {
            this.partitionFunction = Objects.requireNonNull(partitionFunction, "partitionFunction is null");
            this.partitionChannels = Objects.requireNonNull(partitionChannels, "partitionChannels is null");
            this.nullChannel = Objects.requireNonNull(nullChannel, "nullChannel is null");
            this.sharedBuffer = Objects.requireNonNull(sharedBuffer, "sharedBuffer is null");
            this.sourceTypes = Objects.requireNonNull(sourceTypes, "sourceTypes is null");
            ImmutableList.Builder pageBuilders = ImmutableList.builder();
            for (int i = 0; i < partitionFunction.getPartitionCount(); ++i) {
                pageBuilders.add((Object)new PageBuilder(sourceTypes));
            }
            this.pageBuilders = pageBuilders.build();
        }

        public ListenableFuture<?> partitionPage(Page page) {
            Objects.requireNonNull(page, "page is null");
            Page partitionFunctionArgs = this.getPartitionFunctionArguments(page);
            for (int position = 0; position < page.getPositionCount(); ++position) {
                Type type;
                int channel;
                PageBuilder pageBuilder2;
                if (this.nullChannel.isPresent() && page.getBlock(this.nullChannel.getAsInt()).isNull(position)) {
                    for (PageBuilder pageBuilder2 : this.pageBuilders) {
                        pageBuilder2.declarePosition();
                        for (channel = 0; channel < this.sourceTypes.size(); ++channel) {
                            type = this.sourceTypes.get(channel);
                            type.appendTo(page.getBlock(channel), position, pageBuilder2.getBlockBuilder(channel));
                        }
                    }
                    continue;
                }
                int partition = this.partitionFunction.getPartition(partitionFunctionArgs, position);
                pageBuilder2 = this.pageBuilders.get(partition);
                pageBuilder2.declarePosition();
                for (channel = 0; channel < this.sourceTypes.size(); ++channel) {
                    type = this.sourceTypes.get(channel);
                    type.appendTo(page.getBlock(channel), position, pageBuilder2.getBlockBuilder(channel));
                }
            }
            return this.flush(false);
        }

        private Page getPartitionFunctionArguments(Page page) {
            Block[] blocks = new Block[this.partitionChannels.size()];
            for (int i = 0; i < blocks.length; ++i) {
                blocks[i] = page.getBlock(this.partitionChannels.get(i).intValue());
            }
            return new Page(page.getPositionCount(), blocks);
        }

        public ListenableFuture<?> flush(boolean force) {
            ArrayList blockedFutures = new ArrayList();
            for (int partition = 0; partition < this.pageBuilders.size(); ++partition) {
                PageBuilder partitionPageBuilder = this.pageBuilders.get(partition);
                if (partitionPageBuilder.isEmpty() || !force && !partitionPageBuilder.isFull()) continue;
                Page pagePartition = partitionPageBuilder.build();
                partitionPageBuilder.reset();
                blockedFutures.add(this.sharedBuffer.enqueue(partition, pagePartition));
            }
            ListenableFuture future = Futures.allAsList(blockedFutures);
            if (future.isDone()) {
                return Operator.NOT_BLOCKED;
            }
            return future;
        }
    }

    public static class PartitionedOutputOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final List<Type> sourceTypes;
        private final PartitionFunction partitionFunction;
        private final List<Integer> partitionChannels;
        private final OptionalInt nullChannel;
        private final SharedBuffer sharedBuffer;

        public PartitionedOutputOperatorFactory(int operatorId, List<Type> sourceTypes, PartitionFunction partitionFunction, List<Integer> partitionChannels, OptionalInt nullChannel, SharedBuffer sharedBuffer) {
            this.operatorId = operatorId;
            this.sourceTypes = Objects.requireNonNull(sourceTypes, "sourceTypes is null");
            this.partitionFunction = Objects.requireNonNull(partitionFunction, "partitionFunction is null");
            this.partitionChannels = Objects.requireNonNull(partitionChannels, "partitionChannels is null");
            this.nullChannel = Objects.requireNonNull(nullChannel, "nullChannel is null");
            this.sharedBuffer = Objects.requireNonNull(sharedBuffer, "sharedBuffer is null");
        }

        @Override
        public List<Type> getTypes() {
            return ImmutableList.of();
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, PartitionedOutputOperator.class.getSimpleName());
            return new PartitionedOutputOperator(operatorContext, this.sourceTypes, this.partitionFunction, this.partitionChannels, this.nullChannel, this.sharedBuffer);
        }

        @Override
        public void close() {
        }

        @Override
        public OperatorFactory duplicate() {
            return new PartitionedOutputOperatorFactory(this.operatorId, this.sourceTypes, this.partitionFunction, this.partitionChannels, this.nullChannel, this.sharedBuffer);
        }
    }

    public static class PartitionedOutputFactory
    implements OutputFactory {
        private final PartitionFunction partitionFunction;
        private final List<Integer> partitionChannels;
        private final SharedBuffer sharedBuffer;
        private final OptionalInt nullChannel;

        public PartitionedOutputFactory(PartitionFunction partitionFunction, List<Integer> partitionChannels, OptionalInt nullChannel, SharedBuffer sharedBuffer) {
            this.partitionFunction = Objects.requireNonNull(partitionFunction, "partitionFunction is null");
            this.partitionChannels = Objects.requireNonNull(partitionChannels, "partitionChannels is null");
            this.nullChannel = Objects.requireNonNull(nullChannel, "nullChannel is null");
            this.sharedBuffer = Objects.requireNonNull(sharedBuffer, "sharedBuffer is null");
        }

        @Override
        public OperatorFactory createOutputOperator(int operatorId, List<Type> sourceTypes) {
            return new PartitionedOutputOperatorFactory(operatorId, sourceTypes, this.partitionFunction, this.partitionChannels, this.nullChannel, this.sharedBuffer);
        }
    }
}

