/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class OrderByOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final List<Integer> sortChannels;
    private final List<SortOrder> sortOrder;
    private final int[] outputChannels;
    private final List<Type> types;
    private final PagesIndex pageIndex;
    private final PageBuilder pageBuilder;
    private int currentPosition;
    private State state = State.NEEDS_INPUT;

    public OrderByOperator(OperatorContext operatorContext, List<Type> sourceTypes, List<Integer> outputChannels, int expectedPositions, List<Integer> sortChannels, List<SortOrder> sortOrder) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.outputChannels = Ints.toArray((Collection)Objects.requireNonNull(outputChannels, "outputChannels is null"));
        this.types = OrderByOperator.toTypes(sourceTypes, outputChannels);
        this.sortChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortChannels, "sortChannels is null"));
        this.sortOrder = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortOrder, "sortOrder is null"));
        this.pageIndex = new PagesIndex(sourceTypes, expectedPositions);
        this.pageBuilder = new PageBuilder(this.types);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public void finish() {
        if (this.state == State.NEEDS_INPUT) {
            this.state = State.HAS_OUTPUT;
            this.pageIndex.sort(this.sortChannels, this.sortOrder);
        }
    }

    @Override
    public boolean isFinished() {
        return this.state == State.FINISHED;
    }

    @Override
    public boolean needsInput() {
        return this.state == State.NEEDS_INPUT;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((this.state == State.NEEDS_INPUT ? 1 : 0) != 0, (Object)"Operator is already finishing");
        Objects.requireNonNull(page, "page is null");
        this.pageIndex.addPage(page);
        this.operatorContext.setMemoryReservation(this.pageIndex.getEstimatedSize().toBytes());
    }

    @Override
    public Page getOutput() {
        if (this.state != State.HAS_OUTPUT) {
            return null;
        }
        if (this.currentPosition >= this.pageIndex.getPositionCount()) {
            this.state = State.FINISHED;
            return null;
        }
        this.pageBuilder.reset();
        this.currentPosition = this.pageIndex.buildPage(this.currentPosition, this.outputChannels, this.pageBuilder);
        if (this.pageBuilder.isEmpty()) {
            this.state = State.FINISHED;
            return null;
        }
        Page page = this.pageBuilder.build();
        return page;
    }

    private static List<Type> toTypes(List<? extends Type> sourceTypes, List<Integer> outputChannels) {
        ImmutableList.Builder types = ImmutableList.builder();
        for (int channel : outputChannels) {
            types.add((Object)sourceTypes.get(channel));
        }
        return types.build();
    }

    private static enum State {
        NEEDS_INPUT,
        HAS_OUTPUT,
        FINISHED;

    }

    public static class OrderByOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final List<Type> sourceTypes;
        private final List<Integer> outputChannels;
        private final int expectedPositions;
        private final List<Integer> sortChannels;
        private final List<SortOrder> sortOrder;
        private final List<Type> types;
        private boolean closed;

        public OrderByOperatorFactory(int operatorId, List<? extends Type> sourceTypes, List<Integer> outputChannels, int expectedPositions, List<Integer> sortChannels, List<SortOrder> sortOrder) {
            this.operatorId = operatorId;
            this.sourceTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(sourceTypes, "sourceTypes is null"));
            this.outputChannels = Objects.requireNonNull(outputChannels, "outputChannels is null");
            this.expectedPositions = expectedPositions;
            this.sortChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortChannels, "sortChannels is null"));
            this.sortOrder = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortOrder, "sortOrder is null"));
            this.types = OrderByOperator.toTypes(sourceTypes, outputChannels);
        }

        @Override
        public List<Type> getTypes() {
            return this.types;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, OrderByOperator.class.getSimpleName());
            return new OrderByOperator(operatorContext, this.sourceTypes, this.outputChannels, this.expectedPositions, this.sortChannels, this.sortOrder);
        }

        @Override
        public void close() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new OrderByOperatorFactory(this.operatorId, this.sourceTypes, this.outputChannels, this.expectedPositions, this.sortChannels, this.sortOrder);
        }
    }
}

