/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.NestedLoopJoinPagesBuilder;
import com.facebook.presto.operator.NestedLoopJoinPagesSupplier;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;

public class NestedLoopBuildOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final NestedLoopJoinPagesSupplier nestedLoopJoinPagesSupplier;
    private final NestedLoopJoinPagesBuilder nestedLoopJoinPagesBuilder;
    private boolean finished;

    public NestedLoopBuildOperator(OperatorContext operatorContext, NestedLoopJoinPagesSupplier nestedLoopJoinPagesSupplier) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.nestedLoopJoinPagesSupplier = Objects.requireNonNull(nestedLoopJoinPagesSupplier, "nestedLoopJoinPagesSupplier is null");
        this.nestedLoopJoinPagesBuilder = new NestedLoopJoinPagesBuilder(operatorContext);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return this.nestedLoopJoinPagesSupplier.getTypes();
    }

    @Override
    public void finish() {
        if (this.finished) {
            return;
        }
        this.nestedLoopJoinPagesSupplier.setPages(this.nestedLoopJoinPagesBuilder.build());
        this.finished = true;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public boolean needsInput() {
        return !this.finished;
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((!this.isFinished() ? 1 : 0) != 0, (Object)"Operator is already finished");
        if (page.getPositionCount() == 0) {
            return;
        }
        this.nestedLoopJoinPagesBuilder.addPage(page);
        if (!this.operatorContext.trySetMemoryReservation(this.nestedLoopJoinPagesBuilder.getEstimatedSize().toBytes())) {
            this.nestedLoopJoinPagesBuilder.compact();
        }
        this.operatorContext.setMemoryReservation(this.nestedLoopJoinPagesBuilder.getEstimatedSize().toBytes());
        this.operatorContext.recordGeneratedOutput(page.getSizeInBytes(), page.getPositionCount());
    }

    @Override
    public Page getOutput() {
        return null;
    }

    public static class NestedLoopBuildOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final NestedLoopJoinPagesSupplier nestedLoopJoinPagesSupplier;
        private boolean closed;

        public NestedLoopBuildOperatorFactory(int operatorId, List<Type> types) {
            this.operatorId = operatorId;
            this.nestedLoopJoinPagesSupplier = new NestedLoopJoinPagesSupplier(Objects.requireNonNull(types, "types is null"));
            this.nestedLoopJoinPagesSupplier.retain();
        }

        public NestedLoopJoinPagesSupplier getNestedLoopJoinPagesSupplier() {
            return this.nestedLoopJoinPagesSupplier;
        }

        @Override
        public List<Type> getTypes() {
            return this.nestedLoopJoinPagesSupplier.getTypes();
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, NestedLoopBuildOperator.class.getSimpleName());
            return new NestedLoopBuildOperator(operatorContext, this.nestedLoopJoinPagesSupplier);
        }

        @Override
        public void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.nestedLoopJoinPagesSupplier.release();
        }

        @Override
        public OperatorFactory duplicate() {
            return new NestedLoopBuildOperatorFactory(this.operatorId, this.getTypes());
        }
    }
}

