/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.LookupSourceSupplier;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.SharedLookupSource;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.util.Types;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.concurrent.MoreFutures;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;

public class LookupOuterOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final ListenableFuture<OuterPositionIterator> outerPositionsFuture;
    private final List<Type> types;
    private final List<Type> probeTypes;
    private final PageBuilder pageBuilder;
    private OuterPositionIterator outerPositions;

    public LookupOuterOperator(OperatorContext operatorContext, OuterLookupSourceSupplier lookupSourceSupplier, List<Type> probeTypes) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        Objects.requireNonNull(lookupSourceSupplier, "lookupSourceSupplier is null");
        this.outerPositionsFuture = lookupSourceSupplier.getOuterPositions(operatorContext);
        this.types = ImmutableList.builder().addAll(probeTypes).addAll(lookupSourceSupplier.getTypes()).build();
        this.probeTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(probeTypes, "probeTypes is null"));
        this.pageBuilder = new PageBuilder(this.types);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.outerPositionsFuture;
    }

    @Override
    public void finish() {
    }

    @Override
    public boolean isFinished() {
        return this.outerPositions != null && !this.outerPositions.hasNext() && this.pageBuilder.isEmpty();
    }

    @Override
    public boolean needsInput() {
        return false;
    }

    @Override
    public void addInput(Page page) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Page getOutput() {
        if (this.outerPositions == null) {
            this.outerPositions = MoreFutures.tryGetFutureValue(this.outerPositionsFuture).orElse(null);
            if (this.outerPositions == null) {
                return null;
            }
        }
        while (!this.pageBuilder.isFull() && this.outerPositions.hasNext()) {
            long buildSideOuterJoinPosition = this.outerPositions.next();
            this.pageBuilder.declarePosition();
            for (int probeChannel = 0; probeChannel < this.probeTypes.size(); ++probeChannel) {
                this.pageBuilder.getBlockBuilder(probeChannel).appendNull();
            }
            this.outerPositions.appendTo(buildSideOuterJoinPosition, this.pageBuilder, this.probeTypes.size());
        }
        if (this.pageBuilder.isFull() || !this.outerPositions.hasNext() && !this.pageBuilder.isEmpty()) {
            Page page = this.pageBuilder.build();
            this.pageBuilder.reset();
            return page;
        }
        return null;
    }

    @Override
    public void close() {
        Futures.addCallback(this.outerPositionsFuture, (FutureCallback)new FutureCallback<OuterPositionIterator>(){

            public void onSuccess(OuterPositionIterator outerPositions) {
                outerPositions.close();
            }

            public void onFailure(Throwable t) {
            }
        });
        this.pageBuilder.reset();
    }

    private static class OuterPositionIterator {
        private final SharedLookupSource lookupSource;
        private final boolean[] visitedPositions;
        private int currentPosition;
        private boolean closed;

        public OuterPositionIterator(SharedLookupSource lookupSource, boolean[] visitedPositions) {
            this.lookupSource = Objects.requireNonNull(lookupSource, "lookupSource is null");
            this.visitedPositions = Objects.requireNonNull(visitedPositions, "visitedPositions is null");
        }

        public boolean hasNext() {
            while (this.currentPosition < this.visitedPositions.length) {
                if (!this.visitedPositions[this.currentPosition]) {
                    return true;
                }
                ++this.currentPosition;
            }
            return false;
        }

        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int result = this.currentPosition++;
            return result;
        }

        public void appendTo(long position, PageBuilder pageBuilder, int outputChannelOffset) {
            this.lookupSource.appendTo(position, pageBuilder, outputChannelOffset);
        }

        public void close() {
            if (!this.closed) {
                this.closed = true;
                this.lookupSource.freeMemory();
            }
        }
    }

    private static class OuterPositionTracker {
        private final SharedLookupSource lookupSource;
        private final boolean[] visitedPositions;
        private boolean closed;

        public OuterPositionTracker(SharedLookupSource lookupSource) {
            this.lookupSource = Objects.requireNonNull(lookupSource, "lookupSource is null");
            this.visitedPositions = new boolean[lookupSource.getJoinPositionCount()];
        }

        public SharedLookupSource getLookupSource() {
            return this.lookupSource;
        }

        public synchronized void visit(int position) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Position tracker is closed");
            this.visitedPositions[position] = true;
        }

        public synchronized OuterPositionIterator getOuterPositions() {
            this.closed = true;
            return new OuterPositionIterator(this.lookupSource, this.visitedPositions);
        }
    }

    private static class OuterLookupSource
    implements LookupSource {
        private final OuterPositionTracker positionTracker;
        private final LookupSource lookupSource;

        public OuterLookupSource(OuterPositionTracker positionTracker) {
            this.positionTracker = positionTracker;
            this.lookupSource = positionTracker.getLookupSource();
        }

        @Override
        public void appendTo(long position, PageBuilder pageBuilder, int outputChannelOffset) {
            this.lookupSource.appendTo(position, pageBuilder, outputChannelOffset);
            this.positionTracker.visit(Ints.checkedCast((long)position));
        }

        @Override
        public int getChannelCount() {
            return this.lookupSource.getChannelCount();
        }

        @Override
        public int getJoinPositionCount() {
            return this.lookupSource.getJoinPositionCount();
        }

        @Override
        public long getJoinPosition(int position, Page page) {
            return this.lookupSource.getJoinPosition(position, page);
        }

        @Override
        public long getInMemorySizeInBytes() {
            return this.lookupSource.getInMemorySizeInBytes();
        }

        @Override
        public long getNextJoinPosition(long currentPosition) {
            return this.lookupSource.getNextJoinPosition(currentPosition);
        }

        @Override
        public long getJoinPosition(int position, Page page, int rawHash) {
            return this.lookupSource.getJoinPosition(position, page, rawHash);
        }

        @Override
        public void close() {
            this.lookupSource.close();
        }
    }

    public static class OuterLookupSourceSupplier
    implements LookupSourceSupplier {
        private final LookupSourceSupplier lookupSourceSupplier;
        private final AtomicInteger referenceCount = new AtomicInteger(1);
        private final SettableFuture<OuterPositionIterator> outerPositionsFuture = SettableFuture.create();
        @GuardedBy(value="this")
        private ListenableFuture<LookupSource> outerLookupFuture;
        @GuardedBy(value="this")
        private OuterPositionTracker positionTracker;

        public OuterLookupSourceSupplier(LookupSourceSupplier lookupSourceSupplier) {
            this.lookupSourceSupplier = Objects.requireNonNull(lookupSourceSupplier, "lookupSourceSupplier is null");
        }

        @Override
        public List<Type> getTypes() {
            return this.lookupSourceSupplier.getTypes();
        }

        @Override
        public ListenableFuture<LookupSource> getLookupSource(OperatorContext operatorContext) {
            return Futures.transform(this.lookupSourceSupplier.getLookupSource(operatorContext), input -> new OuterLookupSource(this.getPositionTracker((LookupSource)input)));
        }

        public synchronized SettableFuture<OuterPositionIterator> getOuterPositions(OperatorContext operatorContext) {
            Preconditions.checkState((this.outerLookupFuture == null ? 1 : 0) != 0, (Object)"Outer positions can only be fetched once");
            this.outerLookupFuture = this.getLookupSource(operatorContext);
            this.updateOuterPositionState();
            return this.outerPositionsFuture;
        }

        private synchronized OuterPositionTracker getPositionTracker(LookupSource lookupSource) {
            if (this.positionTracker == null) {
                this.positionTracker = new OuterPositionTracker(Types.checkType(lookupSource, SharedLookupSource.class, "lookupSource"));
            }
            return this.positionTracker;
        }

        @Override
        public void retain() {
            this.referenceCount.incrementAndGet();
        }

        @Override
        public void release() {
            if (this.referenceCount.decrementAndGet() == 0) {
                this.updateOuterPositionState();
            }
        }

        private synchronized void updateOuterPositionState() {
            if (this.referenceCount.get() != 0 || this.outerLookupFuture == null) {
                return;
            }
            Futures.addCallback(this.outerLookupFuture, (FutureCallback)new FutureCallback<LookupSource>(){

                public void onSuccess(LookupSource result) {
                    outerPositionsFuture.set((Object)this.getPositionTracker(result).getOuterPositions());
                }

                public void onFailure(Throwable t) {
                    outerPositionsFuture.setException(t);
                }
            });
        }
    }

    public static class LookupOuterOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final OuterLookupSourceSupplier lookupSourceSupplier;
        private final List<Type> probeTypes;
        private final List<Type> types;
        private boolean closed;

        public LookupOuterOperatorFactory(int operatorId, OuterLookupSourceSupplier lookupSourceSupplier, List<Type> probeTypes) {
            this.operatorId = operatorId;
            this.lookupSourceSupplier = Objects.requireNonNull(lookupSourceSupplier, "lookupSourceSupplier is null");
            this.probeTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(probeTypes, "probeTypes is null"));
            this.types = ImmutableList.builder().addAll(probeTypes).addAll(lookupSourceSupplier.getTypes()).build();
        }

        public int getOperatorId() {
            return this.operatorId;
        }

        @Override
        public List<Type> getTypes() {
            return this.types;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, LookupOuterOperator.class.getSimpleName());
            return new LookupOuterOperator(operatorContext, this.lookupSourceSupplier, this.probeTypes);
        }

        @Override
        public void close() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new LookupOuterOperatorFactory(this.operatorId, this.lookupSourceSupplier, this.probeTypes);
        }
    }
}

