/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.JoinOperatorFactory;
import com.facebook.presto.operator.JoinProbeFactory;
import com.facebook.presto.operator.LookupJoinOperator;
import com.facebook.presto.operator.LookupJoinOperators;
import com.facebook.presto.operator.LookupOuterOperator;
import com.facebook.presto.operator.LookupSourceSupplier;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;

public class LookupJoinOperatorFactory
implements JoinOperatorFactory {
    private final int operatorId;
    private final LookupSourceSupplier lookupSourceSupplier;
    private final List<Type> probeTypes;
    private final LookupJoinOperators.JoinType joinType;
    private final List<Type> types;
    private final JoinProbeFactory joinProbeFactory;
    private boolean closed;

    public LookupJoinOperatorFactory(int operatorId, LookupSourceSupplier lookupSourceSupplier, List<Type> probeTypes, LookupJoinOperators.JoinType joinType, JoinProbeFactory joinProbeFactory) {
        this.operatorId = operatorId;
        this.lookupSourceSupplier = lookupSourceSupplier;
        this.probeTypes = probeTypes;
        this.joinType = joinType;
        this.joinProbeFactory = joinProbeFactory;
        this.types = ImmutableList.builder().addAll(probeTypes).addAll(lookupSourceSupplier.getTypes()).build();
    }

    public int getOperatorId() {
        return this.operatorId;
    }

    public List<Type> getProbeTypes() {
        return this.probeTypes;
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public Operator createOperator(DriverContext driverContext) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
        OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, LookupJoinOperator.class.getSimpleName());
        return new LookupJoinOperator(operatorContext, this.lookupSourceSupplier, this.probeTypes, this.joinType, this.joinProbeFactory);
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.lookupSourceSupplier.release();
    }

    @Override
    public OperatorFactory duplicate() {
        return new LookupJoinOperatorFactory(this.operatorId, this.lookupSourceSupplier, this.probeTypes, this.joinType, this.joinProbeFactory);
    }

    @Override
    public Optional<OperatorFactory> createOuterOperatorFactory() {
        if (this.lookupSourceSupplier instanceof LookupOuterOperator.OuterLookupSourceSupplier) {
            return Optional.of(new LookupOuterOperator.LookupOuterOperatorFactory(this.operatorId, (LookupOuterOperator.OuterLookupSourceSupplier)this.lookupSourceSupplier, this.probeTypes));
        }
        return Optional.empty();
    }
}

