/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlFunction;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class SqlScalarFunction
implements SqlFunction {
    private final Signature signature;

    public static SqlScalarFunction create(Signature signature, String description, boolean hidden, MethodHandle methodHandle, boolean deterministic, boolean nullable, List<Boolean> nullableArguments) {
        return new SimpleSqlScalarFunction(signature, description, hidden, methodHandle, deterministic, nullable, nullableArguments);
    }

    protected SqlScalarFunction(String name, List<TypeParameter> typeParameters, String returnType, List<String> argumentTypes) {
        this(name, typeParameters, returnType, argumentTypes, false);
    }

    protected SqlScalarFunction(String name, List<TypeParameter> typeParameters, String returnType, List<String> argumentTypes, boolean variableArity) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(typeParameters, "typeParameters is null");
        Objects.requireNonNull(returnType, "returnType is null");
        Objects.requireNonNull(argumentTypes, "argumentTypes is null");
        this.signature = new Signature(name, FunctionKind.SCALAR, (List<TypeParameter>)ImmutableList.copyOf(typeParameters), returnType, (List<String>)ImmutableList.copyOf(argumentTypes), variableArity);
    }

    @Override
    public final Signature getSignature() {
        return this.signature;
    }

    public abstract ScalarFunctionImplementation specialize(Map<String, Type> var1, int var2, TypeManager var3, FunctionRegistry var4);

    private static class SimpleSqlScalarFunction
    extends SqlScalarFunction {
        private final MethodHandle methodHandle;
        private final String description;
        private final boolean hidden;
        private final boolean nullable;
        private final List<Boolean> nullableArguments;
        private final boolean deterministic;

        public SimpleSqlScalarFunction(Signature signature, String description, boolean hidden, MethodHandle methodHandle, boolean deterministic, boolean nullable, List<Boolean> nullableArguments) {
            super(signature.getName(), (List<TypeParameter>)ImmutableList.of(), signature.getReturnType().toString(), (List)signature.getArgumentTypes().stream().map(TypeSignature::toString).collect(ImmutableCollectors.toImmutableList()));
            Preconditions.checkArgument((boolean)signature.getTypeParameters().isEmpty(), (String)"%s is parametric", (Object[])new Object[]{signature});
            this.description = description;
            this.hidden = hidden;
            this.methodHandle = Objects.requireNonNull(methodHandle, "methodHandle is null");
            this.deterministic = deterministic;
            this.nullable = nullable;
            this.nullableArguments = Objects.requireNonNull(nullableArguments, "nullableArguments is null");
        }

        @Override
        public boolean isHidden() {
            return this.hidden;
        }

        @Override
        public boolean isDeterministic() {
            return this.deterministic;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public ScalarFunctionImplementation specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
            return new ScalarFunctionImplementation(this.nullable, this.nullableArguments, this.methodHandle, this.isDeterministic());
        }
    }
}

