/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class SqlOperator
extends SqlScalarFunction {
    public static SqlOperator create(OperatorType operatorType, List<TypeSignature> argumentTypes, TypeSignature returnType, MethodHandle methodHandle, boolean nullable, List<Boolean> nullableArguments) {
        return new SimpleSqlOperator(operatorType, argumentTypes, returnType, methodHandle, nullable, nullableArguments);
    }

    protected SqlOperator(OperatorType operatorType, List<TypeParameter> typeParameters, String returnType, List<String> argumentTypes) {
        super(FunctionRegistry.mangleOperatorName(operatorType), typeParameters, returnType, argumentTypes);
    }

    @Override
    public final boolean isHidden() {
        return true;
    }

    @Override
    public final boolean isDeterministic() {
        return true;
    }

    @Override
    public final String getDescription() {
        return null;
    }

    public static class SimpleSqlOperator
    extends SqlOperator {
        private final MethodHandle methodHandle;
        private final boolean nullable;
        private final List<Boolean> nullableArguments;

        public SimpleSqlOperator(OperatorType operatorType, List<TypeSignature> argumentTypes, TypeSignature returnType, MethodHandle methodHandle, boolean nullable, List<Boolean> nullableArguments) {
            super(operatorType, (List<TypeParameter>)ImmutableList.of(), returnType.toString(), (List<String>)((List)argumentTypes.stream().map(TypeSignature::toString).collect(ImmutableCollectors.toImmutableList())));
            this.methodHandle = Objects.requireNonNull(methodHandle, "methodHandle is null");
            this.nullable = nullable;
            this.nullableArguments = ImmutableList.copyOf((Collection)Objects.requireNonNull(nullableArguments, "nullableArguments is null"));
        }

        @Override
        public ScalarFunctionImplementation specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
            return new ScalarFunctionImplementation(this.nullable, this.nullableArguments, this.methodHandle, this.isDeterministic());
        }
    }
}

