/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeUtils;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.type.ArrayType;
import com.facebook.presto.type.MapType;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;

public final class SessionPropertyManager {
    private static final JsonCodecFactory JSON_CODEC_FACTORY = new JsonCodecFactory();
    private final ConcurrentMap<String, SessionProperty<?>> allSessionProperties = new ConcurrentHashMap();
    private final ConcurrentMap<String, List<PropertyMetadata<?>>> catalogSessionProperties = new ConcurrentHashMap();

    public SessionPropertyManager() {
        this(new SystemSessionProperties());
    }

    @Inject
    public SessionPropertyManager(SystemSessionProperties systemSessionProperties) {
        this(systemSessionProperties.getSessionProperties());
    }

    public SessionPropertyManager(List<PropertyMetadata<?>> systemSessionProperties) {
        this.addSystemSessionProperties(systemSessionProperties);
    }

    public void addSystemSessionProperties(List<PropertyMetadata<?>> systemSessionProperties) {
        systemSessionProperties.forEach(this::addSystemSessionProperty);
    }

    public void addSystemSessionProperty(PropertyMetadata<?> sessionProperty) {
        Objects.requireNonNull(sessionProperty, "sessionProperty is null");
        this.addSessionPropertyInternal(Optional.empty(), sessionProperty);
    }

    public void addConnectorSessionProperties(String catalog, List<PropertyMetadata<?>> sessionProperties) {
        Objects.requireNonNull(catalog, "catalog is null");
        Preconditions.checkArgument((!catalog.isEmpty() && catalog.trim().toLowerCase(Locale.ENGLISH).equals(catalog) ? 1 : 0) != 0, (String)"Invalid catalog name '%s'", (Object[])new Object[]{catalog});
        Objects.requireNonNull(sessionProperties, "sessionProperties is null");
        Preconditions.checkState((this.catalogSessionProperties.putIfAbsent(catalog, sessionProperties) == null ? 1 : 0) != 0, (String)"SessionProperties for catalog '%s' are already registered", (Object[])new Object[]{catalog});
        for (PropertyMetadata<?> sessionProperty : sessionProperties) {
            this.addSessionPropertyInternal(Optional.of(catalog), sessionProperty);
        }
    }

    private <T> void addSessionPropertyInternal(Optional<String> catalogName, PropertyMetadata<T> sessionProperty) {
        SessionProperty value = new SessionProperty(catalogName, sessionProperty);
        this.allSessionProperties.put(value.getFullyQualifiedName(), value);
    }

    public PropertyMetadata<?> getSessionPropertyMetadata(String name) {
        Objects.requireNonNull(name, "name is null");
        SessionProperty sessionProperty = (SessionProperty)this.allSessionProperties.get(name);
        if (sessionProperty == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "Unknown session property " + name);
        }
        return sessionProperty.getMetadata();
    }

    public List<SessionPropertyValue> getAllSessionProperties(Session session) {
        Objects.requireNonNull(session, "session is null");
        ArrayList<SessionPropertyValue> properties = new ArrayList<SessionPropertyValue>();
        for (SessionProperty sessionProperty : this.allSessionProperties.values()) {
            PropertyMetadata propertyMetadata = sessionProperty.getMetadata();
            String defaultValue = MoreObjects.firstNonNull((Object)propertyMetadata.getDefaultValue(), (Object)"").toString();
            Map<String, String> values = sessionProperty.getCatalogName().isPresent() ? session.getCatalogProperties(sessionProperty.getCatalogName().get()) : session.getSystemProperties();
            String value = values.getOrDefault(sessionProperty.getPropertyName(), defaultValue);
            properties.add(new SessionPropertyValue(value, defaultValue, sessionProperty.getFullyQualifiedName(), sessionProperty.getCatalogName(), sessionProperty.getPropertyName(), propertyMetadata.getDescription(), propertyMetadata.getSqlType().getTypeSignature().toString(), propertyMetadata.isHidden()));
        }
        Collections.sort(properties, (left, right) -> ComparisonChain.start().compare(left.getCatalogName().orElse(null), right.getCatalogName().orElse(null), (Comparator)Ordering.natural().nullsFirst()).compare((Comparable)((Object)left.getPropertyName()), (Comparable)((Object)right.getPropertyName())).result());
        return ImmutableList.copyOf(properties);
    }

    public <T> T decodeProperty(String name, @Nullable String value, Class<T> type) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(type, "type is null");
        SessionProperty sessionProperty = (SessionProperty)this.allSessionProperties.get(name);
        if (sessionProperty == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "Unknown session property " + name);
        }
        PropertyMetadata metadata = sessionProperty.getMetadata();
        if (metadata.getJavaType() != type) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("Property %s is type %s, but requested type was %s", name, metadata.getJavaType().getName(), type.getName()));
        }
        if (value == null) {
            return type.cast(metadata.getDefaultValue());
        }
        Object objectValue = SessionPropertyManager.deserializeSessionProperty(metadata.getSqlType(), value);
        try {
            return type.cast(metadata.decode(objectValue));
        }
        catch (PrestoException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s is invalid: %s", name, value), (Throwable)e);
        }
    }

    @NotNull
    public static Object evaluatePropertyValue(Expression expression, Type expectedType, Session session, Metadata metadata) {
        Object value = ExpressionInterpreter.evaluateConstantExpression(expression, expectedType, metadata, session, (Set<Expression>)ImmutableSet.of());
        BlockBuilder blockBuilder = expectedType.createBlockBuilder(new BlockBuilderStatus(), 1);
        TypeUtils.writeNativeValue((Type)expectedType, (BlockBuilder)blockBuilder, (Object)value);
        Object objectValue = expectedType.getObjectValue(session.toConnectorSession(), (Block)blockBuilder, 0);
        if (objectValue == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "Session property value must not be null");
        }
        return objectValue;
    }

    @NotNull
    public static String serializeSessionProperty(Type type, Object value) {
        if (value == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "Session property can not be null");
        }
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return value.toString();
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return value.toString();
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return value.toString();
        }
        if (VarcharType.VARCHAR.equals((Object)type)) {
            return value.toString();
        }
        if (type instanceof ArrayType || type instanceof MapType) {
            return SessionPropertyManager.getJsonCodecForType(type).toJson(value);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("Session property type %s is not supported", type));
    }

    @NotNull
    private static Object deserializeSessionProperty(Type type, String value) {
        if (value == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "Session property can not be null");
        }
        if (VarcharType.VARCHAR.equals((Object)type)) {
            return value;
        }
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return Boolean.valueOf(value);
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return Long.valueOf(value);
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return Double.valueOf(value);
        }
        if (type instanceof ArrayType || type instanceof MapType) {
            return SessionPropertyManager.getJsonCodecForType(type).fromJson(value);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("Session property type %s is not supported", type));
    }

    private static <T> JsonCodec<T> getJsonCodecForType(Type type) {
        if (VarcharType.VARCHAR.equals((Object)type)) {
            return JSON_CODEC_FACTORY.jsonCodec(String.class);
        }
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return JSON_CODEC_FACTORY.jsonCodec(Boolean.class);
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return JSON_CODEC_FACTORY.jsonCodec(Long.class);
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return JSON_CODEC_FACTORY.jsonCodec(Double.class);
        }
        if (type instanceof ArrayType) {
            Type elementType = ((ArrayType)type).getElementType();
            return JSON_CODEC_FACTORY.listJsonCodec(SessionPropertyManager.getJsonCodecForType(elementType));
        }
        if (type instanceof MapType) {
            Type keyType = ((MapType)type).getKeyType();
            Type valueType = ((MapType)type).getValueType();
            return JSON_CODEC_FACTORY.mapJsonCodec(SessionPropertyManager.getMapKeyType(keyType), SessionPropertyManager.getJsonCodecForType(valueType));
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("Session property type %s is not supported", type));
    }

    private static Class<?> getMapKeyType(Type type) {
        if (VarcharType.VARCHAR.equals((Object)type)) {
            return String.class;
        }
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return Boolean.class;
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return Long.class;
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return Double.class;
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("Session property map key type %s is not supported", type));
    }

    private final class SessionProperty<T> {
        private final Optional<String> catalogName;
        private final PropertyMetadata<T> propertyMetadata;
        private final String propertyName;

        private SessionProperty(Optional<String> catalogName, PropertyMetadata<T> propertyMetadata) {
            this.catalogName = catalogName;
            this.propertyName = propertyMetadata.getName();
            String fullName = propertyMetadata.getName();
            if (catalogName.isPresent()) {
                fullName = catalogName.get() + "." + fullName;
            }
            this.propertyMetadata = new PropertyMetadata(fullName, propertyMetadata.getDescription(), propertyMetadata.getSqlType(), propertyMetadata.getJavaType(), propertyMetadata.getDefaultValue(), propertyMetadata.isHidden(), arg_0 -> propertyMetadata.decode(arg_0));
        }

        public String getFullyQualifiedName() {
            return this.propertyMetadata.getName();
        }

        public Optional<String> getCatalogName() {
            return this.catalogName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public PropertyMetadata<T> getMetadata() {
            return this.propertyMetadata;
        }
    }

    public static class SessionPropertyValue {
        private final String fullyQualifiedName;
        private final Optional<String> catalogName;
        private final String propertyName;
        private final String description;
        private final String type;
        private final String value;
        private final String defaultValue;
        private final boolean hidden;

        private SessionPropertyValue(String value, String defaultValue, String fullyQualifiedName, Optional<String> catalogName, String propertyName, String description, String type, boolean hidden) {
            this.fullyQualifiedName = fullyQualifiedName;
            this.catalogName = catalogName;
            this.propertyName = propertyName;
            this.description = description;
            this.type = type;
            this.value = value;
            this.defaultValue = defaultValue;
            this.hidden = hidden;
        }

        public String getFullyQualifiedName() {
            return this.fullyQualifiedName;
        }

        public Optional<String> getCatalogName() {
            return this.catalogName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String getDescription() {
            return this.description;
        }

        public String getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public boolean isHidden() {
            return this.hidden;
        }
    }
}

