/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.Session;
import com.facebook.presto.block.BlockEncodingManager;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.InsertTableHandle;
import com.facebook.presto.metadata.LegacyTableLayoutHandle;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.OutputTableHandle;
import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.metadata.QualifiedTablePrefix;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.metadata.SqlFunction;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.metadata.TableLayout;
import com.facebook.presto.metadata.TableLayoutHandle;
import com.facebook.presto.metadata.TableLayoutResult;
import com.facebook.presto.metadata.TableMetadata;
import com.facebook.presto.metadata.TablePropertyManager;
import com.facebook.presto.metadata.ViewDefinition;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorMetadata;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorPartition;
import com.facebook.presto.spi.ConnectorPartitionResult;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ConnectorViewDefinition;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.BlockEncodingFactory;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.split.SplitManager;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.type.TypeDeserializer;
import com.facebook.presto.type.TypeRegistry;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.slice.Slice;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Provider;

public class MetadataManager
implements Metadata {
    private static final String INFORMATION_SCHEMA_NAME = "information_schema";
    private final ConcurrentMap<String, ConnectorMetadataEntry> informationSchemasByCatalog = new ConcurrentHashMap<String, ConnectorMetadataEntry>();
    private final ConcurrentMap<String, ConnectorMetadataEntry> systemTablesByCatalog = new ConcurrentHashMap<String, ConnectorMetadataEntry>();
    private final ConcurrentMap<String, ConnectorMetadataEntry> connectorsByCatalog = new ConcurrentHashMap<String, ConnectorMetadataEntry>();
    private final ConcurrentMap<String, ConnectorMetadataEntry> connectorsById = new ConcurrentHashMap<String, ConnectorMetadataEntry>();
    private final FunctionRegistry functions;
    private final TypeManager typeManager;
    private final JsonCodec<ViewDefinition> viewCodec;
    private final SplitManager splitManager;
    private final BlockEncodingSerde blockEncodingSerde;
    private final SessionPropertyManager sessionPropertyManager;
    private final TablePropertyManager tablePropertyManager;

    public MetadataManager(FeaturesConfig featuresConfig, TypeManager typeManager, SplitManager splitManager, BlockEncodingSerde blockEncodingSerde, SessionPropertyManager sessionPropertyManager, TablePropertyManager tablePropertyManager) {
        this(featuresConfig, typeManager, MetadataManager.createTestingViewCodec(), splitManager, blockEncodingSerde, sessionPropertyManager, tablePropertyManager);
    }

    @Inject
    public MetadataManager(FeaturesConfig featuresConfig, TypeManager typeManager, JsonCodec<ViewDefinition> viewCodec, SplitManager splitManager, BlockEncodingSerde blockEncodingSerde, SessionPropertyManager sessionPropertyManager, TablePropertyManager tablePropertyManager) {
        this.functions = new FunctionRegistry(typeManager, blockEncodingSerde, featuresConfig.isExperimentalSyntaxEnabled());
        this.typeManager = Objects.requireNonNull(typeManager, "types is null");
        this.viewCodec = Objects.requireNonNull(viewCodec, "viewCodec is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
        this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
        this.tablePropertyManager = Objects.requireNonNull(tablePropertyManager, "tablePropertyManager is null");
        this.verifyComparableOrderableContract();
    }

    public static MetadataManager createTestMetadataManager() {
        FeaturesConfig featuresConfig = new FeaturesConfig();
        TypeRegistry typeManager = new TypeRegistry();
        SessionPropertyManager sessionPropertyManager = new SessionPropertyManager();
        SplitManager splitManager = new SplitManager();
        BlockEncodingManager blockEncodingSerde = new BlockEncodingManager((TypeManager)typeManager, new BlockEncodingFactory[0]);
        return new MetadataManager(featuresConfig, typeManager, splitManager, blockEncodingSerde, sessionPropertyManager, new TablePropertyManager());
    }

    public synchronized void addConnectorMetadata(String connectorId, String catalogName, ConnectorMetadata connectorMetadata) {
        this.checkMetadataArguments(connectorId, catalogName, connectorMetadata);
        Preconditions.checkArgument((!this.connectorsByCatalog.containsKey(catalogName) ? 1 : 0) != 0, (String)"Catalog '%s' is already registered", (Object[])new Object[]{catalogName});
        ConnectorMetadataEntry connectorMetadataEntry = new ConnectorMetadataEntry(connectorId, catalogName, connectorMetadata);
        this.connectorsById.put(connectorId, connectorMetadataEntry);
        this.connectorsByCatalog.put(catalogName, connectorMetadataEntry);
    }

    public synchronized void addInformationSchemaMetadata(String connectorId, String catalogName, ConnectorMetadata metadata) {
        this.checkMetadataArguments(connectorId, catalogName, metadata);
        Preconditions.checkArgument((!this.informationSchemasByCatalog.containsKey(catalogName) ? 1 : 0) != 0, (String)"Information schema for catalog '%s' is already registered", (Object[])new Object[]{catalogName});
        ConnectorMetadataEntry connectorMetadataEntry = new ConnectorMetadataEntry(connectorId, catalogName, metadata);
        this.connectorsById.put(connectorId, connectorMetadataEntry);
        this.informationSchemasByCatalog.put(catalogName, connectorMetadataEntry);
    }

    public synchronized void addSystemTablesMetadata(String connectorId, String catalogName, ConnectorMetadata metadata) {
        this.checkMetadataArguments(connectorId, catalogName, metadata);
        Preconditions.checkArgument((!this.systemTablesByCatalog.containsKey(catalogName) ? 1 : 0) != 0, (String)"System tables for catalog '%s' are already registered", (Object[])new Object[]{catalogName});
        ConnectorMetadataEntry connectorMetadataEntry = new ConnectorMetadataEntry(connectorId, catalogName, metadata);
        this.connectorsById.put(connectorId, connectorMetadataEntry);
        this.systemTablesByCatalog.put(catalogName, connectorMetadataEntry);
    }

    private void checkMetadataArguments(String connectorId, String catalogName, ConnectorMetadata metadata) {
        Objects.requireNonNull(connectorId, "connectorId is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(metadata, "metadata is null");
        Preconditions.checkArgument((!this.connectorsById.containsKey(connectorId) ? 1 : 0) != 0, (String)"Connector '%s' is already registered", (Object[])new Object[]{connectorId});
    }

    @Override
    public final void verifyComparableOrderableContract() {
        HashMultimap missingOperators = HashMultimap.create();
        for (Type type : this.typeManager.getTypes()) {
            if (type.isComparable()) {
                if (!this.functions.canResolveOperator(OperatorType.HASH_CODE, (Type)BigintType.BIGINT, (List<? extends Type>)ImmutableList.of((Object)type))) {
                    missingOperators.put((Object)type, (Object)OperatorType.HASH_CODE);
                }
                if (!this.functions.canResolveOperator(OperatorType.EQUAL, (Type)BooleanType.BOOLEAN, (List<? extends Type>)ImmutableList.of((Object)type, (Object)type))) {
                    missingOperators.put((Object)type, (Object)OperatorType.EQUAL);
                }
                if (!this.functions.canResolveOperator(OperatorType.NOT_EQUAL, (Type)BooleanType.BOOLEAN, (List<? extends Type>)ImmutableList.of((Object)type, (Object)type))) {
                    missingOperators.put((Object)type, (Object)OperatorType.NOT_EQUAL);
                }
            }
            if (!type.isOrderable()) continue;
            for (OperatorType operator : ImmutableList.of((Object)((Object)OperatorType.LESS_THAN), (Object)((Object)OperatorType.LESS_THAN_OR_EQUAL), (Object)((Object)OperatorType.GREATER_THAN), (Object)((Object)OperatorType.GREATER_THAN_OR_EQUAL))) {
                if (this.functions.canResolveOperator(operator, (Type)BooleanType.BOOLEAN, (List<? extends Type>)ImmutableList.of((Object)type, (Object)type))) continue;
                missingOperators.put((Object)type, (Object)operator);
            }
            if (this.functions.canResolveOperator(OperatorType.BETWEEN, (Type)BooleanType.BOOLEAN, (List<? extends Type>)ImmutableList.of((Object)type, (Object)type, (Object)type))) continue;
            missingOperators.put((Object)type, (Object)OperatorType.BETWEEN);
        }
        if (!missingOperators.isEmpty()) {
            ArrayList<String> messages = new ArrayList<String>();
            for (Type type : missingOperators.keySet()) {
                messages.add(String.format("%s missing for %s", missingOperators.get((Object)type), type));
            }
            throw new IllegalStateException(Joiner.on((String)", ").join(messages));
        }
    }

    @Override
    public Type getType(TypeSignature signature) {
        return this.typeManager.getType(signature);
    }

    @Override
    public boolean isAggregationFunction(QualifiedName name) {
        return this.functions.isAggregationFunction(name);
    }

    @Override
    public List<SqlFunction> listFunctions() {
        return this.functions.list();
    }

    @Override
    public void addFunctions(List<? extends SqlFunction> functionInfos) {
        this.functions.addFunctions(functionInfos);
    }

    @Override
    public List<String> listSchemaNames(Session session, String catalogName) {
        MetadataUtil.checkCatalogName(catalogName);
        ImmutableSet.Builder schemaNames = ImmutableSet.builder();
        for (ConnectorMetadataEntry entry : this.allConnectorsFor(catalogName)) {
            schemaNames.addAll((Iterable)entry.getMetadata().listSchemaNames(session.toConnectorSession(entry.getCatalog())));
        }
        return ImmutableList.copyOf((Collection)schemaNames.build());
    }

    @Override
    public Optional<TableHandle> getTableHandle(Session session, QualifiedObjectName table) {
        ConnectorMetadata metadata;
        ConnectorTableHandle tableHandle;
        Objects.requireNonNull(table, "table is null");
        ConnectorMetadataEntry entry = this.getConnectorFor(table);
        if (entry != null && (tableHandle = (metadata = entry.getMetadata()).getTableHandle(session.toConnectorSession(entry.getCatalog()), table.asSchemaTableName())) != null) {
            return Optional.of(new TableHandle(entry.getConnectorId(), tableHandle));
        }
        return Optional.empty();
    }

    @Override
    public List<TableLayoutResult> getLayouts(Session session, TableHandle table, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        List layouts;
        if (constraint.getSummary().isNone()) {
            return ImmutableList.of();
        }
        TupleDomain summary = constraint.getSummary();
        String connectorId = table.getConnectorId();
        ConnectorTableHandle connectorTable = table.getConnectorHandle();
        Predicate predicate = constraint.predicate();
        ConnectorMetadataEntry entry = this.getConnectorMetadata(connectorId);
        ConnectorSession connectorSession = session.toConnectorSession(entry.getCatalog());
        try {
            layouts = entry.getMetadata().getTableLayouts(connectorSession, connectorTable, new Constraint(summary, predicate::test), desiredColumns);
        }
        catch (UnsupportedOperationException e) {
            ConnectorSplitManager connectorSplitManager = this.splitManager.getConnectorSplitManager(connectorId);
            ConnectorPartitionResult result = connectorSplitManager.getPartitions(connectorSession, connectorTable, summary);
            List partitions = (List)result.getPartitions().stream().filter(partition -> !partition.getTupleDomain().isNone()).filter(partition -> predicate.test(TupleDomain.extractFixedValues((TupleDomain)partition.getTupleDomain()).get())).collect(ImmutableCollectors.toImmutableList());
            List partitionDomains = (List)partitions.stream().map(ConnectorPartition::getTupleDomain).collect(ImmutableCollectors.toImmutableList());
            TupleDomain effectivePredicate = TupleDomain.none();
            if (!partitionDomains.isEmpty()) {
                effectivePredicate = TupleDomain.columnWiseUnion((List)partitionDomains);
            }
            ConnectorTableLayout layout2 = new ConnectorTableLayout((ConnectorTableLayoutHandle)new LegacyTableLayoutHandle(connectorTable, partitions), Optional.empty(), effectivePredicate, Optional.empty(), Optional.of(partitionDomains), (List)ImmutableList.of());
            layouts = ImmutableList.of((Object)new ConnectorTableLayoutResult(layout2, result.getUndeterminedTupleDomain()));
        }
        return (List)layouts.stream().map(layout -> new TableLayoutResult(TableLayout.fromConnectorLayout(connectorId, layout.getTableLayout()), (TupleDomain<ColumnHandle>)layout.getUnenforcedConstraint())).collect(ImmutableCollectors.toImmutableList());
    }

    @Override
    public TableLayout getLayout(Session session, TableLayoutHandle handle) {
        if (handle.getConnectorHandle() instanceof LegacyTableLayoutHandle) {
            LegacyTableLayoutHandle legacyHandle = (LegacyTableLayoutHandle)handle.getConnectorHandle();
            List partitionDomains = (List)legacyHandle.getPartitions().stream().map(ConnectorPartition::getTupleDomain).collect(ImmutableCollectors.toImmutableList());
            TupleDomain predicate = TupleDomain.none();
            if (!partitionDomains.isEmpty()) {
                predicate = TupleDomain.columnWiseUnion((List)partitionDomains);
            }
            return new TableLayout(handle, new ConnectorTableLayout((ConnectorTableLayoutHandle)legacyHandle, Optional.empty(), predicate, Optional.empty(), Optional.of(partitionDomains), (List)ImmutableList.of()));
        }
        String connectorId = handle.getConnectorId();
        ConnectorMetadataEntry entry = this.getConnectorMetadata(connectorId);
        return TableLayout.fromConnectorLayout(connectorId, entry.getMetadata().getTableLayout(session.toConnectorSession(entry.getCatalog()), handle.getConnectorHandle()));
    }

    @Override
    public TableMetadata getTableMetadata(Session session, TableHandle tableHandle) {
        ConnectorMetadataEntry entry = this.lookupConnectorFor(tableHandle);
        ConnectorTableMetadata tableMetadata = entry.getMetadata().getTableMetadata(session.toConnectorSession(entry.getCatalog()), tableHandle.getConnectorHandle());
        return new TableMetadata(tableHandle.getConnectorId(), tableMetadata);
    }

    @Override
    public Map<String, ColumnHandle> getColumnHandles(Session session, TableHandle tableHandle) {
        ConnectorMetadataEntry entry = this.lookupConnectorFor(tableHandle);
        return entry.getMetadata().getColumnHandles(session.toConnectorSession(entry.getCatalog()), tableHandle.getConnectorHandle());
    }

    @Override
    public ColumnMetadata getColumnMetadata(Session session, TableHandle tableHandle, ColumnHandle columnHandle) {
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        Objects.requireNonNull(columnHandle, "columnHandle is null");
        ConnectorMetadataEntry entry = this.lookupConnectorFor(tableHandle);
        return entry.getMetadata().getColumnMetadata(session.toConnectorSession(entry.getCatalog()), tableHandle.getConnectorHandle(), columnHandle);
    }

    @Override
    public List<QualifiedObjectName> listTables(Session session, QualifiedTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        String schemaNameOrNull = prefix.getSchemaName().orElse(null);
        LinkedHashSet<QualifiedObjectName> tables = new LinkedHashSet<QualifiedObjectName>();
        for (ConnectorMetadataEntry entry : this.allConnectorsFor(prefix.getCatalogName())) {
            ConnectorSession connectorSession = session.toConnectorSession(entry.getCatalog());
            for (QualifiedObjectName tableName : Iterables.transform((Iterable)entry.getMetadata().listTables(connectorSession, schemaNameOrNull), QualifiedObjectName.convertFromSchemaTableName(prefix.getCatalogName()))) {
                tables.add(tableName);
            }
        }
        return ImmutableList.copyOf(tables);
    }

    @Override
    public Optional<ColumnHandle> getSampleWeightColumnHandle(Session session, TableHandle tableHandle) {
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        ConnectorMetadataEntry entry = this.lookupConnectorFor(tableHandle);
        ColumnHandle handle = entry.getMetadata().getSampleWeightColumnHandle(session.toConnectorSession(entry.getCatalog()), tableHandle.getConnectorHandle());
        return Optional.ofNullable(handle);
    }

    @Override
    public boolean canCreateSampledTables(Session session, String catalogName) {
        ConnectorMetadataEntry connectorMetadata = (ConnectorMetadataEntry)this.connectorsByCatalog.get(catalogName);
        Preconditions.checkArgument((connectorMetadata != null ? 1 : 0) != 0, (String)"Catalog %s does not exist", (Object[])new Object[]{catalogName});
        return connectorMetadata.getMetadata().canCreateSampledTables(session.toConnectorSession(connectorMetadata.getCatalog()));
    }

    @Override
    public Map<QualifiedObjectName, List<ColumnMetadata>> listTableColumns(Session session, QualifiedTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        SchemaTablePrefix tablePrefix = prefix.asSchemaTablePrefix();
        HashMap tableColumns = new HashMap();
        for (ConnectorMetadataEntry connectorMetadata : this.allConnectorsFor(prefix.getCatalogName())) {
            QualifiedObjectName tableName;
            ConnectorMetadata metadata = connectorMetadata.getMetadata();
            ConnectorSession connectorSession = session.toConnectorSession(connectorMetadata.getCatalog());
            for (Map.Entry entry : metadata.listTableColumns(connectorSession, tablePrefix).entrySet()) {
                tableName = new QualifiedObjectName(prefix.getCatalogName(), ((SchemaTableName)entry.getKey()).getSchemaName(), ((SchemaTableName)entry.getKey()).getTableName());
                tableColumns.put(tableName, entry.getValue());
            }
            for (Map.Entry entry : metadata.getViews(connectorSession, tablePrefix).entrySet()) {
                tableName = new QualifiedObjectName(prefix.getCatalogName(), ((SchemaTableName)entry.getKey()).getSchemaName(), ((SchemaTableName)entry.getKey()).getTableName());
                ImmutableList.Builder columns = ImmutableList.builder();
                for (ViewDefinition.ViewColumn column : this.deserializeView(((ConnectorViewDefinition)entry.getValue()).getViewData()).getColumns()) {
                    columns.add((Object)new ColumnMetadata(column.getName(), column.getType(), false));
                }
                tableColumns.put(tableName, columns.build());
            }
        }
        return ImmutableMap.copyOf(tableColumns);
    }

    @Override
    public void createTable(Session session, String catalogName, TableMetadata tableMetadata) {
        ConnectorMetadataEntry connectorMetadata = (ConnectorMetadataEntry)this.connectorsByCatalog.get(catalogName);
        Preconditions.checkArgument((connectorMetadata != null ? 1 : 0) != 0, (String)"Catalog %s does not exist", (Object[])new Object[]{catalogName});
        connectorMetadata.getMetadata().createTable(session.toConnectorSession(connectorMetadata.getCatalog()), tableMetadata.getMetadata());
    }

    @Override
    public void renameTable(Session session, TableHandle tableHandle, QualifiedObjectName newTableName) {
        String catalogName = newTableName.getCatalogName();
        ConnectorMetadataEntry target = (ConnectorMetadataEntry)this.connectorsByCatalog.get(catalogName);
        if (target == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, String.format("Target catalog '%s' does not exist", catalogName));
        }
        if (!tableHandle.getConnectorId().equals(target.getConnectorId())) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.SYNTAX_ERROR, "Cannot rename tables across catalogs");
        }
        ConnectorMetadataEntry entry = this.lookupConnectorFor(tableHandle);
        entry.getMetadata().renameTable(session.toConnectorSession(entry.getCatalog()), tableHandle.getConnectorHandle(), newTableName.asSchemaTableName());
    }

    @Override
    public void renameColumn(Session session, TableHandle tableHandle, ColumnHandle source, String target) {
        ConnectorMetadataEntry entry = this.lookupConnectorFor(tableHandle);
        entry.getMetadata().renameColumn(session.toConnectorSession(entry.getCatalog()), tableHandle.getConnectorHandle(), source, target.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public void addColumn(Session session, TableHandle tableHandle, ColumnMetadata column) {
        ConnectorMetadataEntry entry = this.lookupConnectorFor(tableHandle);
        entry.getMetadata().addColumn(session.toConnectorSession(entry.getCatalog()), tableHandle.getConnectorHandle(), column);
    }

    @Override
    public void dropTable(Session session, TableHandle tableHandle) {
        ConnectorMetadataEntry entry = this.lookupConnectorFor(tableHandle);
        entry.getMetadata().dropTable(session.toConnectorSession(entry.getCatalog()), tableHandle.getConnectorHandle());
    }

    @Override
    public OutputTableHandle beginCreateTable(Session session, String catalogName, TableMetadata tableMetadata) {
        ConnectorMetadataEntry connectorMetadata = (ConnectorMetadataEntry)this.connectorsByCatalog.get(catalogName);
        Preconditions.checkArgument((connectorMetadata != null ? 1 : 0) != 0, (String)"Catalog %s does not exist", (Object[])new Object[]{catalogName});
        ConnectorSession connectorSession = session.toConnectorSession(connectorMetadata.getCatalog());
        ConnectorOutputTableHandle handle = connectorMetadata.getMetadata().beginCreateTable(connectorSession, tableMetadata.getMetadata());
        return new OutputTableHandle(connectorMetadata.getConnectorId(), handle);
    }

    @Override
    public void commitCreateTable(Session session, OutputTableHandle tableHandle, Collection<Slice> fragments) {
        ConnectorMetadataEntry entry = this.lookupConnectorFor(tableHandle);
        entry.getMetadata().commitCreateTable(session.toConnectorSession(entry.getCatalog()), tableHandle.getConnectorHandle(), fragments);
    }

    @Override
    public void rollbackCreateTable(Session session, OutputTableHandle tableHandle) {
        ConnectorMetadataEntry entry = this.lookupConnectorFor(tableHandle);
        entry.getMetadata().rollbackCreateTable(session.toConnectorSession(entry.getCatalog()), tableHandle.getConnectorHandle());
    }

    @Override
    public InsertTableHandle beginInsert(Session session, TableHandle tableHandle) {
        ConnectorMetadataEntry entry = this.lookupConnectorFor(tableHandle);
        ConnectorInsertTableHandle handle = entry.getMetadata().beginInsert(session.toConnectorSession(entry.getCatalog()), tableHandle.getConnectorHandle());
        return new InsertTableHandle(tableHandle.getConnectorId(), handle);
    }

    @Override
    public void commitInsert(Session session, InsertTableHandle tableHandle, Collection<Slice> fragments) {
        ConnectorMetadataEntry entry = this.lookupConnectorFor(tableHandle);
        entry.getMetadata().commitInsert(session.toConnectorSession(entry.getCatalog()), tableHandle.getConnectorHandle(), fragments);
    }

    @Override
    public void rollbackInsert(Session session, InsertTableHandle tableHandle) {
        ConnectorMetadataEntry entry = this.lookupConnectorFor(tableHandle);
        entry.getMetadata().rollbackInsert(session.toConnectorSession(entry.getCatalog()), tableHandle.getConnectorHandle());
    }

    @Override
    public ColumnHandle getUpdateRowIdColumnHandle(Session session, TableHandle tableHandle) {
        ConnectorMetadataEntry entry = this.lookupConnectorFor(tableHandle);
        return entry.getMetadata().getUpdateRowIdColumnHandle(session.toConnectorSession(entry.getCatalog()), tableHandle.getConnectorHandle());
    }

    @Override
    public boolean supportsMetadataDelete(Session session, TableHandle tableHandle, TableLayoutHandle tableLayoutHandle) {
        ConnectorMetadataEntry entry = this.lookupConnectorFor(tableHandle);
        return entry.getMetadata().supportsMetadataDelete(session.toConnectorSession(entry.getCatalog()), tableHandle.getConnectorHandle(), tableLayoutHandle.getConnectorHandle());
    }

    @Override
    public OptionalLong metadataDelete(Session session, TableHandle tableHandle, TableLayoutHandle tableLayoutHandle) {
        ConnectorMetadataEntry entry = this.lookupConnectorFor(tableHandle);
        return entry.getMetadata().metadataDelete(session.toConnectorSession(entry.getCatalog()), tableHandle.getConnectorHandle(), tableLayoutHandle.getConnectorHandle());
    }

    @Override
    public TableHandle beginDelete(Session session, TableHandle tableHandle) {
        ConnectorMetadataEntry entry = this.lookupConnectorFor(tableHandle);
        ConnectorTableHandle newHandle = entry.getMetadata().beginDelete(session.toConnectorSession(entry.getCatalog()), tableHandle.getConnectorHandle());
        return new TableHandle(tableHandle.getConnectorId(), newHandle);
    }

    @Override
    public void commitDelete(Session session, TableHandle tableHandle, Collection<Slice> fragments) {
        ConnectorMetadataEntry entry = this.lookupConnectorFor(tableHandle);
        entry.getMetadata().commitDelete(session.toConnectorSession(entry.getCatalog()), tableHandle.getConnectorHandle(), fragments);
    }

    @Override
    public void rollbackDelete(Session session, TableHandle tableHandle) {
        ConnectorMetadataEntry entry = this.lookupConnectorFor(tableHandle);
        entry.getMetadata().rollbackDelete(session.toConnectorSession(entry.getCatalog()), tableHandle.getConnectorHandle());
    }

    @Override
    public Map<String, String> getCatalogNames() {
        ImmutableMap.Builder catalogsMap = ImmutableMap.builder();
        for (Map.Entry entry : this.connectorsByCatalog.entrySet()) {
            catalogsMap.put(entry.getKey(), (Object)((ConnectorMetadataEntry)entry.getValue()).getConnectorId());
        }
        return catalogsMap.build();
    }

    @Override
    public List<QualifiedObjectName> listViews(Session session, QualifiedTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        String schemaNameOrNull = prefix.getSchemaName().orElse(null);
        LinkedHashSet<QualifiedObjectName> views = new LinkedHashSet<QualifiedObjectName>();
        for (ConnectorMetadataEntry entry : this.allConnectorsFor(prefix.getCatalogName())) {
            ConnectorSession connectorSession = session.toConnectorSession(entry.getCatalog());
            for (QualifiedObjectName tableName : Iterables.transform((Iterable)entry.getMetadata().listViews(connectorSession, schemaNameOrNull), QualifiedObjectName.convertFromSchemaTableName(prefix.getCatalogName()))) {
                views.add(tableName);
            }
        }
        return ImmutableList.copyOf(views);
    }

    @Override
    public Map<QualifiedObjectName, ViewDefinition> getViews(Session session, QualifiedTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        SchemaTablePrefix tablePrefix = prefix.asSchemaTablePrefix();
        LinkedHashMap<QualifiedObjectName, ViewDefinition> views = new LinkedHashMap<QualifiedObjectName, ViewDefinition>();
        for (ConnectorMetadataEntry metadata : this.allConnectorsFor(prefix.getCatalogName())) {
            ConnectorSession connectorSession = session.toConnectorSession(metadata.getCatalog());
            for (Map.Entry entry : metadata.getMetadata().getViews(connectorSession, tablePrefix).entrySet()) {
                QualifiedObjectName viewName = new QualifiedObjectName(prefix.getCatalogName(), ((SchemaTableName)entry.getKey()).getSchemaName(), ((SchemaTableName)entry.getKey()).getTableName());
                views.put(viewName, this.deserializeView(((ConnectorViewDefinition)entry.getValue()).getViewData()));
            }
        }
        return ImmutableMap.copyOf(views);
    }

    @Override
    public Optional<ViewDefinition> getView(Session session, QualifiedObjectName viewName) {
        ConnectorMetadata metadata;
        Map views;
        ConnectorViewDefinition view;
        ConnectorMetadataEntry entry = this.getConnectorFor(viewName);
        if (entry != null && (view = (ConnectorViewDefinition)(views = (metadata = entry.getMetadata()).getViews(session.toConnectorSession(entry.getCatalog()), viewName.asSchemaTableName().toSchemaTablePrefix())).get(viewName.asSchemaTableName())) != null) {
            return Optional.of(this.deserializeView(view.getViewData()));
        }
        return Optional.empty();
    }

    @Override
    public void createView(Session session, QualifiedObjectName viewName, String viewData, boolean replace) {
        ConnectorMetadataEntry connectorMetadata = (ConnectorMetadataEntry)this.connectorsByCatalog.get(viewName.getCatalogName());
        Preconditions.checkArgument((connectorMetadata != null ? 1 : 0) != 0, (String)"Catalog %s does not exist", (Object[])new Object[]{viewName.getCatalogName()});
        connectorMetadata.getMetadata().createView(session.toConnectorSession(connectorMetadata.getCatalog()), viewName.asSchemaTableName(), viewData, replace);
    }

    @Override
    public void dropView(Session session, QualifiedObjectName viewName) {
        ConnectorMetadataEntry connectorMetadata = (ConnectorMetadataEntry)this.connectorsByCatalog.get(viewName.getCatalogName());
        Preconditions.checkArgument((connectorMetadata != null ? 1 : 0) != 0, (String)"Catalog %s does not exist", (Object[])new Object[]{viewName.getCatalogName()});
        connectorMetadata.getMetadata().dropView(session.toConnectorSession(connectorMetadata.getCatalog()), viewName.asSchemaTableName());
    }

    @Override
    public FunctionRegistry getFunctionRegistry() {
        return this.functions;
    }

    @Override
    public TypeManager getTypeManager() {
        return this.typeManager;
    }

    @Override
    public BlockEncodingSerde getBlockEncodingSerde() {
        return this.blockEncodingSerde;
    }

    @Override
    public SessionPropertyManager getSessionPropertyManager() {
        return this.sessionPropertyManager;
    }

    @Override
    public TablePropertyManager getTablePropertyManager() {
        return this.tablePropertyManager;
    }

    private ViewDefinition deserializeView(String data) {
        try {
            return (ViewDefinition)this.viewCodec.fromJson(data);
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_VIEW, "Invalid view JSON: " + data, (Throwable)e);
        }
    }

    private List<ConnectorMetadataEntry> allConnectorsFor(String catalogName) {
        ConnectorMetadataEntry connector;
        ConnectorMetadataEntry systemTables;
        ImmutableList.Builder builder = ImmutableList.builder();
        ConnectorMetadataEntry entry = (ConnectorMetadataEntry)this.informationSchemasByCatalog.get(catalogName);
        if (entry != null) {
            builder.add((Object)entry);
        }
        if ((systemTables = (ConnectorMetadataEntry)this.systemTablesByCatalog.get(catalogName)) != null) {
            builder.add((Object)systemTables);
        }
        if ((connector = (ConnectorMetadataEntry)this.connectorsByCatalog.get(catalogName)) != null) {
            builder.add((Object)connector);
        }
        return builder.build();
    }

    private ConnectorMetadataEntry getConnectorFor(QualifiedObjectName name) {
        String catalog = name.getCatalogName();
        String schema = name.getSchemaName();
        if (schema.equals(INFORMATION_SCHEMA_NAME)) {
            return (ConnectorMetadataEntry)this.informationSchemasByCatalog.get(catalog);
        }
        ConnectorMetadataEntry entry = (ConnectorMetadataEntry)this.systemTablesByCatalog.get(catalog);
        if (entry != null && entry.getMetadata().getTableHandle(null, name.asSchemaTableName()) != null) {
            return entry;
        }
        return (ConnectorMetadataEntry)this.connectorsByCatalog.get(catalog);
    }

    private ConnectorMetadataEntry lookupConnectorFor(TableHandle tableHandle) {
        return this.getConnectorMetadata(tableHandle.getConnectorId());
    }

    private ConnectorMetadataEntry lookupConnectorFor(OutputTableHandle tableHandle) {
        return this.getConnectorMetadata(tableHandle.getConnectorId());
    }

    private ConnectorMetadataEntry lookupConnectorFor(InsertTableHandle tableHandle) {
        return this.getConnectorMetadata(tableHandle.getConnectorId());
    }

    private ConnectorMetadataEntry getConnectorMetadata(String connectorId) {
        ConnectorMetadataEntry result = (ConnectorMetadataEntry)this.connectorsById.get(connectorId);
        Preconditions.checkArgument((result != null ? 1 : 0) != 0, (String)"No connector for connector ID: %s", (Object[])new Object[]{connectorId});
        return result;
    }

    private static JsonCodec<ViewDefinition> createTestingViewCodec() {
        ObjectMapperProvider provider = new ObjectMapperProvider();
        provider.setJsonDeserializers((Map)ImmutableMap.of(Type.class, (Object)((Object)new TypeDeserializer(new TypeRegistry()))));
        return new JsonCodecFactory((Provider)provider).jsonCodec(ViewDefinition.class);
    }

    private static class ConnectorMetadataEntry {
        private final String connectorId;
        private final String catalog;
        private final ConnectorMetadata metadata;

        private ConnectorMetadataEntry(String connectorId, String catalog, ConnectorMetadata metadata) {
            this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
            this.catalog = Objects.requireNonNull(catalog, "catalog is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        }

        private String getConnectorId() {
            return this.connectorId;
        }

        private String getCatalog() {
            return this.catalog;
        }

        private ConnectorMetadata getMetadata() {
            return this.metadata;
        }
    }
}

