/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.spi.ConnectorPartition;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;

public final class LegacyTableLayoutHandle
implements ConnectorTableLayoutHandle {
    private final ConnectorTableHandle table;
    private final List<ConnectorPartition> partitions;

    @JsonCreator
    public LegacyTableLayoutHandle(@JsonProperty(value="table") ConnectorTableHandle table) {
        Objects.requireNonNull(table, "table is null");
        this.table = table;
        this.partitions = null;
    }

    public LegacyTableLayoutHandle(ConnectorTableHandle table, List<ConnectorPartition> partitions) {
        Objects.requireNonNull(table, "table is null");
        Objects.requireNonNull(partitions, "partitions is null");
        this.table = table;
        this.partitions = partitions;
    }

    @JsonProperty
    public ConnectorTableHandle getTable() {
        return this.table;
    }

    public List<ConnectorPartition> getPartitions() {
        Preconditions.checkState((this.partitions != null ? 1 : 0) != 0, (Object)"Partitions dropped by serialization");
        return this.partitions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LegacyTableLayoutHandle that = (LegacyTableLayoutHandle)o;
        return Objects.equals(this.table, that.table) && Objects.equals(this.partitions, that.partitions);
    }

    public int hashCode() {
        return Objects.hash(this.table, this.partitions);
    }

    public String toString() {
        return this.table.toString();
    }
}

