/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.presto.execution.NodeTaskMap;
import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.execution.scheduler.NetworkLocation;
import com.facebook.presto.execution.scheduler.NodeAssignmentStats;
import com.facebook.presto.execution.scheduler.NodeMap;
import com.facebook.presto.execution.scheduler.NodeScheduler;
import com.facebook.presto.execution.scheduler.NodeSelector;
import com.facebook.presto.execution.scheduler.ResettableRandomizedIterator;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.Node;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.airlift.log.Logger;
import io.airlift.stats.CounterStat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

public class TopologyAwareNodeSelector
implements NodeSelector {
    private static final Logger log = Logger.get(TopologyAwareNodeSelector.class);
    private final NodeManager nodeManager;
    private final NodeTaskMap nodeTaskMap;
    private final boolean includeCoordinator;
    private final boolean doubleScheduling;
    private final AtomicReference<Supplier<NodeMap>> nodeMap;
    private final int minCandidates;
    private final int maxSplitsPerNode;
    private final int maxSplitsPerNodePerTaskWhenFull;
    private final List<CounterStat> topologicalSplitCounters;
    private final List<String> networkLocationSegmentNames;
    private final LoadingCache<HostAddress, NetworkLocation> networkLocationCache;

    public TopologyAwareNodeSelector(NodeManager nodeManager, NodeTaskMap nodeTaskMap, boolean includeCoordinator, boolean doubleScheduling, Supplier<NodeMap> nodeMap, int minCandidates, int maxSplitsPerNode, int maxSplitsPerNodePerTaskWhenFull, List<CounterStat> topologicalSplitCounters, List<String> networkLocationSegmentNames, LoadingCache<HostAddress, NetworkLocation> networkLocationCache) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.nodeTaskMap = Objects.requireNonNull(nodeTaskMap, "nodeTaskMap is null");
        this.includeCoordinator = includeCoordinator;
        this.doubleScheduling = doubleScheduling;
        this.nodeMap = new AtomicReference<Supplier<NodeMap>>(nodeMap);
        this.minCandidates = minCandidates;
        this.maxSplitsPerNode = maxSplitsPerNode;
        this.maxSplitsPerNodePerTaskWhenFull = maxSplitsPerNodePerTaskWhenFull;
        this.topologicalSplitCounters = Objects.requireNonNull(topologicalSplitCounters, "topologicalSplitCounters is null");
        this.networkLocationSegmentNames = Objects.requireNonNull(networkLocationSegmentNames, "networkLocationSegmentNames is null");
        this.networkLocationCache = Objects.requireNonNull(networkLocationCache, "networkLocationCache is null");
    }

    @Override
    public void lockDownNodes() {
        this.nodeMap.set((Supplier<NodeMap>)Suppliers.ofInstance((Object)this.nodeMap.get().get()));
    }

    @Override
    public List<Node> allNodes() {
        return ImmutableList.copyOf((Collection)((NodeMap)this.nodeMap.get().get()).getNodesByHostAndPort().values());
    }

    @Override
    public Node selectCurrentNode() {
        return this.nodeManager.getCurrentNode();
    }

    @Override
    public List<Node> selectRandomNodes(int limit) {
        return NodeScheduler.selectNodes(limit, NodeScheduler.randomizedNodes((NodeMap)this.nodeMap.get().get(), this.includeCoordinator), this.doubleScheduling);
    }

    @Override
    public Multimap<Node, Split> computeAssignments(Set<Split> splits, List<RemoteTask> existingTasks) {
        NodeMap nodeMap = (NodeMap)this.nodeMap.get().get();
        Collection allNodes = nodeMap.getNodesByHostAndPort().values();
        HashMultimap assignment = HashMultimap.create();
        NodeAssignmentStats assignmentStats = new NodeAssignmentStats(this.nodeTaskMap, nodeMap, existingTasks);
        int[] topologicCounters = new int[this.topologicalSplitCounters.size()];
        HashSet<NetworkLocation> filledLocations = new HashSet<NetworkLocation>();
        for (Split split : splits) {
            if (!split.isRemotelyAccessible()) {
                List<Node> candidateNodes = NodeScheduler.selectExactNodes(nodeMap, split.getAddresses(), this.includeCoordinator);
                if (candidateNodes.isEmpty()) {
                    log.debug("No nodes available to schedule %s. Available nodes %s", new Object[]{split, nodeMap.getNodesByHost().keys()});
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NO_NODES_AVAILABLE, "No nodes available to run query");
                }
                Node chosenNode = this.bestNodeSplitCount(candidateNodes.iterator(), this.minCandidates, this.maxSplitsPerNodePerTaskWhenFull, assignmentStats);
                if (chosenNode == null) continue;
                assignment.put((Object)chosenNode, (Object)split);
                assignmentStats.addAssignedSplit(chosenNode);
                continue;
            }
            Node chosenNode = null;
            int depth = this.networkLocationSegmentNames.size();
            int chosenDepth = 0;
            ArrayList<Object> locations = new ArrayList<Object>();
            for (HostAddress host : split.getAddresses()) {
                try {
                    locations.add(this.networkLocationCache.get((Object)host));
                }
                catch (UncheckedExecutionException | ExecutionException throwable) {}
            }
            if (locations.isEmpty()) {
                locations.add(new NetworkLocation(new String[0]));
                depth = 0;
            }
            block4: for (int i = depth; i >= 0 && chosenNode == null; --i) {
                for (NetworkLocation networkLocation : locations) {
                    double queueFraction;
                    NetworkLocation networkLocation2 = networkLocation.subLocation(0, i);
                    if (filledLocations.contains(networkLocation2)) continue;
                    Set nodes = nodeMap.getWorkersByNetworkPath().get((Object)networkLocation2);
                    chosenNode = this.bestNodeSplitCount(new ResettableRandomizedIterator<Node>(nodes), this.minCandidates, (int)Math.ceil((queueFraction = (1.0 + (double)i) / (1.0 + (double)depth)) * (double)this.maxSplitsPerNodePerTaskWhenFull), assignmentStats);
                    if (chosenNode != null) {
                        chosenDepth = i;
                        continue block4;
                    }
                    filledLocations.add(networkLocation2);
                }
            }
            if (chosenNode == null) continue;
            assignment.put(chosenNode, (Object)split);
            assignmentStats.addAssignedSplit(chosenNode);
            int n = chosenDepth;
            topologicCounters[n] = topologicCounters[n] + 1;
        }
        for (int i = 0; i < topologicCounters.length; ++i) {
            if (topologicCounters[i] <= 0) continue;
            this.topologicalSplitCounters.get(i).update((long)topologicCounters[i]);
        }
        return assignment;
    }

    @Nullable
    private Node bestNodeSplitCount(Iterator<Node> candidates, int minCandidatesWhenFull, int maxSplitsPerNodePerTaskWhenFull, NodeAssignmentStats assignmentStats) {
        Node bestQueueNotFull = null;
        int min = Integer.MAX_VALUE;
        for (int fullCandidatesConsidered = 0; candidates.hasNext() && (fullCandidatesConsidered < minCandidatesWhenFull || bestQueueNotFull == null); ++fullCandidatesConsidered) {
            Node node = candidates.next();
            if (assignmentStats.getTotalSplitCount(node) >= this.maxSplitsPerNode) continue;
            return node;
        }
        return bestQueueNotFull;
    }
}

