/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class NetworkLocation {
    private final List<String> segments;

    public NetworkLocation(String ... segments) {
        this(Arrays.asList(segments));
    }

    public NetworkLocation(List<String> segments) {
        Objects.requireNonNull(segments, "segments is null");
        this.segments = ImmutableList.copyOf(segments);
    }

    public NetworkLocation subLocation(int start, int end) {
        return new NetworkLocation(this.segments.subList(start, end));
    }

    public List<String> getSegments() {
        return this.segments;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NetworkLocation that = (NetworkLocation)obj;
        return Objects.equals(this.segments, that.segments);
    }

    public int hashCode() {
        return Objects.hash(this.segments);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("location", (Object)("/" + Joiner.on((String)"/").join(this.segments))).toString();
    }
}

