/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.presto.OutputBuffers;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.scheduler.OutputBufferManager;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class BroadcastOutputBufferManager
implements OutputBufferManager {
    private final Consumer<OutputBuffers> outputBufferTarget;
    @GuardedBy(value="this")
    private OutputBuffers outputBuffers = OutputBuffers.INITIAL_EMPTY_OUTPUT_BUFFERS;

    public BroadcastOutputBufferManager(Consumer<OutputBuffers> outputBufferTarget) {
        this.outputBufferTarget = Objects.requireNonNull(outputBufferTarget, "outputBufferTarget is null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOutputBuffer(TaskId bufferId, int partition) {
        OutputBuffers newOutputBuffers;
        BroadcastOutputBufferManager broadcastOutputBufferManager = this;
        synchronized (broadcastOutputBufferManager) {
            if (this.outputBuffers.isNoMoreBufferIds()) {
                return;
            }
            newOutputBuffers = this.outputBuffers.withBuffer(bufferId, 0);
            if (newOutputBuffers == this.outputBuffers) {
                return;
            }
            this.outputBuffers = newOutputBuffers;
        }
        this.outputBufferTarget.accept(newOutputBuffers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noMoreOutputBuffers() {
        OutputBuffers newOutputBuffers;
        BroadcastOutputBufferManager broadcastOutputBufferManager = this;
        synchronized (broadcastOutputBufferManager) {
            newOutputBuffers = this.outputBuffers.withNoMoreBufferIds();
            if (newOutputBuffers == this.outputBuffers) {
                return;
            }
            this.outputBuffers = newOutputBuffers;
        }
        this.outputBufferTarget.accept(newOutputBuffers);
    }
}

